/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.api.impl.util;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.uc.api.model.IPermission;
import com.artfess.uc.api.util.IPermissionCalc;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionCalc
implements IPermissionCalc {
    private Map<String, IPermission> permissionMap = new HashMap<String, IPermission>();
    private List<IPermission> permissionList = new ArrayList<IPermission>();

    public void setPermissionList(List<IPermission> iPermissions) {
        for (IPermission permission : iPermissions) {
            this.permissionMap.put(permission.getType(), permission);
        }
        this.permissionList = iPermissions;
    }

    public IPermission getPermission(String type) {
        return this.permissionMap.get(type);
    }

    public Map<String, Set<String>> getCurrentProfiles() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (IPermission permission : this.permissionList) {
            Set set = permission.getCurrentProfile();
            if (BeanUtils.isEmpty((Object)set)) continue;
            map.put(permission.getType(), set);
        }
        return map;
    }

    public boolean hasRight(String json, Map<String, Set<String>> currentMap) throws IOException {
        JsonNode jsonObj = JsonUtil.toJsonNode((String)json);
        String type = jsonObj.get("type").asText();
        IPermission permission = this.getPermission(type);
        return permission.hasRight(json, currentMap);
    }
}

