/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.persistence.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.service.PropertyService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.integrate.consts.WeChatWorkConsts;
import com.artfess.integrate.model.WxUser;
import com.artfess.integrate.persistence.manager.IUserService;
import com.artfess.integrate.persistence.manager.IWXOrgService;
import com.artfess.integrate.util.OrgConvertUtil;
import com.artfess.integrate.util.ThreadMessageUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class WxUserService
implements IUserService {
    private final Log logger = LogFactory.getLog(WxUserService.class);
    @Resource
    UCFeignService uCFeignService;
    @Resource
    IWXOrgService iwxOrgService;
    @Resource
    PropertyService propertyService;

    @Override
    public void create(ObjectNode user) throws IOException {
        String fullname = user.get("fullname").asText();
        ArrayNode department = this.uCFeignService.getOrgListByUserId(user.get("userId").asText());
        if (department == null || BeanUtils.isEmpty((Object)department)) {
            user.put("department", "1");
        } else {
            ArrayList<String> arr = new ArrayList<String>();
            for (JsonNode node : department) {
                ObjectNode dept = (ObjectNode)node;
                arr.add(dept.get("id").asText());
            }
            user.put("department", StringUtil.join(arr, (String)","));
        }
        WxUser wxUser = OrgConvertUtil.userToWxUser((JsonNode)user);
        if (BeanUtils.isEmpty((Object)wxUser.getDepartment())) {
            return;
        }
        String resultJson = null;
        resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getCreateUserUrl(), (String)wxUser.toString(), (String)"POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("wxWorkId", user.get("account"));
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        if ("60102".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            userUnite.set("wxWorkId", user.get("account"));
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        if ("60104".equals(errcode)) {
            ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
            userUnite.set("userId", user.get("userId"));
            String errmsg = result.get("errmsg").asText();
            String userid = errmsg.substring(errmsg.indexOf(":") + 1);
            userUnite.put("wxWorkId", userid);
            this.uCFeignService.updateUserUnite(userUnite);
            return;
        }
        String account = user.get("account").asText();
        ThreadMessageUtil.addMapMsg(fullname + "[" + account + "]", result.get("errmsg").asText());
    }

    @Override
    public void update(ObjectNode user) throws IOException {
        WxUser wxUser = OrgConvertUtil.userToWxUser((JsonNode)user);
        String url = WeChatWorkConsts.getUpdateUserUrl();
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)wxUser.toString(), (String)"POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        if (!"0".equals(result.get("errcode").asText())) {
            throw new RuntimeException(wxUser.getName() + "\u66f4\u65b0\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
        }
    }

    @Override
    public void delete(String userId) throws IOException {
        String url = WeChatWorkConsts.getDeleteUserUrl() + userId;
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        if ("0".equals(result.get("errcode").asText())) {
            return;
        }
        throw new RuntimeException(userId + "\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public void deleteAll(String userIds) throws IOException {
    }

    @Override
    public void addAll(JsonNode users) throws IOException {
        for (JsonNode user : users) {
            ObjectNode node = (ObjectNode)user;
            String mobile = user.get("mobile").asText();
            if ("null".equals(mobile) || StringUtil.isEmpty((String)mobile)) continue;
            this.create(node);
        }
    }

    public void invite(String wxUserId) throws IOException {
        ObjectNode inviteData = JsonUtil.getMapper().createObjectNode();
        inviteData.put("userid", wxUserId);
        inviteData.put("invite_tips", this.propertyService.getProperty("wx.invite_tips", "\u5b8f\u5929\u6d41\u7a0b\u4e1a\u52a1\u5e73\u53f0\u9080\u8bf7\u60a8\u5173\u6ce8\uff01"));
        String resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getInviteUserUrl(), (String)inviteData.toString(), (String)"POST");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        if ("0".equals(result.get("errcode").asText())) {
            return;
        }
        this.logger.error((Object)("\u5fae\u4fe1\u9080\u8bf7\u5931\u8d25\uff01" + result.get("errmsg").asText()));
    }

    public boolean queryUser(ObjectNode user) throws IOException {
        String getUserUrl = WeChatWorkConsts.getUserUrl() + user.get("account").asText();
        String resultJsonUser = HttpUtil.sendHttpsRequest((String)getUserUrl, (String)"", (String)"POST");
        JsonNode userJson = JsonUtil.toJsonNode((String)resultJsonUser);
        return "0".equals(userJson.get("errcode").asText());
    }

    @Override
    public void syncUser(String[] lAryId) throws IOException {
        this.iwxOrgService.syncAllOrg();
        ArrayNode userList = (ArrayNode)this.uCFeignService.getUsersNotYetSyncWxWork();
        this.addAll((JsonNode)userList);
    }

    @Override
    public void pullUser(String pOrgId) throws IOException {
        String url = WeChatWorkConsts.getDepartmentListUrl(pOrgId);
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            JsonNode departmentList = result.get("department");
            for (JsonNode o : departmentList) {
                ObjectNode node = (ObjectNode)o;
                String orgId = node.get("id").asText();
                ObjectNode exist = this.uCFeignService.getOrgByIdOrCode(orgId);
                if (exist == null) {
                    exist = JsonUtil.getMapper().createObjectNode();
                    exist.put("id", node.get("id").asText());
                    exist.put("code", node.get("id").asText());
                    exist.put("name", node.get("name").asText());
                    exist.put("parentId", node.get("parentid").asText());
                    exist.put("orderNo", node.get("order").asText());
                    CommonResult orgRsl = this.uCFeignService.addOrgFromExterUni(exist);
                    if (!orgRsl.getState().booleanValue()) {
                        throw new RuntimeException("\u5199\u5165\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + orgRsl.getMessage());
                    }
                }
                this.pullUserByDepartmentId(orgId);
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55\u7684\u7ec4\u7ec7\u67b6\u6784\u5931\u8d25\uff1a" + result.get("errmsg").asText());
        }
    }

    private void pullUserByDepartmentId(String orgId) throws IOException {
        String url = WeChatWorkConsts.getUsersByDepartmentId(orgId, "0");
        String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"GET");
        JsonNode result = JsonUtil.toJsonNode((String)resultJson);
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            JsonNode userlist = result.get("userlist");
            for (JsonNode o : userlist) {
                ObjectNode wxWorkUser = (ObjectNode)o;
                String userid = BeanUtils.isNotEmpty((Object)wxWorkUser.get("userid")) ? wxWorkUser.get("userid").asText() : "";
                String mobile = BeanUtils.isNotEmpty((Object)wxWorkUser.get("mobile")) ? wxWorkUser.get("mobile").asText() : "";
                if (!StringUtil.isNotEmpty((String)mobile)) continue;
                CommonResult userexist = this.uCFeignService.getUserByMobile(mobile);
                if (BeanUtils.isEmpty((Object)userexist) || !userexist.getState().booleanValue()) {
                    ObjectNode newUser = JsonUtil.getMapper().createObjectNode();
                    newUser.put("account", mobile);
                    newUser.put("mobile", mobile);
                    newUser.set("fullname", wxWorkUser.get("name"));
                    newUser.put("password", "123456");
                    JsonNode persistent = this.uCFeignService.addUserFromExterUni(newUser);
                    this.uCFeignService.addUsersForOrg(orgId, mobile);
                    ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
                    userUnite.set("userId", persistent.get("id"));
                    userUnite.put("wxWorkId", userid);
                    this.uCFeignService.updateUserUnite(userUnite);
                    continue;
                }
                ObjectNode userUnite = JsonUtil.getMapper().createObjectNode();
                userUnite.set("userId", ((JsonNode)userexist.getValue()).get("id"));
                userUnite.put("wxWorkId", userid);
                this.uCFeignService.updateUserUnite(userUnite);
            }
        } else {
            throw new RuntimeException("\u83b7\u53d6\u90e8\u95e8id[" + orgId + "]\u7684\u6210\u5458\u5931\u8d25\uff1a" + result.get("errmsg").asText());
        }
    }
}

