/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.model.FilterJsonStruct;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SqlDateFormatUtil;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FilterJsonStructUtil {
    public static String CONDITION_AND = " and ";

    public static String getSql(String filterJson, String dbType) throws JsonParseException, JsonMappingException, IOException {
        if (StringUtil.isEmpty(filterJson)) {
            return "";
        }
        ArrayList<Map<String, Object>> operatorList = new ArrayList<Map<String, Object>>();
        ArrayList<FilterJsonStruct> filters = new ArrayList<FilterJsonStruct>();
        ArrayNode array = (ArrayNode)JsonUtil.toJsonNode(filterJson);
        for (Object json : array) {
            FilterJsonStruct filterJsonStruct = JsonUtil.toBean(JsonUtil.toJson(json), FilterJsonStruct.class);
            filters.add(filterJsonStruct);
        }
        FilterJsonStructUtil.getFilterResult(filters, operatorList, dbType);
        return FilterJsonStructUtil.executeOperator(operatorList);
    }

    private static void getFilterResult(List<FilterJsonStruct> filters, List<Map<String, Object>> operatorList, String dbType) {
        for (FilterJsonStruct filter : filters) {
            if (filter.getBranch().booleanValue()) {
                ArrayList<Map<String, Object>> branchResultList = new ArrayList<Map<String, Object>>();
                FilterJsonStructUtil.getFilterResult(filter.getSub(), branchResultList, dbType);
                String branchResult = FilterJsonStructUtil.executeOperator(branchResultList);
                Map<String, Object> resultMap = FilterJsonStructUtil.getResultMap(filter.getCompType(), branchResult);
                operatorList.add(resultMap);
                continue;
            }
            FilterJsonStructUtil.getNormalFilterResult(filter, operatorList, dbType);
        }
    }

    private static String executeOperator(List<Map<String, Object>> operatorList) {
        if (operatorList.size() == 0) {
            return "";
        }
        String returnVal = (String)operatorList.get(0).get("result");
        if (operatorList.size() == 1) {
            return returnVal;
        }
        int size = operatorList.size();
        for (int k = 1; k < size; ++k) {
            Map<String, Object> resultMap = operatorList.get(k);
            String operator = resultMap.get("operator").toString();
            if ("or".equals(operator)) {
                returnVal = "(" + returnVal + ") OR (" + resultMap.get("result") + ")";
                continue;
            }
            if (!"and".equals(operator)) continue;
            returnVal = "(" + returnVal + ") AND (" + resultMap.get("result") + ")";
        }
        if (StringUtils.isNotEmpty((String)returnVal)) {
            returnVal = "(" + returnVal + ")";
        }
        return returnVal;
    }

    private static Map<String, Object> getResultMap(String operator, String result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("operator", operator);
        resultMap.put("result", result);
        return resultMap;
    }

    private static void getNormalFilterResult(FilterJsonStruct filter, List<Map<String, Object>> operatorList, String dbType) {
        String flowvarKey = filter.getFlowvarKey();
        String judgeVal1 = FilterJsonStructUtil.getJudgeVal(filter, true);
        String judgeVal2 = FilterJsonStructUtil.getJudgeVal(filter, false);
        int optType = filter.getOptType();
        String script = "";
        switch (optType) {
            case 1: {
                if (StringUtils.isNotEmpty((String)judgeVal1)) {
                    script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, judgeVal1, filter.getOptType());
                }
                if (!StringUtils.isNotEmpty((String)judgeVal2)) break;
                String moreScript = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon2(), flowvarKey, judgeVal2, filter.getOptType());
                if (StringUtils.isNotEmpty((String)script)) {
                    script = script + CONDITION_AND;
                }
                script = script + moreScript;
                break;
            }
            case 2: {
                if (!StringUtils.isNotEmpty((String)judgeVal1)) break;
                script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, judgeVal1, filter.getOptType());
                break;
            }
            case 3: {
                if (StringUtils.isNotEmpty((String)judgeVal1)) {
                    String val1 = SqlDateFormatUtil.convertDateFormat(filter.getDatefmt(), judgeVal1, dbType);
                    script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, val1, filter.getOptType());
                }
                if (!StringUtils.isNotEmpty((String)judgeVal2)) break;
                String val2 = SqlDateFormatUtil.convertDateFormat(filter.getDatefmt(), judgeVal1, dbType);
                String moreScript = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon2(), flowvarKey, val2, filter.getOptType());
                if (StringUtils.isNotEmpty((String)script)) {
                    script = script + CONDITION_AND;
                }
                script = script + moreScript;
                break;
            }
            case 4: {
                String[] vals;
                for (String val : vals = judgeVal1.split("&&")) {
                    if (StringUtils.isNotEmpty((String)script)) {
                        script = script + CONDITION_AND;
                    }
                    script = script + FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, val, filter.getOptType());
                }
                break;
            }
            case 5: {
                String judgeCon = filter.getJudgeCon1();
                String[] ids = judgeVal1.split("&&");
                if (ids.length == 2) {
                    script = FilterJsonStructUtil.getCompareScript(judgeCon, filter.getFlowvarKey(), ids[0], filter.getOptType());
                    break;
                }
                if (!"3".equalsIgnoreCase(judgeCon) && !"4".equalsIgnoreCase(judgeCon)) break;
                script = FilterJsonStructUtil.getCompareScript(judgeCon, filter.getFlowvarKey(), judgeVal1, filter.getOptType());
            }
        }
        if (StringUtil.isEmpty(script)) {
            return;
        }
        Map<String, Object> resultMap = FilterJsonStructUtil.getResultMap(filter.getCompType(), script);
        operatorList.add(resultMap);
    }

    private static String getJudgeVal(FilterJsonStruct filter, boolean isJudgeVal1) {
        String val = isJudgeVal1 ? filter.getJudgeVal1() : filter.getJudgeVal2();
        int ruleType = filter.getRuleType();
        if (ruleType == 1) {
            return val;
        }
        GroovyScriptEngine groovyScriptEngine = AppUtil.getBean(GroovyScriptEngine.class);
        String object = groovyScriptEngine.executeString(val, null);
        return object.toString();
    }

    private static String getCompareScript(String judgeCon, String fieldName, String judgeVal, int type) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("'[curUserId]'", AuthenticationUtil.getCurrentUserId());
        varMap.put("'[curUserAccount]'", AuthenticationUtil.getCurrentUsername());
        switch (type) {
            case 1: 
            case 3: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append("=").append(judgeVal);
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append("!=").append(judgeVal);
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append(fieldName).append(">").append(judgeVal);
                    break;
                }
                if ("4".equals(judgeCon)) {
                    sb.append(fieldName).append(">=").append(judgeVal);
                    break;
                }
                if ("5".equals(judgeCon)) {
                    sb.append(fieldName).append("<").append(judgeVal);
                    break;
                }
                if ("6".equals(judgeCon)) {
                    sb.append(fieldName).append("<=").append(judgeVal);
                    break;
                }
                if ("7".equals(judgeCon)) {
                    sb.append(fieldName).append(" = :").append("").append(judgeVal).append("");
                    break;
                }
                if (!"8".equals(judgeCon)) break;
                sb.append(fieldName).append(" != :").append("").append(judgeVal).append("");
                break;
            }
            case 2: 
            case 4: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append("=").append("'").append(judgeVal).append("'");
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append("!=").append("'").append(judgeVal).append("'");
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append("UPPER(").append(fieldName).append(")=").append(" UPPER('").append(judgeVal).append("')");
                    break;
                }
                if ("4".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '%").append(judgeVal).append("%'");
                    break;
                }
                if ("5".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '").append(judgeVal).append("%'");
                    break;
                }
                if ("6".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '%").append(judgeVal).append("'");
                    break;
                }
                if ("7".equals(judgeCon)) {
                    sb.append(fieldName).append(" = '").append(varMap.get(judgeVal)).append("'");
                    break;
                }
                if (!"8".equals(judgeCon)) break;
                sb.append(fieldName).append(" != '").append(varMap.get(judgeVal)).append("'");
                break;
            }
            case 5: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append(" in (").append("").append(judgeVal).append(")");
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append(" not in (").append("").append(judgeVal).append(")");
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append(fieldName).append(" = :").append("").append(judgeVal).append("");
                    break;
                }
                if (!"4".equals(judgeCon)) break;
                sb.append(fieldName).append(" != :").append("").append(judgeVal).append("");
            }
        }
        return sb.toString();
    }
}

