/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.conf.SsoConfig;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.MyX509TrustManager;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ZipUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpUtil {
    private static final String phoneReg = "\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static final String tabletReg = "\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static Pattern phonePat = Pattern.compile("\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b", 2);
    private static Pattern tabletPat = Pattern.compile("\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b", 2);
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = null;
        try {
            requestAttributes = RequestContextHolder.currentRequestAttributes();
        }
        catch (IllegalStateException e) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static String getRequestParameter(String name) {
        HttpServletRequest request = HttpUtil.getRequest();
        if (BeanUtils.isEmpty(request)) {
            return null;
        }
        return request.getParameter(name);
    }

    private static String getTenantIdByAuthorization() {
        HttpServletRequest request = HttpUtil.getRequest();
        if (BeanUtils.isEmpty(request)) {
            return null;
        }
        String requestHeader = request.getHeader("Authorization");
        if (BeanUtils.isNotEmpty(requestHeader) && requestHeader.startsWith("Bearer ")) {
            String authToken = requestHeader.substring(7);
            return HttpUtil.getTenantIdFromJwt(authToken);
        }
        return null;
    }

    private static String getTenantIdFromJwt(String jwt) {
        if (StringUtil.isEmpty(jwt)) {
            return null;
        }
        SaaSConfig saaSConfig = AppUtil.getBean(SaaSConfig.class);
        if (!saaSConfig.isEnable()) {
            return null;
        }
        JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
        String tenantId = jwtTokenHandler.getTenantIdFromToken(jwt);
        if (StringUtil.isNotEmpty(tenantId)) {
            return tenantId;
        }
        return null;
    }

    public static String getTenantId() {
        String tenantId;
        block7: {
            String token;
            block8: {
                HttpServletRequest request = HttpUtil.getRequest();
                if (BeanUtils.isEmpty(request)) {
                    return null;
                }
                Boolean enterController = (Boolean)request.getAttribute("enterController");
                tenantId = null;
                if (!BeanUtils.isNotEmpty(enterController) || !enterController.booleanValue()) break block7;
                tenantId = HttpUtil.getRequestParameter("tenantId");
                if (StringUtil.isNotEmpty(tenantId)) {
                    return tenantId;
                }
                token = HttpUtil.getRequestParameter("ticket");
                SsoConfig ssoConfig = AppUtil.getBean(SsoConfig.class);
                if (!ssoConfig.isEnable()) break block8;
                if (!"jwt".equals(ssoConfig.getMode())) break block7;
            }
            if (StringUtil.isNotEmpty(tenantId = HttpUtil.getTenantIdFromJwt(token))) {
                return tenantId;
            }
        }
        if (StringUtil.isNotEmpty(tenantId = HttpUtil.getTenantIdByAuthorization())) {
            return tenantId;
        }
        return tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadFile(HttpServletResponse response, String fullPath, String fileName) throws IOException {
        ServletOutputStream outp = response.getOutputStream();
        File file = new File(fullPath);
        if (file.exists()) {
            response.setContentType("application/x-download");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            if (System.getProperty("file.encoding").equals("GBK")) {
                response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO-8859-1"));
            } else {
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
            }
            try (FileInputStream in = new FileInputStream(fullPath);){
                IOUtils.copy((InputStream)in, (OutputStream)outp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (outp != null) {
                    outp.close();
                    outp = null;
                    response.flushBuffer();
                }
            }
        } else {
            outp.write("\u6587\u4ef6\u4e0d\u5b58\u5728!".getBytes("utf-8"));
        }
    }

    public static void downLoadFile(HttpServletRequest request, HttpServletResponse response, Map<String, String> fileContentMap, String zipName) throws Exception {
        String zipPath = (FileUtil.getIoTmpdir() + "attachFiles/tempZip/" + zipName).replace("/", File.separator);
        String folderPath = (FileUtil.getIoTmpdir() + "attachFiles/tempZip/" + zipName + "/").replace("/", File.separator);
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        for (Map.Entry<String, String> ent : fileContentMap.entrySet()) {
            String fileName = ent.getKey();
            String content = ent.getValue();
            String filePath = zipPath + File.separator + fileName;
            FileUtil.writeFile(filePath, content);
        }
        ZipUtil.zip(zipPath, true);
        HttpUtil.downLoadFile(response, zipPath + ".zip", zipName + ".zip");
        FileUtil.deleteFile(zipPath + ".zip");
    }

    public static void downLoadFile(HttpServletRequest request, HttpServletResponse response, String content, String fileName, String zipName) throws Exception {
        HashMap<String, String> fileContentMap = new HashMap<String, String>();
        fileContentMap.put(fileName, content);
        HttpUtil.downLoadFile(request, response, fileContentMap, zipName);
    }

    public static String sendHttpsRequest(String url, String params, String requestMethod) {
        String str = null;
        try {
            HttpsURLConnection conn = HttpUtil.getHttpsConnection(url);
            conn.setRequestMethod(requestMethod);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            if (StringUtil.isNotEmpty(params)) {
                OutputStream outputStream = conn.getOutputStream();
                outputStream.write(params.getBytes("utf-8"));
                outputStream.close();
            }
            str = HttpUtil.getOutPut(conn);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("\u8fdc\u7a0b\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u8fdc\u7a0b\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("\u8fdc\u7a0b\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8fdc\u7a0b\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return str;
    }

    public static HttpsURLConnection getHttpsConnection(String accessUrl) throws KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        URL url = new URL(accessUrl);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
        sslContext.init(null, tm, new SecureRandom());
        SSLSocketFactory ssf = sslContext.getSocketFactory();
        connection.setSSLSocketFactory(ssf);
        return connection;
    }

    public static String getOutPut(HttpsURLConnection conn) throws IOException {
        InputStream inputStream = conn.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer buffer = new StringBuffer();
        String str = null;
        while ((str = bufferedReader.readLine()) != null) {
            buffer.append(str);
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
        conn.disconnect();
        return buffer.toString();
    }

    public static String getContentByUrl(String url, String charset) throws IOException {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        if (StringUtil.isEmpty(charset)) {
            String defaultCharset = "iso-8859-1";
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            String contentType = contentTypeHeader.getValue().toLowerCase();
            if (contentType.indexOf("gbk") > -1 || contentType.indexOf("gb2312") > -1 || contentType.indexOf("gb18030") > -1) {
                defaultCharset = "gb18030";
            } else if (contentType.indexOf("utf-8") > -1) {
                defaultCharset = "utf-8";
            } else if (contentType.indexOf("big5") > -1) {
                defaultCharset = "big5";
            }
            charset = defaultCharset;
        }
        Header contentEncoding = response.getFirstHeader("Content-Encoding");
        StatusLine line = response.getStatusLine();
        if (line.getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            InputStream is = null;
            is = contentEncoding != null && contentEncoding.getValue().toLowerCase().equals("gzip") ? new GZIPInputStream(entity.getContent()) : entity.getContent();
            String str = FileUtil.inputStream2String(is, charset);
            is.close();
            return str;
        }
        return "";
    }

    public static String sendData(String url, String data) {
        return HttpUtil.sendData(url, data, "utf-8");
    }

    public static String sendData(String url, String data, String charset) {
        BufferedReader bufferedReader = null;
        try {
            String line;
            URL uRL = new URL(url);
            URLConnection conn = uRL.openConnection();
            conn.setDoOutput(true);
            if (StringUtil.isNotEmpty(data)) {
                OutputStream stream = conn.getOutputStream();
                stream.write(data.getBytes(charset));
                stream.flush();
                stream.close();
            }
            bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                response.append(line);
            }
            bufferedReader.close();
            return response.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isMobile(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (null == userAgent) {
            userAgent = "";
        }
        return phonePat.matcher(userAgent).find() || tabletPat.matcher(userAgent).find();
    }
}

