/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.statistics.manager.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.QueryFilter;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.basedata.model.BizRoadsideFacilities;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.open.base.vo.DataVo;
import com.artfess.yhxt.open.base.vo.RetutnVo;
import com.artfess.yhxt.statistics.dao.BaseDataStatisticsMapper;
import com.artfess.yhxt.statistics.dao.CamerasResourceDao;
import com.artfess.yhxt.statistics.dao.WorkStatisticDao;
import com.artfess.yhxt.statistics.manager.BaseDataStatisticsManager;
import com.artfess.yhxt.statistics.manager.CamerasResourceManager;
import com.artfess.yhxt.statistics.model.CamerasRequest;
import com.artfess.yhxt.statistics.model.CamerasResource;
import com.artfess.yhxt.statistics.model.PreviewURLsRequest;
import com.artfess.yhxt.statistics.model.YearBudgetSum;
import com.artfess.yhxt.statistics.vo.BaseDataParamVo;
import com.artfess.yhxt.statistics.vo.CompanyUserVo;
import com.artfess.yhxt.statistics.vo.CountMileageVo;
import com.artfess.yhxt.statistics.vo.CountRoadsideFacilities;
import com.artfess.yhxt.statistics.vo.CountVehicleVo;
import com.artfess.yhxt.statistics.vo.MaintenanceStationVo;
import com.artfess.yhxt.statistics.vo.MileageVo;
import com.artfess.yhxt.statistics.vo.VehicleQuantityVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hikvision.artemis.sdk.ArtemisHttpUtil;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseDataStatisticsManagerImpl
implements BaseDataStatisticsManager {
    @Resource
    private BaseDataStatisticsMapper baseDataStatisticsMapper;
    @Resource
    private RoadManager roadManager;
    @Resource
    private WorkStatisticDao WorkStatisticDao;
    @Resource
    private CamerasResourceManager camerasResourceManager;
    @Resource
    private CamerasResourceDao camerasResourceDao;
    private final String parentId = "1419863231459102720";
    private static final String ARTEMIS_PATH = "/artemis";

    @Override
    public Map<String, List> getBridgeStatistics(Map<String, Object> map) {
        List<Map<String, Object>> bridgeType = this.baseDataStatisticsMapper.getBridgeType(map);
        List<Map<String, Object>> bridgeShapeType = this.baseDataStatisticsMapper.getBridgeShapeType(map);
        List<Map<String, Object>> bridgeCategory = this.baseDataStatisticsMapper.getBridgeCategory(map);
        HashMap<String, List> listMap = new HashMap<String, List>();
        listMap.put("bridgeType", bridgeType);
        listMap.put("bridgeShapeType", bridgeShapeType);
        listMap.put("category", bridgeCategory);
        return listMap;
    }

    @Override
    public void export(HttpServletResponse response, Map<String, Object> map) throws Exception {
        List<Map<String, Object>> bridgeShapeType = this.baseDataStatisticsMapper.getBridgeShapeType(map);
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("shapeTypeValue", "\u4e0a\u90e8\u7ed3\u6784\u540d\u79f0");
        exportMap.put("shapeTypeCount", "\u6570\u91cf");
        exportMap.put("length", "\u5355\u4f4d\u603b\u957f(m)");
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u4e0a\u90e8\u7ed3\u6784\u4fe1\u606f", (int)22, exportMap, bridgeShapeType);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u4e0a\u90e8\u7ed3\u6784\u4fe1\u606f\u5bfc\u51fa", (HttpServletResponse)response);
    }

    @Override
    public Map<String, List> getAllStructureCount(Map<String, Object> map) {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List<Map<String, Object>> sideSlop = this.baseDataStatisticsMapper.getSideSlopeCount(map);
        List<Map<String, Object>> roadsideFacilities = this.baseDataStatisticsMapper.getRoadsideFacilities(map);
        List<Map<String, Object>> roadsideFacilitiesTollStation = this.baseDataStatisticsMapper.getRoadsideFacilitiesTollStation(map);
        List<Map<String, Object>> roadsideFacilitiesServiceArea = this.baseDataStatisticsMapper.getRoadsideFacilitiesServiceArea(map);
        List<Map<String, Object>> roadSection = this.baseDataStatisticsMapper.getRoadSection(map);
        List<Map<String, Object>> bridge = this.baseDataStatisticsMapper.getBridge(map);
        List<Map<String, Object>> tunnel = this.baseDataStatisticsMapper.getTunnel(map);
        List<Map<String, Object>> culvert = this.baseDataStatisticsMapper.getCulvert(map);
        hashMap.put("sideSlop", sideSlop);
        hashMap.put("roadsideFacilities", roadsideFacilities);
        hashMap.put("roadsideFacilitiesTollStation", roadsideFacilitiesTollStation);
        hashMap.put("roadsideFacilitiesServiceArea", roadsideFacilitiesServiceArea);
        hashMap.put("roadSection", roadSection);
        hashMap.put("bridge", bridge);
        hashMap.put("tunnel", tunnel);
        hashMap.put("culvert", culvert);
        return hashMap;
    }

    @Override
    public Map<String, List> getSideSlopCompany() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List<Map<String, Object>> sideSlop = this.baseDataStatisticsMapper.getSideSlopCompany();
        hashMap.put("sideSlop", sideSlop);
        return hashMap;
    }

    @Override
    public Map<String, List> getRoadsideFacilitiesCompany() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List<Map<String, Object>> roadsideFacilities = this.baseDataStatisticsMapper.getRoadsideFacilitiesCompany();
        hashMap.put("roadsideFacilities", roadsideFacilities);
        return hashMap;
    }

    @Override
    public Map<String, List> getRoadSectionCompany() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List<Map<String, Object>> roadSection = this.baseDataStatisticsMapper.getRoadSectionCompany();
        hashMap.put("roadSection", roadSection);
        return hashMap;
    }

    @Override
    public Map<String, List> getBridgeCompany() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List<Map<String, Object>> bridge = this.baseDataStatisticsMapper.getBridgeCompany();
        hashMap.put("bridge", bridge);
        return hashMap;
    }

    @Override
    public Map<String, List> getTunnelCompany() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List<Map<String, Object>> tunnel = this.baseDataStatisticsMapper.getTunnelCompany();
        hashMap.put("tunnel", tunnel);
        return hashMap;
    }

    @Override
    public Map<String, List> getCulvertCompany() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List<Map<String, Object>> culvert = this.baseDataStatisticsMapper.getCulvertCompany();
        hashMap.put("culvert", culvert);
        return hashMap;
    }

    @Override
    public Map<String, List> getBridgeTunnelCountRanking() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List<Map<String, Object>> bridgeCountRanking = this.baseDataStatisticsMapper.getBridgeCountRanking();
        List<Map<String, Object>> tunnelCountRanking = this.baseDataStatisticsMapper.getTunnelCountRanking();
        hashMap.put("bridgeCountRanking", bridgeCountRanking);
        hashMap.put("tunnelCountRanking", tunnelCountRanking);
        return hashMap;
    }

    @Override
    public Map<String, List> getTunnelStatistics(Map<String, Object> map) {
        List<Map<String, Object>> tunnelType = this.baseDataStatisticsMapper.getTunnelType(map);
        List<Map<String, Object>> tunnelGrade = this.baseDataStatisticsMapper.getTunnelGrade(map);
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put("tunnelType", tunnelType);
        hashMap.put("tunnelGrade", tunnelGrade);
        return hashMap;
    }

    @Override
    public List<MileageVo> getRoadMileageCount(BaseDataParamVo baseDataParamVo) {
        List<MileageVo> mileageVos = this.baseDataStatisticsMapper.getRoadMileageCount(baseDataParamVo);
        return mileageVos;
    }

    @Override
    public List<MaintenanceStationVo> getMaintenanceStation(BaseDataParamVo baseDataParamVo) throws Exception {
        List<MaintenanceStationVo> maintenanceStationVos = this.baseDataStatisticsMapper.getMaintenanceStationCount(baseDataParamVo);
        return maintenanceStationVos;
    }

    @Override
    public List<CompanyUserVo> getUserCount(BaseDataParamVo baseDataParamVo) {
        ArrayList<CompanyUserVo> companyUserVos = new ArrayList<CompanyUserVo>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(ObjectUtils.isNotEmpty((Object)baseDataParamVo.getCompanyId()), (Object)"COMPANY_ID", (Object)baseDataParamVo.getCompanyId());
        queryWrapper.eq(ObjectUtils.isNotEmpty((Object)baseDataParamVo.getRoadSegmentId()), (Object)"ID_", (Object)baseDataParamVo.getRoadSegmentId());
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            for (Road road : list) {
                baseDataParamVo.setRoadSegmentId(road.getId());
                CompanyUserVo companyUserVo = this.baseDataStatisticsMapper.selectRoadSegmentUser(baseDataParamVo);
                companyUserVo.setRoadSegmentId(road.getId());
                companyUserVo.setRoadSegmentName(road.getName());
                companyUserVos.add(companyUserVo);
            }
        }
        return companyUserVos;
    }

    @Override
    public String getRoad(QueryFilter queryFilter) {
        Map map = queryFilter.getParams();
        List<Road> roadList = this.baseDataStatisticsMapper.getRoad(map);
        StringBuilder str = new StringBuilder();
        System.out.println(str);
        for (Road road : roadList) {
            str.append("[").append(road.getCode()).append(",").append(road.getName()).append(",").append(road.getStartingPoint()).append(",").append(road.getTerminalPoint()).append(",").append(road.getLength()).append("],");
        }
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            String substring = str.substring(0, str.length() - 1);
            return substring;
        }
        return "";
    }

    @Override
    public String getRoadsideFacilities(QueryFilter queryFilter) {
        Map map = queryFilter.getParams();
        List<BizRoadsideFacilities> roadsides = this.baseDataStatisticsMapper.getRoadside(map);
        String str = "";
        for (BizRoadsideFacilities roadside : roadsides) {
            str = str + "[" + roadside.getCompanyName() + "," + roadside.getTypeValue() + "," + roadside.getDirectionValue() + "," + roadside.getPeg() + "," + roadside.getRoadSegmentName() + "],";
        }
        String substring = "";
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            substring = str.substring(0, str.length() - 1);
        }
        return substring;
    }

    @Override
    public String getSideSlop(QueryFilter queryFilter) {
        Map map = queryFilter.getParams();
        List<SideSlopeInformation> sideSlopeInformations = this.baseDataStatisticsMapper.getSideSlop(map);
        String str = "";
        for (SideSlopeInformation sideSlopeInformation : sideSlopeInformations) {
            str = str + "[" + sideSlopeInformation.getNumber() + "," + sideSlopeInformation.getRoadSegmentName() + "," + sideSlopeInformation.getEndPeg() + "," + sideSlopeInformation.getStartPeg() + "," + sideSlopeInformation.getHeight() + "],";
        }
        String substring = "";
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            substring = str.substring(0, str.length() - 1);
        }
        return substring;
    }

    @Override
    public String getBridgeInformation(QueryFilter queryFilter) {
        Map map = queryFilter.getParams();
        List<BridgeInformation> bridgeInformationList = this.baseDataStatisticsMapper.getBridgeInformation(map);
        String str = "";
        for (BridgeInformation bridgeInformation : bridgeInformationList) {
            str = str + "[" + bridgeInformation.getNumber() + "," + bridgeInformation.getName() + "," + bridgeInformation.getDirectionValue() + "," + bridgeInformation.getTypeValue() + "," + bridgeInformation.getCategoryValue() + "," + bridgeInformation.getLength() + "],";
        }
        String substring = "";
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            substring = str.substring(0, str.length() - 1);
        }
        return substring;
    }

    @Override
    public String getTunnelInformation(QueryFilter queryFilter) {
        Map map = queryFilter.getParams();
        List<TunnelInformation> tunnelInformationList = this.baseDataStatisticsMapper.getTunnelInformation(map);
        String str = "";
        for (TunnelInformation tunnelInformation : tunnelInformationList) {
            str = str + "[" + tunnelInformation.getNumber() + "," + tunnelInformation.getName() + "," + tunnelInformation.getLength() + "," + tunnelInformation.getTypeValue() + "," + tunnelInformation.getGradeValue() + "],";
        }
        String substring = "";
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            substring = str.substring(0, str.length() - 1);
        }
        return substring;
    }

    @Override
    public String getCulvertInformation(QueryFilter queryFilter) {
        Map map = queryFilter.getParams();
        List<BizCulvertInformation> culvertInformationList = this.baseDataStatisticsMapper.getCulvertInformation(map);
        String str = "";
        for (BizCulvertInformation culvertInformation : culvertInformationList) {
            str = str + "[" + culvertInformation.getNumber() + "," + culvertInformation.getHeight() + "," + culvertInformation.getLength() + "," + culvertInformation.getUsesValue() + "," + culvertInformation.getTypeValue() + "],";
        }
        String substring = "";
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            substring = str.substring(0, str.length() - 1);
        }
        return substring;
    }

    @Override
    public Map getPreviewURLs(PreviewURLsRequest pr) {
        if (null == pr) {
            pr = new PreviewURLsRequest();
        }
        if (StringUtils.isBlank((CharSequence)pr.getExpand())) {
            pr.setExpand("transcode=0");
        }
        if (StringUtils.isBlank((CharSequence)pr.getProtocol())) {
            pr.setProtocol("ws");
        }
        if (StringUtils.isBlank((CharSequence)String.valueOf(pr.getTransmode()))) {
            pr.setTransmode(1);
        }
        String str = this.previewURLs(pr);
        Map map = (Map)JSONObject.parseObject((String)str, Map.class);
        return map;
    }

    @Override
    public List<CountRoadsideFacilities> countRoadsideFacilities(BaseDataParamVo baseDataParamVo) {
        List<CountRoadsideFacilities> countRoadsideFacilitiesList = this.baseDataStatisticsMapper.countRoadsideFacilities(baseDataParamVo);
        return countRoadsideFacilitiesList;
    }

    @Override
    public List<CountVehicleVo> countVehicle(QueryFilter queryFilter) {
        Map params = queryFilter.getParams();
        ArrayList<CountVehicleVo> countVehicleVos = new ArrayList<CountVehicleVo>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("companyId")), (Object)"COMPANY_ID", params.get("companyId"));
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("roadSegmentId")), (Object)"ID_", params.get("roadSegmentId"));
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            for (Road road : list) {
                Integer countVehicle = this.baseDataStatisticsMapper.countVehicle(params, road.getId());
                CountVehicleVo countVehicleVo = new CountVehicleVo();
                countVehicleVo.setCountVehicle(String.valueOf(countVehicle));
                countVehicleVo.setRoadSegmentId(road.getId());
                countVehicleVo.setRoadSegmentName(road.getName());
                countVehicleVos.add(countVehicleVo);
            }
        }
        return countVehicleVos;
    }

    @Override
    public List<CountMileageVo> countAvgMileage(QueryFilter queryFilter) {
        Map params = queryFilter.getParams();
        Object roadSegmentId = params.get("roadSegmentId");
        ArrayList<CountMileageVo> countMileageVos = new ArrayList<CountMileageVo>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("companyId")), (Object)"COMPANY_ID", params.get("companyId"));
        queryWrapper.eq(ObjectUtils.isNotEmpty(params.get("roadSegmentId")), (Object)"ID_", params.get("roadSegmentId"));
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.roadManager.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            for (Road road : list) {
                List<YearBudgetSum> yearBudgetJson;
                CountMileageVo countMileageVo = new CountMileageVo();
                if (ObjectUtils.isEmpty(roadSegmentId)) {
                    params.put("roadSegmentId", road.getId());
                }
                if ((yearBudgetJson = this.WorkStatisticDao.getYearBudgetJson(params)).size() > 0) {
                    String alreadyCount = yearBudgetJson.get(0).getAlreadyCount();
                    BigDecimal totalMoney = new BigDecimal(alreadyCount);
                    Map sumMileage = this.baseDataStatisticsMapper.countMileage(params);
                    Object mileage = sumMileage.get("mileage");
                    countMileageVo.setTotalMoney(totalMoney);
                    BigDecimal divide = totalMoney.multiply(new BigDecimal(1000)).divide((BigDecimal)mileage, 2);
                    countMileageVo.setMileage((BigDecimal)mileage);
                    countMileageVo.setDivide(divide);
                }
                countMileageVo.setRoadSegmentId(road.getId());
                countMileageVo.setRoadSegmentName(road.getName());
                countMileageVos.add(countMileageVo);
            }
        }
        return countMileageVos;
    }

    @Override
    public List<VehicleQuantityVo> countVehicleQuantity() {
        return this.baseDataStatisticsMapper.countVehicleQuantity();
    }

    public String previewURLs(PreviewURLsRequest previewURLsRequest) {
        final String previewURLsDataApi = "/artemis/api/video/v1/cameras/previewURLs";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", previewURLsDataApi);
            }
        };
        String body = JSON.toJSONString((Object)previewURLsRequest);
        String result = ArtemisHttpUtil.doPostStringArtemis((Map)path, (String)body, null, null, (String)"application/json");
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void getCameras(CamerasRequest camerasRequest) {
        final String camerasApiUrl = "/artemis/api/resource/v1/cameras";
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("https://", camerasApiUrl);
            }
        };
        if (null == camerasRequest.getPageNo()) {
            camerasRequest.setPageSize(1);
        }
        if (null == camerasRequest.getPageNo()) {
            camerasRequest.setPageNo(1);
        }
        if (null == camerasRequest.getTreeCode()) {
            camerasRequest.setTreeCode("0");
        }
        String body = JSON.toJSONString((Object)camerasRequest);
        String result = ArtemisHttpUtil.doPostStringArtemis((Map)path, (String)body, null, null, (String)"application/json");
        RetutnVo retutnVo = (RetutnVo)JSONUtil.toBean((String)result, RetutnVo.class);
        DataVo data = retutnVo.getData();
        Integer total = data.getTotal();
        int pageSize = 100;
        int pageNo = total / pageSize;
        int yushu = total % pageSize;
        if (yushu > 0) {
            ++pageNo;
        }
        camerasRequest.setPageNo(pageNo);
        camerasRequest.setPageSize(pageSize);
        for (int i = 0; i < pageNo; ++i) {
            camerasRequest.setPageNo(i + 1);
            String bodyi = JSON.toJSONString((Object)camerasRequest);
            String resulti = ArtemisHttpUtil.doPostStringArtemis((Map)path, (String)bodyi, null, null, (String)"application/json");
            RetutnVo retutnVoi = (RetutnVo)JSONUtil.toBean((String)resulti, RetutnVo.class);
            DataVo datai = retutnVoi.getData();
            List<CamerasResource> list = datai.getList();
            if (null == list || list.isEmpty()) continue;
            this.camerasResourceManager.saveOrUpdateBatch(list);
        }
    }

    static {
        ArtemisConfig.host = "183.64.175.153:446";
        ArtemisConfig.appKey = "29900884";
        ArtemisConfig.appSecret = "osPf2dpzAP9a59VQWGi6";
    }
}

