package com.artfess.cqxy.projectManagement.dao;

import com.artfess.cqxy.projectManagement.model.ProjectPersonnel;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目人员中间表(BizProjectPersonnel)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-02-12 14:41:17
 */
public interface ProjectPersonnelDao extends BaseMapper<ProjectPersonnel> {

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ProjectPersonnelVo> queryAllByPage(IPage<ProjectPersonnel> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ProjectPersonnel> convert2Wrapper);

    /**
     * 所有用户，用于添加项目时添加所有用户到中间表以及添加时的用户选择
     * @param projectId 项目ID 添加选择人员时，传入对应项目ID以列出不在该项目中的人员以供添加；
     *                  新建项目将链接所有用户时 传入空串即可
     * @return 项目人员Vo
     */
    List<ProjectPersonnelVo> getAllUsers(String projectId);

    /**
     * 通过ID获取VO对象
     * @param id ID
     * @return VO对象
     */
    ProjectPersonnelVo getVoById(String id);

    /**
     * 根据项目ID查询人员ID集合
     * @param projectId
     * @return
     */
    List<String> getProjectPersonnelByProjectId(String projectId);

    /**
     * 根据人员ID查询项目ID集合
     * @param personnelId
     * @return
     */
    List<String> getProjectByPersonnelId(String personnelId);
}

