export declare enum EnableEnum {
    ENABLE = 1,
    DISABLE = 0
}
export interface IEffectPage {
    imSessionList: EnableEnum;
    docPreview: EnableEnum;
    h5PageOther: EnableEnum;
    meetingDetail: EnableEnum;
    h5PageBasic: EnableEnum;
    selectionComponent: EnableEnum;
    contactList: EnableEnum;
    contactDetail: EnableEnum;
    chat: EnableEnum;
    secretChat: EnableEnum;
    camera: EnableEnum;
}
export interface IWatermarkContent {
    customCopy: string;
    enablePhoneNumber: EnableEnum;
    enableUsername: EnableEnum;
}
export interface IWatermarkStyle {
    showDensity: number;
    fontStyle: number;
    tiltAngle: number;
    leftAndRightSpacing: number;
    transparency: number;
    upAndDownSpacing: number;
    fontSize: number;
    fontColor: string;
}
export interface IRuleContent {
    enable: EnableEnum;
    effectPage: IEffectPage;
    watermarkContent: IWatermarkContent;
    watermarkStyle: IWatermarkStyle;
}
export interface IWaterMark {
    ruleContent: IRuleContent;
}
export interface IUserInfo {
    userName: string;
    lastFourPhoneNo: string;
}
export interface IGetWaterMarkConfigV2Res {
    watermark: IWaterMark;
    userInfo: IUserInfo;
    isDegrade: boolean;
}
declare function getWaterMarkConfigV2(args: {
    pageInfo?: string;
}): Promise<IGetWaterMarkConfigV2Res>;
declare namespace getWaterMarkConfigV2 {
    var version: {
        android: string;
        ios: string;
        pc: string;
    };
}
export default getWaterMarkConfigV2;
