export declare enum SelectVersionEnum {
    DEFAULT = 1,
    NEW = 2
}
export declare enum PanelTypeEnum {
    GLOBAL_ORG = 1,
    FRIEND = 2,
    GROUP = 4,
    RECOMMEND = 5,
    SPECIAL_ATTENTION = 7,
    LOAD_GROUP_PERSON = 8,
    ORG = 9
}
export declare enum VisibilityCodesEnum {
    PHONE_HIDE = "PHONE_HIDE",
    CHAT_INVALID = "CHAT_INVALID",
    GROUP_CHAT_PULL_INVALID = "GROUP_CHAT_PULL_INVALID",
    APP_DING_INVALID = "APP_DING_INVALID",
    PHONE_DING_INVALID = "PHONE_DING_INVALID",
    SMS_DING_INVALID = "SMS_DING_INVALID",
    AUDIO_VIDEO_HIDE = "AUDIO_VIDEO_HIDE"
}
export interface RequestChooseContactParams {
    multiple?: boolean;
    users?: Array<string>;
    max?: number;
    responseUserOnly?: boolean;
    limitTips?: string;
    title?: string;
    pickedUsers?: string[];
    requiredUsers?: string[];
    disabledUsers?: string[];
    selectVersion?: SelectVersionEnum;
    panelTypes?: PanelTypeEnum[];
    visibilityCodes?: VisibilityCodesEnum;
    enableExternalUser?: boolean;
}
export interface ChooseContactResultItem {
    name: string;
    avatar: string;
    emplId: string;
}
declare function chooseContact(args: RequestChooseContactParams): Promise<ChooseContactResultItem[]>;
declare namespace chooseContact {
    var version: {
        pc: string;
    };
}
export default chooseContact;
