/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.report.bigScreen.manager.impl;

import com.artfess.base.dao.CommonDao;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.interceptor.MasterSlaveAutoRoutingPlugin;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.report.bigScreen.dao.BladeVisualConfigDao;
import com.artfess.report.bigScreen.manager.BladeVisualConfigManager;
import com.artfess.report.bigScreen.model.BladeVisualConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

@Service
public class BladeVisualConfigManagerImpl
extends BaseManagerImpl<BladeVisualConfigDao, BladeVisualConfig>
implements BladeVisualConfigManager {
    @Resource
    CommonDao commonDao;

    @Override
    public List<Map<String, Object>> query(String sql) {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sql", sql);
        if (MasterSlaveAutoRoutingPlugin.getInExternalDatasource()) {
            PlatformTransactionManager transactionManager = (PlatformTransactionManager)AppUtil.getBean(TransactionManager.class);
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)def);
            try {
                List result = this.commonDao.query(map);
                transactionManager.commit(status);
                return result;
            }
            catch (Exception e) {
                transactionManager.rollback(status);
                throw new BaseException(ResponseErrorEnums.DATABASE_ERROR, (Throwable)e);
            }
        }
        return this.commonDao.query(map);
    }
}

