package com.artfess.base.conf;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Component;

@Component
public class ServerInfo {
    private final ServerProperties serverProperties;

    @Autowired
    public ServerInfo(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public String getServerAddress() {
        return serverProperties.getAddress().getHostName();
    }

    public int getServerPort() {
        return serverProperties.getPort();
    }
}
