import { getDictionaryByCode } from '@/utils/dictionary.ts'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '客户名称',
            prop: 'companyName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '状态',
            prop: 'status',
            type: 'select',
            multiple: true,
            options: getDictionaryByCode('gysgl-zt'),
            span: 4,
            value: []
        },
        {
            title: '申请时间',
            prop: 'submitDate',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 5,
            value: []
        },
        {
            title: '邀请时间',
            prop: 'applyDate',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 5,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '客户名称',
            prop: 'companyName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '拟供应物资类型',
            prop: 'materialCategoryName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '状态',
            prop: 'status',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '申请时间',
            prop: 'submitDate',
            minWidth: 120,
            sortable: true
        },
        {
            title: '邀请时间',
            prop: 'applyDate',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
