/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.api.impl.service;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.impl.service.UserCacheImpl;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Primary
@Service
public class UserServiceImpl
implements IUserService {
    @Resource
    UCFeignService ucFeignService;
    @Resource
    UserCacheImpl userCacheImpl;

    private ObjectNode getObjectNode() {
        return JsonUtil.getMapper().createObjectNode();
    }

    public IUser getUserById(String userId) {
        try {
            UserFacade userfacade = this.userCacheImpl.getUserFromCacheById(userId);
            if (userfacade != null) {
                return userfacade;
            }
            CommonResult ObjectNode2 = this.ucFeignService.getUserById(userId);
            if (ObjectNode2.getState().booleanValue()) {
                userfacade = (UserFacade)JsonUtil.toBean((JsonNode)((JsonNode)ObjectNode2.getValue()), UserFacade.class);
                this.userCacheImpl.putUserInCache((UserDetails)userfacade);
                return userfacade;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public IUser getUserByAccount(String account) {
        try {
            JsonNode result = this.ucFeignService.getUser(account, "");
            if (BeanUtils.isEmpty((Object)result)) {
                return null;
            }
            UserFacade bean = (UserFacade)JsonUtil.toBean((JsonNode)result, UserFacade.class);
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<IUser> getUserByAccounts(String accounts) {
        ObjectNode params = this.getObjectNode();
        params.put("accounts", accounts);
        try {
            ArrayNode node = this.ucFeignService.getUserByAccounts(accounts);
            ArrayList<IUser> bean = new ArrayList<IUser>();
            for (JsonNode j : node) {
                bean.add((IUser)JsonUtil.toBean((JsonNode)j, UserFacade.class));
            }
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<IUser> getUserListByGroup(String groupType, String groupId) {
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        if (groupType.equals(GroupTypeConstant.ORG.key())) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("org_id_", (Object)groupId, QueryOP.EQUAL);
            result = this.ucFeignService.getAllOrgUsers(queryFilter);
        }
        if (groupType.equals(GroupTypeConstant.ROLE.key())) {
            result = this.ucFeignService.getUsersByRoleCode(groupId);
        }
        if (groupType.equals(GroupTypeConstant.POSITION.key())) {
            result = this.ucFeignService.getUserByPost(groupId);
        }
        if (groupType.equals(GroupTypeConstant.JOB.key())) {
            result = this.ucFeignService.getUsersByJob(groupId);
        }
        if (BeanUtils.isEmpty((Object)result)) {
            return new ArrayList<IUser>();
        }
        List list = null;
        try {
            list = (List)JsonUtil.toBean((String)(!groupType.equals(GroupTypeConstant.ORG.key()) ? JsonUtil.toJson((Object)result) : JsonUtil.toJson((Object)result.get("rows"))), (TypeReference)new TypeReference<List<UserFacade>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        ArrayList<IUser> Ilist = new ArrayList<IUser>();
        for (UserFacade user : list) {
            Ilist.add(user);
        }
        return Ilist;
    }

    public List<IUser> getUserListByGroups(String groupType, String groupIds) {
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        result = this.ucFeignService.getAllOrgsUsers(groupIds);
        if (BeanUtils.isEmpty((Object)result)) {
            return new ArrayList<IUser>();
        }
        List list = null;
        try {
            list = (List)JsonUtil.toBean((String)(!groupType.equals(GroupTypeConstant.ORG.key()) ? JsonUtil.toJson((Object)result) : JsonUtil.toJson((Object)result.get("rows"))), (TypeReference)new TypeReference<List<UserFacade>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        ArrayList<IUser> Ilist = new ArrayList<IUser>();
        for (UserFacade user : list) {
            Ilist.add(user);
        }
        return Ilist;
    }

    public List<IUser> getByEmail(String email) {
        ObjectNode params = this.getObjectNode();
        params.put("email", email);
        List list = null;
        try {
            ArrayNode result = this.ucFeignService.getUserByEmail(email);
            list = (List)JsonUtil.toBean((String)JsonUtil.toJson((Object)result), (TypeReference)new TypeReference<List<UserFacade>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        ArrayList<IUser> Ilist = new ArrayList<IUser>();
        if (BeanUtils.isNotEmpty((Object)list)) {
            for (UserFacade user : list) {
                Ilist.add(user);
            }
        }
        return Ilist;
    }

    public IUser getSuperior(String underId, String demId) {
        try {
            JsonNode result = this.ucFeignService.getSuperior(underId, demId);
            if (BeanUtils.isEmpty((Object)result)) {
                return null;
            }
            UserFacade bean = (UserFacade)JsonUtil.toBean((JsonNode)result, UserFacade.class);
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object getMainPostOrOrgByUserId(String startId) {
        try {
            ObjectNode result = this.ucFeignService.getMainPostOrOrgByUserId(startId);
            if (BeanUtils.isEmpty((Object)result)) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object getSuperiorPost(String userId) {
        try {
            JsonNode result = this.ucFeignService.getSuperiorPost(userId);
            if (BeanUtils.isEmpty((Object)result)) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<IUser> getUserByIds(String userIds) {
        try {
            ArrayNode ObjectNode2 = this.ucFeignService.getUserByIds(userIds);
            ArrayList<IUser> bean = new ArrayList<IUser>();
            if (BeanUtils.isNotEmpty((Object)ObjectNode2)) {
                for (JsonNode j : ObjectNode2) {
                    bean.add((IUser)JsonUtil.toBean((JsonNode)j, UserFacade.class));
                }
            }
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<IUser> findByPostIds(String posIds) {
        try {
            ArrayNode ObjectNode2 = this.ucFeignService.findByPostIds(posIds);
            ArrayList<IUser> bean = new ArrayList<IUser>();
            if (BeanUtils.isNotEmpty((Object)ObjectNode2)) {
                for (JsonNode j : ObjectNode2) {
                    bean.add((IUser)JsonUtil.toBean((JsonNode)j, UserFacade.class));
                }
            }
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

