/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadUtil.class);

    public static void fileDownload(HttpServletResponse response, File file, String fileName) throws Exception {
        byte[] data = FileUtil.readAsByteArray((File)file);
        FileDownloadUtil.fileDownload(response, data, fileName);
    }

    public static void fileDownload(HttpServletResponse response, InputStream inputStream, String fileName) throws Exception {
        byte[] data = FileUtil.readAsByteArray((InputStream)inputStream);
        FileDownloadUtil.fileDownload(response, data, fileName);
    }

    public static void fileDownload(HttpServletResponse response, byte[] data, String fileName) throws Exception {
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        response.setHeader("Access-Control-Allow-origin", "*");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream;charset=UTF-8");
        BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ((OutputStream)outputStream).write(data);
        ((OutputStream)outputStream).flush();
        ((OutputStream)outputStream).close();
        response.flushBuffer();
    }

    public static void writeResponseFile(HttpServletRequest request, HttpServletResponse response, byte[] result, String fileName) {
        String currentFileName;
        try {
            currentFileName = StringUtils.isBlank((CharSequence)fileName) ? "temp" : URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            currentFileName = "temp";
        }
        response.setHeader("Content-Length", "" + result.length);
        response.setContentType("application/octet-stream;charset=utf-8");
        response.addHeader("Content-Disposition", "attachment;fileName=" + FileDownloadUtil.encodeFileName(request, currentFileName));
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(result);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static String encodeFileName(HttpServletRequest request, String fileName) {
        String agent = request.getHeader("User-Agent");
        if (StringUtils.isBlank((CharSequence)agent)) {
            try {
                return URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (agent.contains("Firefox") || agent.contains("Safari")) {
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        } else if (agent.contains("Chrome")) {
            try {
                fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return fileName;
    }
}

