/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.helper.identity;

import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.helper.identity.BpmIdentityBuilder;
import com.artfess.bpm.api.helper.identity.BpmIdentityConverter;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BpmIdentityExtractServiceImpl
implements BpmIdentityExtractService {
    @Resource
    BpmIdentityConverter bpmIdentityConverter;
    @Resource
    BpmIdentityBuilder bpmIdentityBuilder;
    @Resource
    IUserService userServiceImpl;

    @Override
    public List<BpmIdentity> extractUserGroup(List<BpmIdentity> bpmIdentities) {
        ArrayList<BpmIdentity> results = new ArrayList<BpmIdentity>();
        StringBuffer sb = new StringBuffer();
        StringBuffer sbName = new StringBuffer();
        for (BpmIdentity bpmIdentity : bpmIdentities) {
            if (!bpmIdentity.getType().equals("user")) continue;
            sb.append(bpmIdentity.getId()).append(",");
            sbName.append(bpmIdentity.getName()).append(",");
        }
        if (StringUtil.isEmpty((String)sb.toString())) {
            return results;
        }
        String userGroup = sb.toString().substring(0, sb.length() - 1);
        String userGroupName = sbName.toString().substring(0, sbName.length() - 1);
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setId(userGroup);
        bpmIdentity.setType("groupUser");
        bpmIdentity.setName(userGroupName);
        results.add(bpmIdentity);
        return results;
    }

    @Override
    public List<BpmIdentity> extractBpmIdentity(List<BpmIdentity> bpmIdentities) {
        ArrayList<BpmIdentity> results = new ArrayList<BpmIdentity>();
        for (BpmIdentity bpmIdentity : bpmIdentities) {
            if (bpmIdentity.getType().equals("group")) {
                String id = StringUtil.isNotEmpty((String)bpmIdentity.getId()) ? bpmIdentity.getId() : bpmIdentity.getCode();
                List users = this.userServiceImpl.getUserListByGroup(bpmIdentity.getGroupType(), id);
                List<BpmIdentity> tempBpmIdentities = this.bpmIdentityConverter.convertUserList(users);
                results.addAll(tempBpmIdentities);
                continue;
            }
            if (!"user".equals(bpmIdentity.getType())) continue;
            results.add(bpmIdentity);
        }
        return results;
    }

    @Override
    public List<IUser> extractUser(List<BpmIdentity> bpmIdentities) {
        ArrayList<IUser> results = new ArrayList<IUser>();
        for (BpmIdentity bpmIdentity : bpmIdentities) {
            if (bpmIdentity.getType().equals("group")) {
                List users = this.userServiceImpl.getUserListByGroup(bpmIdentity.getGroupType(), bpmIdentity.getId());
                results.addAll(users);
                continue;
            }
            if ("user".equals(bpmIdentity.getType())) {
                IUser user = this.userServiceImpl.getUserById(bpmIdentity.getId());
                results.add(user);
                continue;
            }
            if (!bpmIdentity.getType().equals("groupUser")) continue;
            results.addAll(this.userServiceImpl.getUserByIds(bpmIdentity.getId()));
        }
        return results;
    }
}

