/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.persistence.dao.BpmCustomSignDataDao;
import com.artfess.bpm.persistence.manager.BpmCustomSignDataManager;
import com.artfess.bpm.persistence.model.BpmCustomSignData;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmCustomSignDataManager")
public class BpmCustomSignDataManagerImpl
extends BaseManagerImpl<BpmCustomSignDataDao, BpmCustomSignData>
implements BpmCustomSignDataManager {
    @Resource
    BpmCustomSignDataDao bpmCustomSignDataDao;

    @Override
    @Transactional
    public void addCustomSignData(BpmTask task, String preTaskId) {
        BpmCustomSignData curSignData;
        BpmCustomSignData signData = new BpmCustomSignData();
        String id = UniqueIdUtil.getSuid();
        String path = id + ".";
        String parentId = null;
        String type = "";
        String status = task.getStatus();
        String customSignStatus = null;
        if (TaskType.SIGNLINEED.getKey().equals(status)) {
            type = "Parallel";
        }
        if (TaskType.SIGNSEQUENCEED.getKey().equals(status)) {
            type = "Sequential";
            customSignStatus = "complete";
        }
        if (TaskType.APPROVELINEED.getKey().equals(status)) {
            type = "ParallelApprove";
            path = null;
        }
        if (BeanUtils.isNotEmpty((Object)preTaskId) && !TaskType.APPROVELINEED.getKey().equals(status) && BeanUtils.isNotEmpty((Object)((Object)(curSignData = this.bpmCustomSignDataDao.getByTaskIdAndStatus(preTaskId, customSignStatus))))) {
            path = curSignData.getPath() + path;
            parentId = curSignData.getId();
        }
        signData.setId(id);
        signData.setTaskId(task.getTaskId());
        signData.setStatus("approval");
        signData.setInstId(task.getProcInstId());
        signData.setNodeId(task.getNodeId());
        signData.setParentId(parentId);
        signData.setPath(path);
        signData.setType(type);
        super.create((Model)signData);
    }

    @Override
    @Transactional
    public void addCustomSignDatas(BpmTask task, String preTaskId, List<BpmIdentity> idList) {
        idList.forEach(item -> this.addCustomSignData(task, preTaskId));
    }

    @Override
    public List<BpmCustomSignData> getByInstIdAndStatus(String instId, String status) {
        return this.bpmCustomSignDataDao.getByInstIdAndStatus(instId, status);
    }

    @Override
    @Transactional
    public void updateStatusByTaskId(String taskId, List<String> oldStatus, String newStatus, String newCreateTaskId) {
        this.bpmCustomSignDataDao.updateStatusByTaskId(taskId, oldStatus, newStatus, newCreateTaskId);
    }

    @Override
    @Transactional
    public void updateStatusByTaskId(String taskId, String oldStatus, String newStatus, String newCreateTaskId) {
        this.updateStatusByTaskId(taskId, Arrays.asList(oldStatus), newStatus, newCreateTaskId);
    }

    @Override
    public List<BpmCustomSignData> getByInstIdAndStatus(String instId, List<String> status) {
        return this.bpmCustomSignDataDao.getByInstIdAndStatusList(instId, status);
    }

    @Override
    @Transactional
    public void updateStatusByInstId(String instId, List<String> oldStatusList, String newStatus) {
        this.bpmCustomSignDataDao.updateStatusByInstId(instId, oldStatusList, newStatus);
    }

    @Override
    public BpmCustomSignData getSequentialSonByTaskId(String taskId) {
        return this.bpmCustomSignDataDao.getSequentialSonByTaskId(taskId);
    }

    @Override
    public List<BpmCustomSignData> getSignDataByBeforeSignTaskId(String instId, String taskId) {
        return this.bpmCustomSignDataDao.getSignDataByBeforeSignTaskId(instId, taskId);
    }

    @Override
    @Transactional
    public void removeByInstId(String instId) {
        this.bpmCustomSignDataDao.removeByInstId(instId);
    }

    @Override
    public List<BpmCustomSignData> getParallelSonByTaskId(String taskId) {
        BpmCustomSignData completeSignData = this.bpmCustomSignDataDao.getByTaskIdAndStatus(taskId, "complete");
        return this.bpmCustomSignDataDao.getParallelSonByPath(completeSignData.getPath());
    }

    @Override
    public List<BpmCustomSignData> getParallelAllSonByTaskId(String taskId) {
        BpmCustomSignData completeSignData = this.bpmCustomSignDataDao.getByTaskIdAndStatus(taskId, "complete");
        if (completeSignData == null) {
            return null;
        }
        return this.bpmCustomSignDataDao.getParallelAllSonByPath(completeSignData.getPath());
    }

    @Override
    public List<BpmCustomSignData> getAllSignDataByBeforeSignTaskId(String instanceId, String taskId) {
        return this.bpmCustomSignDataDao.getAllSignDataByBeforeSignTaskId(instanceId, taskId);
    }

    @Override
    public List<BpmCustomSignData> getBrotherByTaskId(String taskId, List<String> status) {
        return this.bpmCustomSignDataDao.getBrotherByTaskId(taskId, status);
    }
}

