/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.form;

import com.artfess.base.feign.FormFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.model.HtJsonNodeFactory;
import com.artfess.base.model.HtObjectNode;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.process.def.FieldInitSetting;
import com.artfess.bpm.api.model.process.def.FormInitItem;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.DataObjectHandler;
import com.artfess.bpm.engine.def.BpmDefUtil;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.util.BoDataUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DefaultDataObjectHandler
implements DataObjectHandler {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BoDataService boDataService;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    GroovyScriptEngine groovyScriptEngine;

    @Override
    public void handShowData(String defId, List<ObjectNode> boDatas) throws Exception {
        FormInitItem formInitItem = this.getFormInitItem(defId);
        List<FieldInitSetting> fieldInitSettings = this.getFieldSetting(formInitItem, true);
        if (fieldInitSettings == null) {
            return;
        }
        this.setDataObject(fieldInitSettings, boDatas);
    }

    @Override
    public void handSaveData(BpmProcessInstance instance, List<ObjectNode> boDatas) throws Exception {
        FormInitItem formInitItem = this.getFormInitItem(instance.getProcDefId());
        List<FieldInitSetting> fieldInitSettings = this.getFieldSetting(formInitItem, false);
        if (fieldInitSettings == null) {
            return;
        }
        this.addUnUseBoData(instance, boDatas);
        this.setDataObject(fieldInitSettings, boDatas);
    }

    @Override
    public void handSaveData(BpmProcessInstance instance, String nodeId, List<ObjectNode> boDatas) throws Exception {
        FormInitItem formInitItem = this.getFormInitItem(instance, nodeId);
        List<FieldInitSetting> fieldInitSettings = this.getFieldSetting(formInitItem, false);
        if (fieldInitSettings == null) {
            return;
        }
        this.addUnUseBoData(instance, boDatas);
        this.setDataObject(fieldInitSettings, boDatas);
    }

    private void addUnUseBoData(BpmProcessInstance instance, List<ObjectNode> boDatas) throws Exception {
        DefaultBpmProcessDefExt defExt = BpmDefUtil.getProcessExt(instance);
        String saveMode = defExt.isBoSaveToDb() ? "database" : "boObject";
        List<ProcBoDef> boList = defExt.getBoDefList();
        ArrayList<String> boDefCodes = new ArrayList<String>();
        for (ProcBoDef procBoDef : boList) {
            boDefCodes.add(procBoDef.getKey());
        }
        ObjectNode jsonObject = (ObjectNode)BoDataUtil.hanlerData(boDatas);
        for (String boDefCode : boDefCodes) {
            if (jsonObject.findValue(boDefCode) != null) continue;
            ObjectNode boData = this.formRestfulService.getBodataByDefCode(saveMode, boDefCode);
            ObjectNode boDef = this.formRestfulService.getBodefByAlias(boDefCode);
            ObjectNode boEnt = (ObjectNode)boDef.get("boEnt");
            boData.set("boEnt", (JsonNode)boEnt);
            boDatas.add(boData);
        }
    }

    private void setDataObject(List<FieldInitSetting> fieldInitSettings, List<ObjectNode> boDatas) throws IOException {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (ObjectNode boData : boDatas) {
            String boDefCode = "";
            boDefCode = boData.has("boDef") ? boData.get("boDef").get("alias").asText() : boData.get("boDefAlias").asText();
            HtJsonNodeFactory factory = new HtJsonNodeFactory();
            HtObjectNode htBodata = factory.htObjectNode(boData);
            vars.put(boDefCode, htBodata);
        }
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isNotEmpty((Object)cmd)) {
            vars.putAll(cmd.getVariables());
        }
        for (FieldInitSetting setting : fieldInitSettings) {
            String script = setting.getSetting();
            if (StringUtil.isEmpty((String)script)) continue;
            this.groovyScriptEngine.execute(script, vars);
        }
        if (BeanUtils.isNotEmpty((Object)cmd)) {
            cmd.setBusData(BoDataUtil.hanlerData(boDatas).toString());
        }
    }

    @Override
    public void handShowData(BpmProcessInstance instance, String nodeId, List<ObjectNode> boDatas) throws Exception {
        FormInitItem formInitItem = this.getFormInitItem(instance, nodeId);
        List<FieldInitSetting> fieldInitSettings = this.getFieldSetting(formInitItem, true);
        if (fieldInitSettings == null) {
            return;
        }
        this.setDataObject(fieldInitSettings, boDatas);
    }

    private FormInitItem getFormInitItem(BpmProcessInstance instance, String nodeId) throws Exception {
        BpmProcessInstance topInstance;
        String defKey;
        FormInitItem formInitItem = null;
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), nodeId);
        if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId()) && (formInitItem = bpmNodeDef.getFormInitItemByParentKey(defKey = (topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance)).getProcDefKey())) != null) {
            return formInitItem;
        }
        return bpmNodeDef.getFormInitItem();
    }

    private FormInitItem getFormInitItem(String defId) throws Exception {
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getStartEvent(defId);
        return bpmNodeDef.getFormInitItem();
    }

    private List<FieldInitSetting> getFieldSetting(FormInitItem formInitItem, boolean isShow) {
        if (formInitItem == null) {
            return null;
        }
        if (isShow) {
            return formInitItem.getShowFieldsSetting();
        }
        return formInitItem.getSaveFieldsSetting();
    }
}

