/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.service;

import com.alibaba.druid.util.StringUtils;
import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.Restful;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.artfess.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.artfess.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.RestfulService;
import com.artfess.bpm.engine.identity.DefaultBpmIdentityService;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.persistence.manager.BpmCallLogManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.BpmCallLog;
import com.artfess.bpm.persistence.model.BpmIdentityResult;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.util.BoDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DefaultRestfulService
implements RestfulService {
    private static Logger log = LoggerFactory.getLogger(DefaultRestfulService.class);
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    DefaultBpmIdentityService bpmIdentityService;
    @Resource
    BpmCallLogManager bpmCallLogManager;
    @Resource
    BpmIdentityExtractService extractService;
    @Resource
    BoDataService boDataService;
    @Resource
    NatProInstanceService natProInstanceService;

    @Override
    public Void taskPluginExecute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef, List<Restful> restfuls) {
        try {
            EventType eventType = pluginSession.getEventType();
            BpmDelegateTask bpmDelegateTask = pluginSession.getBpmDelegateTask();
            for (Restful restful : restfuls) {
                String callTime = restful.getCallTime();
                if (StringUtils.isEmpty((CharSequence)callTime) || !callTime.contains(eventType.getKey())) continue;
                RestfulParam param = null;
                param = this.genartor(bpmDelegateTask, eventType);
                param.setTimestamp(System.currentTimeMillis());
                param.setEventType(eventType.getKey());
                String url = restful.getUrl();
                if (!BeanUtils.isNotEmpty((Object)url)) continue;
                BpmCallLog callLog = this.getCallLog(param, restful);
                if (restful.getInvokeMode() == 1) {
                    if (BeanUtils.isNotEmpty(param.getVars()) && BeanUtils.isNotEmpty((Object)param.getVars().get("restful_task"))) {
                        param.getVars().remove("restful_task");
                    }
                    this.postAsync(url, JsonUtil.toJson((Object)param), restful.getHeader(), callLog);
                    continue;
                }
                Boolean isSuccess = true;
                try {
                    String post = this.post(url, JsonUtil.toJson((Object)param), restful.getHeader(), callLog);
                    callLog.setResponse(post);
                }
                catch (Exception e) {
                    isSuccess = false;
                    callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                callLog.setIsSuccess(isSuccess != false ? BpmCallLog.SUCCESS_YES : BpmCallLog.SUCCESS_NO);
                this.buildCallLog(callLog);
            }
        }
        catch (Exception ex) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            log.error("[\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38]:" + rootCauseMessage);
            throw new WorkFlowException(rootCauseMessage);
        }
        return null;
    }

    @Override
    public Void executionPluginExecute(BpmExecutionPluginSession pluginSession, BpmExecutionPluginDef pluginDef, List<Restful> restfuls) {
        try {
            EventType eventType = pluginSession.getEventType();
            BpmDelegateExecution belegateExecution = pluginSession.getBpmDelegateExecution();
            for (Restful restful : restfuls) {
                String callTime = restful.getCallTime();
                String callNode = restful.getCallNodes();
                if (StringUtils.isEmpty((CharSequence)callTime) || !callTime.contains(eventType.getKey()) || !this.isGlobalNode(belegateExecution, callNode, eventType)) continue;
                RestfulParam param = null;
                param = this.genartor(belegateExecution, eventType);
                param.setTimestamp(System.currentTimeMillis());
                param.setEventType(eventType.getKey());
                String url = restful.getUrl();
                if (!BeanUtils.isNotEmpty((Object)url)) continue;
                BpmCallLog callLog = this.getCallLog(param, restful);
                if (restful.getInvokeMode() == 1) {
                    this.postAsync(url, JsonUtil.toJson((Object)param), restful.getHeader(), callLog);
                    continue;
                }
                Boolean isSuccess = true;
                try {
                    String post = this.post(url, JsonUtil.toJson((Object)param), restful.getHeader(), callLog);
                    callLog.setResponse(post);
                    this.buildCallLog(callLog);
                }
                catch (Exception e) {
                    callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    isSuccess = false;
                }
                callLog.setIsSuccess(isSuccess != false ? BpmCallLog.SUCCESS_YES : BpmCallLog.SUCCESS_NO);
                this.buildCallLog(callLog);
            }
        }
        catch (Exception ex) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            log.error("[\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38]:" + rootCauseMessage);
            throw new WorkFlowException(rootCauseMessage);
        }
        return null;
    }

    @Override
    public Void outTaskPluginExecute(BpmTask task, List<Restful> restfuls, EventType eventType) {
        try {
            for (Restful restful : restfuls) {
                String callTime = restful.getCallTime();
                if (StringUtils.isEmpty((CharSequence)callTime) || !callTime.contains(eventType.getKey())) continue;
                RestfulParam param = null;
                param = this.genartor(task, eventType);
                param.setTimestamp(System.currentTimeMillis());
                param.setEventType(eventType.getKey());
                String url = restful.getUrl();
                if (!BeanUtils.isNotEmpty((Object)url)) continue;
                BpmCallLog callLog = this.getCallLog(param, restful);
                if (restful.getInvokeMode() == 1) {
                    this.postAsync(url, JsonUtil.toJson((Object)param), restful.getHeader(), callLog);
                    continue;
                }
                Boolean isSuccess = true;
                try {
                    String post = this.post(url, JsonUtil.toJson((Object)param), restful.getHeader(), callLog);
                    callLog.setResponse(post);
                }
                catch (Exception e) {
                    isSuccess = false;
                    callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                callLog.setIsSuccess(isSuccess != false ? BpmCallLog.SUCCESS_YES : BpmCallLog.SUCCESS_NO);
                this.buildCallLog(callLog);
            }
        }
        catch (Exception ex) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            log.error("[\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38]:" + rootCauseMessage);
            throw new WorkFlowException(rootCauseMessage);
        }
        return null;
    }

    private BpmCallLog getCallLog(RestfulParam param, Restful restful) {
        BpmCallLog callLog = new BpmCallLog();
        callLog.setId(UniqueIdUtil.getSuid());
        callLog.setSubject(param.getSubject());
        callLog.setProcDefId(param.getProcDefId());
        callLog.setEventType(param.getEventType());
        callLog.setProcDefKey(param.getFlowKey());
        callLog.setTaskId(param.getTaskId());
        callLog.setProcInstId(param.getInstId());
        callLog.setTaskKey(param.getNodeId());
        callLog.setTaskName(param.getNodeName());
        callLog.setUrl(restful.getUrl());
        callLog.setDesc(restful.getDesc());
        callLog.setInvokeMode(restful.getInvokeMode());
        callLog.setCallTime(LocalDateTime.now());
        callLog.setUserId(ContextUtil.getCurrentUserId());
        return callLog;
    }

    private String postAsync(String url, String params, String headerStr, BpmCallLog callLog) {
        String postMsg = "";
        callLog.setHeader(headerStr);
        callLog.setParams(params);
        try {
            class RestfulPostAsync {
                private String url;
                private String params;
                private String header;
                private String result;
                private BpmCallLog callLog;

                public RestfulPostAsync(String url, String params, String header, BpmCallLog callLog) {
                    this.url = url;
                    this.params = params;
                    this.header = header;
                    this.callLog = callLog;
                }

                public String getResult() {
                    return this.result;
                }

                public void toPost() {
                    new Thread(){

                        @Override
                        public void run() {
                            callLog.setCallTime(LocalDateTime.now());
                            Boolean isSuccess = true;
                            try {
                                String response = DefaultRestfulService.this.post(url, params, header, callLog);
                                callLog.setResponse(response);
                            }
                            catch (Exception e) {
                                isSuccess = false;
                                callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)e));
                            }
                            callLog.setIsSuccess(isSuccess != false ? BpmCallLog.SUCCESS_YES : BpmCallLog.SUCCESS_NO);
                            DefaultRestfulService.this.buildCallLog(callLog);
                        }
                    }.start();
                }
            }
            RestfulPostAsync restfulPost = new RestfulPostAsync(url, params, headerStr, callLog);
            restfulPost.toPost();
            postMsg = restfulPost.getResult();
        }
        catch (Exception ex) {
            callLog.setCallTime(LocalDateTime.now());
            callLog.setIsSuccess(BpmCallLog.SUCCESS_NO);
            callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)ex));
            this.buildCallLog(callLog);
        }
        return postMsg;
    }

    private Request setHeaders(Request request, String headerStr) {
        if (StringUtil.isNotEmpty((String)headerStr)) {
            try {
                headerStr = Base64.getFromBase64((String)headerStr);
                if (StringUtil.isEmpty((String)headerStr) || "\"\"".equals(headerStr)) {
                    return request;
                }
                ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)headerStr);
                Iterator it = obj.fieldNames();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    request.setHeader(key, obj.get(key).asText());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return request;
    }

    private String post(String url, String params, String headerStr, BpmCallLog callLog) throws ClientProtocolException, IOException {
        Request request = Request.Post((String)url);
        callLog.setHeader(headerStr);
        callLog.setParams(params);
        request = this.setHeaders(request, headerStr);
        String response = request.bodyString(params, ContentType.APPLICATION_JSON).execute().returnContent().toString();
        return response;
    }

    private void buildCallLog(BpmCallLog callLog) {
        try {
            if (StringUtil.isNotEmpty((String)callLog.getResponse()) && callLog.getResponse().length() > 1999) {
                callLog.setResponse(callLog.getResponse().substring(0, 1999));
            }
            callLog.setRetryCount(0);
            this.bpmCallLogManager.create((Model)callLog);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58restful\u63a5\u53e3\u4e8b\u4ef6\u8c03\u7528\u65e5\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private boolean isGlobalNode(BpmDelegateExecution execution, String callNodes, EventType eventType) {
        String nodeId;
        if (EventType.START_EVENT.getKey().equals(eventType.getKey()) || EventType.END_EVENT.getKey().equals(eventType.getKey())) {
            return true;
        }
        if (execution.isEnded()) {
            return true;
        }
        String string = nodeId = StringUtil.isNotEmpty((String)execution.getNodeId()) ? execution.getNodeId() : "";
        if (StringUtil.isNotEmpty((String)nodeId)) {
            return StringUtil.isEmpty((String)callNodes) || callNodes.contains(nodeId);
        }
        return true;
    }

    private RestfulParam genartor(BpmDelegateExecution execution, EventType eventType) {
        DefaultBpmProcessInstance defaultBpmProcessInstance;
        BpmDelegateTask delegateTask;
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        RestfulParam param = new RestfulParam();
        String instId = (String)execution.getVariable("instanceId_");
        param.setActionName(taskCmd.getActionName());
        param.setNodeId(execution.getNodeId());
        param.setNodeName(execution.getNodeName());
        if ((EventType.TASK_COMPLETE_EVENT.equals((Object)eventType) || EventType.TASK_CREATE_EVENT.equals((Object)eventType)) && BeanUtils.isNotEmpty((Object)(delegateTask = (BpmDelegateTask)taskCmd.getVariables().get("restful_task")))) {
            param.setNodeId(delegateTask.getTaskDefinitionKey());
            param.setNodeName(delegateTask.getName());
            param.setTaskId(delegateTask.getId());
            param.setCandidate(this.getCandidates(delegateTask, eventType));
            if (EventType.TASK_COMPLETE_EVENT.equals((Object)eventType)) {
                param.setAssignee(this.getBpmIdentityResult(ContextUtil.getCurrentUserId()));
            }
        }
        if (BeanUtils.isEmpty((Object)(defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId)))) && BeanUtils.isEmpty((Object)(defaultBpmProcessInstance = (DefaultBpmProcessInstance)taskCmd.getTransitVars("processInstance")))) {
            return param;
        }
        String bpmnInstId = defaultBpmProcessInstance.getBpmnInstId();
        if (StringUtil.isNotEmpty((String)bpmnInstId)) {
            Map<String, Object> variables = this.natProInstanceService.getVariables(bpmnInstId);
            param.setVars(variables);
        }
        this.setBoData(param, defaultBpmProcessInstance);
        param.setSubject(defaultBpmProcessInstance.getSubject());
        param.setInstId(instId);
        param.setProcDefId(defaultBpmProcessInstance.getProcDefId());
        param.setFlowKey(defaultBpmProcessInstance.getProcDefKey());
        param.setBusinesskey(defaultBpmProcessInstance.getBizKey());
        param.setSysCode(defaultBpmProcessInstance.getSysCode());
        param.setCreateTime(defaultBpmProcessInstance.getCreateTime());
        param.setProcDefName(defaultBpmProcessInstance.getProcDefName());
        param.setCreator(this.getBpmIdentityResult(defaultBpmProcessInstance.getCreateBy()));
        return param;
    }

    private RestfulParam genartor(BpmTask task, EventType eventType) {
        RestfulParam param = new RestfulParam();
        String instId = task.getProcInstId();
        param.setSubject(task.getSubject());
        param.setNodeId(task.getNodeId());
        param.setNodeName(task.getName());
        param.setTaskId(task.getId());
        param.setActionName(task.getStatus());
        if (EventType.TASK_COMPLETE_EVENT.equals((Object)eventType)) {
            param.setAssignee(this.getBpmIdentityResult(task.getAssigneeId()));
        }
        ArrayList<BpmIdentityResult> candidates = new ArrayList<BpmIdentityResult>();
        candidates.add(this.getBpmIdentityResult(task.getAssigneeId()));
        param.setCandidate(candidates);
        this.completeInstInfo(instId, param);
        return param;
    }

    private RestfulParam genartor(BpmDelegateTask delegateTask, EventType eventType) {
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        RestfulParam param = new RestfulParam();
        String instId = (String)delegateTask.getVariable("instanceId_");
        try {
            param.setSubject((String)delegateTask.getVariable("subject_"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setNodeId(delegateTask.getTaskDefinitionKey());
        param.setNodeName(delegateTask.getName());
        param.setTaskId(delegateTask.getId());
        param.setActionName(taskCmd.getActionName());
        if (EventType.TASK_COMPLETE_EVENT.equals((Object)eventType)) {
            param.setAssignee(this.getBpmIdentityResult(ContextUtil.getCurrentUserId()));
        }
        param.setCandidate(this.getCandidates(delegateTask, eventType));
        this.completeInstInfo(instId, param);
        return param;
    }

    private void completeInstInfo(String instId, RestfulParam param) {
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        this.setBoData(param, defaultBpmProcessInstance);
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isEmpty((Object)defaultBpmProcessInstance) && BeanUtils.isEmpty((Object)(defaultBpmProcessInstance = (DefaultBpmProcessInstance)taskCmd.getTransitVars("processInstance")))) {
            return;
        }
        Map<String, Object> variables = taskCmd.getVariables();
        param.setVars(variables);
        param.setInstId(instId);
        param.setProcDefId(defaultBpmProcessInstance.getProcDefId());
        param.setFlowKey(defaultBpmProcessInstance.getProcDefKey());
        param.setBusinesskey(defaultBpmProcessInstance.getBizKey());
        param.setSysCode(defaultBpmProcessInstance.getSysCode());
        param.setCreateTime(defaultBpmProcessInstance.getCreateTime());
        param.setProcDefName(defaultBpmProcessInstance.getProcDefName());
        param.setCreator(this.getBpmIdentityResult(defaultBpmProcessInstance.getCreateBy()));
    }

    private void setBoData(RestfulParam param, DefaultBpmProcessInstance instance) {
        try {
            if (BeanUtils.isNotEmpty((Object)instance)) {
                List<ObjectNode> boDatas = this.boDataService.getDataByInst(instance);
                ObjectNode jsondata = (ObjectNode)BoDataUtil.hanlerData(boDatas);
                param.setBoData(JsonUtil.toJson((Object)jsondata));
            }
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6bo\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private BpmIdentityResult getBpmIdentityResult(String userId) {
        BpmIdentityResult bpmIdentity = null;
        try {
            IUser user;
            if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(user = this.userServiceImpl.getUserById(userId)))) {
                bpmIdentity = new BpmIdentityResult(user);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bpmIdentity;
    }

    private List<BpmIdentityResult> getCandidates(BpmDelegateTask delegateTask, EventType eventType) {
        ArrayList<BpmIdentityResult> list;
        block12: {
            list = new ArrayList<BpmIdentityResult>();
            try {
                if (EventType.TASK_COMPLETE_EVENT.equals((Object)eventType)) {
                    List<BpmIdentity> bpmIdentitys = this.bpmIdentityService.queryByTask(delegateTask.getId());
                    if (!BeanUtils.isNotEmpty(bpmIdentitys)) break block12;
                    for (BpmIdentity bpmIdentity : bpmIdentitys) {
                        if (!"user".equals(bpmIdentity.getType())) {
                            List userList = this.userServiceImpl.getUserListByGroup(bpmIdentity.getGroupType(), bpmIdentity.getId());
                            for (IUser iUser : userList) {
                                list.add(new BpmIdentityResult(iUser));
                            }
                            continue;
                        }
                        BpmIdentityResult identityResult = this.getBpmIdentityResult(bpmIdentity.getId());
                        if (!BeanUtils.isNotEmpty((Object)identityResult)) continue;
                        list.add(identityResult);
                    }
                    break block12;
                }
                String nodeId = delegateTask.getTaskDefinitionKey();
                ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
                List<Object> identityList = new ArrayList();
                Map nodeUsers = (Map)taskCmd.getTransitVars("bpm_node_users_");
                if (taskCmd.getTransitVars("bpm_next_node_users_") != null) {
                    identityList = (List)taskCmd.getTransitVars("bpm_next_node_users_");
                }
                if (nodeUsers != null && nodeUsers.containsKey(nodeId)) {
                    identityList = (List)nodeUsers.get(nodeId);
                }
                if (BeanUtils.isEmpty(identityList)) {
                    identityList = delegateTask.getExecutors();
                }
                if (BeanUtils.isEmpty(identityList)) {
                    Map<String, List<BpmIdentity>> identityMap = taskCmd.getBpmIdentities();
                    identityList = identityMap.get(nodeId);
                }
                if (BeanUtils.isNotEmpty(identityList)) {
                    identityList = this.extractService.extractBpmIdentity(identityList);
                }
                for (BpmIdentity bpmIdentity : identityList) {
                    list.add(this.getBpmIdentityResult(bpmIdentity.getId()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    class RestfulParam {
        private long timestamp;
        private String procDefId;
        private String flowKey;
        private String instId;
        private String taskId;
        private String nodeId;
        private String nodeName;
        private String eventType;
        private String businesskey;
        private String sysCode;
        private String procDefName;
        private BpmIdentityResult creator;
        private BpmIdentityResult assignee;
        private List<BpmIdentityResult> candidate;
        private String actionName;
        private String nodeType;
        private LocalDateTime createTime;
        private LocalDateTime completeTime;
        private String subject;
        private String boData;
        private Map<String, Object> vars;

        RestfulParam() {
        }

        public String getFlowKey() {
            return this.flowKey;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setFlowKey(String flowKey) {
            this.flowKey = flowKey;
        }

        public String getEventType() {
            return this.eventType;
        }

        public void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public String getProcDefId() {
            return this.procDefId;
        }

        public void setProcDefId(String procDefId) {
            this.procDefId = procDefId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getBusinesskey() {
            return this.businesskey;
        }

        public void setBusinesskey(String businesskey) {
            this.businesskey = businesskey;
        }

        public String getSysCode() {
            return this.sysCode;
        }

        public void setSysCode(String sysCode) {
            this.sysCode = sysCode;
        }

        public String getProcDefName() {
            return this.procDefName;
        }

        public void setProcDefName(String procDefName) {
            this.procDefName = procDefName;
        }

        public BpmIdentityResult getCreator() {
            return this.creator;
        }

        public void setCreator(BpmIdentityResult creator) {
            this.creator = creator;
        }

        public BpmIdentityResult getAssignee() {
            return this.assignee;
        }

        public void setAssignee(BpmIdentityResult assignee) {
            this.assignee = assignee;
        }

        public List<BpmIdentityResult> getCandidate() {
            return this.candidate;
        }

        public void setCandidate(List<BpmIdentityResult> candidate) {
            this.candidate = candidate;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(LocalDateTime localDateTime) {
            this.createTime = localDateTime;
        }

        public LocalDateTime getCompleteTime() {
            return this.completeTime;
        }

        public void setCompleteTime(LocalDateTime completeTime) {
            this.completeTime = completeTime;
        }

        public String getActionName() {
            return this.actionName;
        }

        public void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public Map<String, Object> getVars() {
            return this.vars;
        }

        public void setVars(Map<String, Object> vars) {
            this.vars = vars;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getBoData() {
            return this.boData;
        }

        public void setBoData(String boData) {
            this.boData = boData;
        }
    }
}

