/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.UserUnderDao;
import com.artfess.uc.exception.BaseException;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserUnderManager;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserUnder;
import com.artfess.uc.params.user.UserUnderVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserUnderManagerImpl
extends BaseManagerImpl<UserUnderDao, UserUnder>
implements UserUnderManager {
    @Resource
    UserManager userManager;

    @Override
    public IPage<UserUnder> getUserUnder(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        queryFilter.addFilter("IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        return ((UserUnderDao)this.baseMapper).getUserUnder((IPage<UserUnder>)this.convert2IPage(pageBean), (Wrapper<UserUnder>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void delByUpIdAndUderId(String orgId, String underUserId) {
        ((UserUnderDao)this.baseMapper).delByUpIdAndUderId(orgId, underUserId, LocalDateTime.now());
    }

    @Override
    @Transactional
    public void delByUserIdAndOrgId(String userId, String orgId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        map.put("userId", userId);
        map.put("updateTime", LocalDateTime.now());
        ((UserUnderDao)this.baseMapper).delByUserIdAndOrgId(map);
    }

    @Override
    @Transactional
    public void delByOrgId(String orgId) {
        ((UserUnderDao)this.baseMapper).delByOrgId(orgId, LocalDateTime.now());
    }

    @Override
    public List<UserUnder> getUserUnder(Map<String, Object> params) {
        return ((UserUnderDao)this.baseMapper).getUserUnderNOPage(params);
    }

    @Override
    @Transactional
    public void setUnderUser(UserUnderVo userUnderVo) throws Exception {
        String[] accounts;
        User u = this.userManager.getByAccount(userUnderVo.getAccount());
        for (String account : accounts = userUnderVo.getUnderAccounts().split(",")) {
            User user = this.userManager.getByAccount(account);
            if (BeanUtils.isEmpty((Object)user)) {
                throw new RequiredException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            if (user.getId().equals(u.getId())) {
                throw new BaseException("\u4e0d\u80fd\u8bbe\u7f6e\u81ea\u5df1\u4e3a\u4e0b\u5c5e");
            }
            User superior = this.getSuperior(u.getId(), userUnderVo.getDimenId());
            if (StringUtil.isNotEmpty((String)superior.getId()) && superior.getId().equals(user.getId())) {
                throw new BaseException("\u4e0d\u53ef\u8bbe\u7f6e\u4e0a\u7ea7\u4e3a\u4e0b\u5c5e");
            }
            UserUnder under = this.getUnderByUnderIdAndDemId(user.getId(), userUnderVo.getDimenId());
            if (BeanUtils.isEmpty((Object)under)) {
                UserUnder userUnder = new UserUnder();
                userUnder.setId(UniqueIdUtil.getSuid());
                userUnder.setUserId(u.getId());
                userUnder.setUnderUserId(user.getId());
                userUnder.setUnderUserName(user.getFullname());
                userUnder.setDimenId(userUnderVo.getDimenId());
                this.create((Model)userUnder);
                continue;
            }
            under.setDimenId(userUnderVo.getDimenId());
            under.setUserId(u.getId());
            this.update((Model)under);
        }
    }

    @Override
    public User getSuperior(String underId, String demId) throws Exception {
        UserUnder userUnder = this.getUnderByUnderIdAndDemId(underId, demId);
        if (BeanUtils.isEmpty((Object)userUnder)) {
            return new User();
        }
        return (User)this.userManager.get((Serializable)((Object)userUnder.getUserId()));
    }

    private UserUnder getUnderByUnderIdAndDemId(String underUserId, String demId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"under_user_id_", (Object)underUserId);
        queryWrapper.eq((Object)"dimen_id_", (Object)demId);
        return (UserUnder)((UserUnderDao)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((UserUnderDao)this.baseMapper).removePhysical();
    }
}

