/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.conf;

import com.artfess.base.annotation.IgnoreOnAssembly;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import feign.Contract;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@IgnoreOnAssembly
public class FeignConfig {
    @Value(value="${feign.encry.key:feignCallEncry}")
    private String encryKey;
    @Value(value="${feign.fallback.default.exception:true}")
    private boolean fallbackException = true;

    public boolean isFallbackException() {
        return this.fallbackException;
    }

    @Bean
    public Contract feignContract() {
        return new SpringMvcContract();
    }

    @Bean
    public RequestInterceptor requestTokenBearerInterceptor() {
        return new RequestInterceptor(){

            public void apply(RequestTemplate requestTemplate) {
                String token = "";
                JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
                String proxyToken = "Bearer " + jwtTokenHandler.generateFeignToken();
                requestTemplate.header("Proxy-Authorization", new String[]{proxyToken});
                try {
                    token = HttpUtil.getRequest().getHeader("Authorization");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtil.isNotEmpty(token)) {
                    requestTemplate.header("Authorization", new String[]{token});
                } else {
                    requestTemplate.header("Authorization", new String[]{proxyToken});
                }
            }
        };
    }
}

