/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.enums;

import org.apache.commons.lang3.StringUtils;

public enum FileTypeEnum {
    video("1", ".mp4|.avi|.flv|.3gp", "\u89c6\u9891"),
    txt("2", ".txt|.pdf|.word|.xls|.xlsx|.docx|.doc|.wps|.et|.pptx|.ppt", "\u6587\u6863"),
    img("3", ".jpeg|.png|.jpg|.gif|.bmp", "\u56fe\u7247"),
    audio("4", ".mp3|.wma|.aac", "\u97f3\u9891"),
    other("5", "", "\u5176\u4ed6");

    private final String type;
    private final String desc;
    private final String name;

    private FileTypeEnum(String type, String desc, String name) {
        this.type = type;
        this.desc = desc;
        this.name = name;
    }

    public static String getDesc(String type) {
        FileTypeEnum[] values;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        for (FileTypeEnum state : values = FileTypeEnum.values()) {
            if (!state.getType().equals(type)) continue;
            return state.getName();
        }
        return null;
    }

    public static String getType(String desc) {
        FileTypeEnum[] values;
        if (StringUtils.isEmpty((CharSequence)desc)) {
            return null;
        }
        for (FileTypeEnum state : values = FileTypeEnum.values()) {
            if (!state.getDesc().contains(desc)) continue;
            return state.getType();
        }
        return null;
    }

    public static String getName(String desc) {
        FileTypeEnum[] values;
        if (StringUtils.isEmpty((CharSequence)desc)) {
            return null;
        }
        for (FileTypeEnum state : values = FileTypeEnum.values()) {
            if (!state.getDesc().contains(desc)) continue;
            return state.getName();
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }
}

