/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    public static boolean isMobile(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return false;
        }
        String phoneNumber = "^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(166)|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[0-9]))\\d{8}$";
        Pattern p1 = Pattern.compile(phoneNumber);
        Matcher m1 = p1.matcher(mobile);
        boolean flag = m1.matches();
        Integer phoneLentgh = 11;
        return mobile.length() == phoneLentgh.intValue() && flag;
    }

    public static boolean isEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return false;
        }
        String reg = "^[A-Za-z\\d]+([-_.][A-Za-z\\d]+)*@([A-Za-z\\d]+[-.])+[A-Za-z\\d]{2,4}$";
        Pattern pattern = Pattern.compile(reg);
        boolean flag = false;
        if (email != null) {
            Matcher matcher = pattern.matcher(email);
            flag = matcher.matches();
        }
        return flag;
    }

    public static boolean isIDNumber(String iDNumber) {
        if (StringUtils.isBlank((CharSequence)iDNumber)) {
            return false;
        }
        boolean matches = false;
        String isIDCard1 = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$";
        String isIDCard2 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])((\\d{4})|\\d{3}[X])$";
        Integer idStr15 = 15;
        Integer idStr18 = 18;
        if (iDNumber.length() == idStr15.intValue()) {
            matches = iDNumber.matches(isIDCard1);
        }
        if (iDNumber.length() == idStr18.intValue()) {
            matches = iDNumber.matches(isIDCard2);
        }
        return matches;
    }

    public static boolean isLicense18(String license) {
        if (StringUtils.isEmpty((CharSequence)license)) {
            return false;
        }
        if (license.length() != 18) {
            return false;
        }
        String regex = "^([159Y]{1})([1239]{1})([0-9ABCDEFGHJKLMNPQRTUWXY]{6})([0-9ABCDEFGHJKLMNPQRTUWXY]{9})([0-90-9ABCDEFGHJKLMNPQRTUWXY])$";
        if (!license.matches(regex)) {
            return false;
        }
        String str = "0123456789ABCDEFGHJKLMNPQRTUWXY";
        int[] ws = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
        String[] codes = new String[]{license.substring(0, license.length() - 1), license.substring(license.length() - 1, license.length())};
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += str.indexOf(codes[0].charAt(i)) * ws[i];
        }
        int c18 = 31 - sum % 31;
        if (c18 == 31) {
            c18 = 89;
        } else if (c18 == 30) {
            c18 = 48;
        }
        return str.charAt(c18) == codes[1].charAt(0);
    }

    public static boolean isLicense15(String license) {
        if (StringUtils.isEmpty((CharSequence)license)) {
            return false;
        }
        if (license.length() != 15) {
            return false;
        }
        String businesslicensePrex14 = license.substring(0, 14);
        String businesslicense15 = license.substring(14, license.length());
        char[] chars = businesslicensePrex14.toCharArray();
        int[] ints = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            ints[i] = Integer.parseInt(String.valueOf(chars[i]));
        }
        ValidateUtil.getCheckCode(ints);
        return businesslicense15.equals(ValidateUtil.getCheckCode(ints) + "");
    }

    public static boolean isPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return false;
        }
        String moblieNumber = "(?:(\\(\\+?86\\))(0[0-9]{2,3}\\-?)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?)|(?:(86-?)?(0[0-9]{2,3}\\-?)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?)";
        boolean flag = phone.matches(moblieNumber);
        return flag;
    }

    public static boolean isPassword(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return false;
        }
        String reg = "^(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_!\\.@#$%^&*`~()-+=]+$)(?![a-z0-9]+$)(?![a-z\\W_!\\.@#$%^&*`~()-+=]+$)(?![0-9\\W_!\\.@#$%^&*`~()-+=]+$)[a-zA-Z0-9\\W_!\\.@#$%^&*`~()-+=]{6,20}$";
        boolean flag = false;
        flag = password.matches(reg);
        return flag;
    }

    public static boolean isUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return false;
        }
        String reg = "^[0-9a-zA-Z]{2,20}$";
        boolean flag = false;
        flag = userName.matches(reg);
        return flag;
    }

    public static boolean isContact(String contact) {
        if (StringUtils.isBlank((CharSequence)contact)) {
            return false;
        }
        String phoneNumber = "^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(166)|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[8|9]))\\d{8}$";
        String moblieNumber = "(?:(\\(\\+?86\\))(0[0-9]{2,3}\\-?)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?)|(?:(86-?)?(0[0-9]{2,3}\\-?)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?)";
        Integer phoneLentgh = 11;
        Pattern p1 = Pattern.compile(phoneNumber);
        Matcher m1 = p1.matcher(contact);
        boolean isMatch1 = m1.matches();
        Pattern p2 = Pattern.compile(moblieNumber);
        Matcher m2 = p2.matcher(contact);
        boolean isMatch2 = m2.matches();
        return contact.length() == phoneLentgh.intValue() && isMatch1 || isMatch2;
    }

    public static boolean isZipCode(String zipCode) {
        if (StringUtils.isBlank((CharSequence)zipCode)) {
            return false;
        }
        String reg = "^[0-9]{6}$";
        boolean flag = false;
        flag = zipCode.matches(reg);
        return flag;
    }

    public static boolean hasChinese(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        String reg = "[^\\u4e00-\\u9fa5]+";
        boolean flag = false;
        flag = str.matches(reg);
        return !flag;
    }

    public static boolean isURL(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        String regex = "^([hH][tT]{2}[pP]:/*|[hH][tT]{2}[pP][sS]:/*|[fF][tT][pP]:/*)(([A-Za-z0-9-~]+).)+([A-Za-z0-9-~\\/])+(\\?{0,1}(([A-Za-z0-9-~]+\\={0,1})([A-Za-z0-9-~]*)\\&{0,1})*)$";
        boolean flag = false;
        flag = url.matches(regex);
        return flag;
    }

    private static int getCheckCode(int[] ints) {
        if (null != ints && ints.length > 1) {
            int ti = 0;
            int si = 0;
            int cj = 0;
            int pj = 10;
            for (int i = 0; i < ints.length; ++i) {
                ti = ints[i];
                pj = cj % 11 == 0 ? 10 : cj % 11;
                si = pj + ti;
                cj = (0 == si % 10 ? 10 : si % 10) * 2;
                if (i != ints.length - 1) continue;
                pj = cj % 11 == 0 ? 10 : cj % 11;
                return pj == 1 ? 1 : 11 - pj;
            }
        }
        return -1;
    }
}

