/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.controller;

import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/msg/MsgTemplate/v1"})
@Api(tags={"\u6d88\u606f\u6a21\u677f\u7ba1\u7406"})
@ApiGroup(group={"group_application"})
public class MsgTemplateController
extends BaseController<MsgTemplateManager, MsgTemplate> {
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    IUserGroupService userGroupService;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u6a21\u7248\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d88\u606f\u6a21\u7248\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<MsgTemplate> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<MsgTemplate> queryFilter) throws Exception {
        PageList<MsgTemplate> sysMsgTemplateList = this.msgTemplateManager.queryByType(queryFilter);
        return sysMsgTemplateList;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d88\u606f\u6a21\u7248\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6d88\u606f\u6a21\u7248\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="template", value="\u4ee3\u7406\u5bf9\u8c61", required=true) @RequestBody MsgTemplate msgTemplate) throws Exception {
        String resultMsg = null;
        String currentUserId = ContextUtil.getCurrentUserId();
        IGroup group = ContextUtil.getCurrentGroup();
        String currentGroupId = "0";
        if (group != null) {
            currentGroupId = group.getGroupId();
        }
        try {
            boolean isExist = false;
            if (StringUtil.isEmpty((String)msgTemplate.getId())) {
                QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
                queryFilter.addFilter("KEY_", (Object)msgTemplate.getKey(), QueryOP.EQUAL);
                queryFilter.addFilter("TYPE_KEY_", (Object)msgTemplate.getTypeKey(), QueryOP.EQUAL);
                PageList query = this.msgTemplateManager.query(queryFilter);
                boolean bl = isExist = query.getRows().size() > 0;
                if (isExist) {
                    resultMsg = "\u6d88\u606f\u6a21\u7248\u4e1a\u52a1\u952e\u5df2\u7ecf\u5b58\u5728,\u6dfb\u52a0\u5931\u8d25!";
                } else {
                    msgTemplate.setId(UniqueIdUtil.getSuid());
                    msgTemplate.setCreateBy(currentUserId);
                    msgTemplate.setCreateOrgId(currentGroupId);
                    this.msgTemplateManager.create((Model)msgTemplate);
                    resultMsg = "\u6dfb\u52a0\u6d88\u606f\u6a21\u7248\u6210\u529f";
                }
            } else {
                MsgTemplate sysMsgTemplateTemp = (MsgTemplate)this.msgTemplateManager.get((Serializable)((Object)msgTemplate.getId()));
                if (BeanUtils.isNotEmpty((Object)((Object)sysMsgTemplateTemp))) {
                    MsgTemplate msgTemplate1;
                    if (!sysMsgTemplateTemp.getKey().equals(msgTemplate.getKey()) && (msgTemplate1 = this.msgTemplateManager.queryMsgTemplateByKeyAndTypeKey(msgTemplate.getKey(), msgTemplate.getTypeKey())) != null && StringUtil.isNotEmpty((String)msgTemplate1.getId())) {
                        isExist = true;
                    }
                } else {
                    MsgTemplate msgTemplate1 = this.msgTemplateManager.queryMsgTemplateByKeyAndTypeKey(msgTemplate.getKey(), msgTemplate.getTypeKey());
                    if (msgTemplate1 != null && StringUtil.isNotEmpty((String)msgTemplate1.getId())) {
                        isExist = true;
                    }
                }
                if (isExist) {
                    resultMsg = "\u6d88\u606f\u6a21\u7248\u4e1a\u52a1\u952e\u5df2\u7ecf\u5b58\u5728,\u66f4\u65b0\u5931\u8d25!";
                } else {
                    msgTemplate.setUpdateBy(currentUserId);
                    this.msgTemplateManager.update((Model)msgTemplate);
                    resultMsg = "\u66f4\u65b0\u6d88\u606f\u6a21\u7248\u6210\u529f";
                }
            }
            return new CommonResult(false, resultMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, resultMsg + e.getMessage());
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d88\u606f\u6a21\u7248\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d88\u606f\u6a21\u7248\u8bb0\u5f55)")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u6a21\u677fid", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = ids.split(",");
            this.msgTemplateManager.removeByIds(aryIds);
            return new CommonResult("\u5220\u9664\u6d88\u606f\u6a21\u7248\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u6d88\u606f\u6a21\u7248\u5931\u8d25:" + e.getMessage());
        }
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u5185\u5bb9", httpMethod="GET", notes="\u6839\u636eID\u83b7\u53d6\u5185\u5bb9")
    public MsgTemplate getById(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id) {
        MsgTemplate MsgTemplate2 = (MsgTemplate)this.msgTemplateManager.get((Serializable)((Object)id));
        return MsgTemplate2;
    }

    @RequestMapping(value={"setDefault"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u6d88\u606f\u6a21\u677f\u672a\u9ed8\u8ba4", httpMethod="GET", notes="\u8bbe\u7f6e\u6d88\u606f\u6a21\u677f\u672a\u9ed8\u8ba4")
    public CommonResult<String> setDefault(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id) throws Exception {
        try {
            this.msgTemplateManager.setDefault(id);
            return new CommonResult("\u8bbe\u7f6e\u9ed8\u8ba4\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u8bbe\u7f6e\u9ed8\u8ba4\u5931\u8d25:" + e.getMessage());
        }
    }

    @RequestMapping(value={"setNotDefault"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u6d88\u9ed8\u8ba4\u6d88\u606f\u6a21\u677f", httpMethod="GET", notes="\u53d6\u6d88\u9ed8\u8ba4\u6d88\u606f\u6a21\u677f")
    public CommonResult<String> setNotDefault(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id) throws Exception {
        try {
            this.msgTemplateManager.setNotDefault(id);
            return new CommonResult("\u53d6\u6d88\u9ed8\u8ba4\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u53d6\u6d88\u9ed8\u8ba4\u5931\u8d25:" + e.getMessage());
        }
    }
}

