/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.util;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.bo.model.BoData;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class BoUtil {
    public static BoData transJSON(JsonNode jsonNode) {
        final BoData data = new BoData();
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            ArrayNode arys;
            Map.Entry next = (Map.Entry)fields.next();
            final String key = (String)next.getKey();
            JsonNode jNode = (JsonNode)next.getValue();
            if (jNode.isArray() && key.startsWith("sub_")) {
                arys = (ArrayNode)jNode;
                if (BeanUtils.isEmpty((Object)arys)) {
                    data.setSubList(key.replaceFirst("sub_", ""), new ArrayList<BoData>());
                    continue;
                }
                arys.forEach((Consumer)new Consumer<JsonNode>(){

                    @Override
                    public void accept(JsonNode t) {
                        BoData transResult = BoUtil.transJSON(t);
                        data.addSubRow(key.replaceFirst("sub_", ""), transResult);
                    }
                });
                continue;
            }
            if (jNode.isTextual()) {
                data.set(key, jNode.asText());
                continue;
            }
            if (jNode.isInt()) {
                data.set(key, jNode.asInt());
                continue;
            }
            if (jNode.isLong()) {
                data.set(key, jNode.asLong());
                continue;
            }
            if (jNode.isArray()) {
                arys = (ArrayNode)jNode;
                data.set(key, arys.toString().replace("\"", ""));
                continue;
            }
            data.set(key, jNode);
        }
        return data;
    }

    public static ObjectNode toJSON(BoData boData, boolean needInitData) throws IOException {
        HashMap<String, Map<String, Object>> initMap = new HashMap<String, Map<String, Object>>();
        ObjectNode json = BoUtil.toJSON(boData, initMap);
        if (needInitData) {
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            for (Map.Entry entry : initMap.entrySet()) {
                String key = (String)entry.getKey();
                ObjectNode rowJson = JsonUtil.getMapper().createObjectNode();
                for (Map.Entry row : ((Map)entry.getValue()).entrySet()) {
                    Object value = row.getValue();
                    JsonNode oNode = JsonUtil.toJsonNode(value);
                    rowJson.set((String)row.getKey(), oNode);
                }
                objectNode.set(key, (JsonNode)rowJson);
            }
            json.set("initData", (JsonNode)objectNode);
        }
        return json;
    }

    private static ObjectNode toJSON(BoData boData, Map<String, Map<String, Object>> initMap) throws IOException {
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        for (Map.Entry<String, Object> entry : boData.getData().entrySet()) {
            Object value = entry.getValue();
            if (BeanUtils.isNotEmpty((Object)value)) {
                objectNode.set(entry.getKey(), BeanUtils.isNotEmpty((Object)value) ? JsonUtil.toJsonNode((Object)value) : null);
                continue;
            }
            objectNode.put(entry.getKey(), "");
        }
        Map<String, List<BoData>> subMap = boData.getSubMap();
        for (Map.Entry<String, List<BoData>> ent : subMap.entrySet()) {
            ArrayNode aNode = JsonUtil.getMapper().createArrayNode();
            for (BoData obj : ent.getValue()) {
                aNode.add((JsonNode)BoUtil.toJSON(obj, initMap));
            }
            objectNode.set("sub_" + ent.getKey(), (JsonNode)aNode);
        }
        initMap.putAll(boData.getInitDataMap());
        return objectNode;
    }

    public static ObjectNode hanlerData(List<BoData> boJsons) throws Exception {
        ObjectNode jsondata = JsonUtil.getMapper().createObjectNode();
        for (BoData boJson : boJsons) {
            ObjectNode json = BoUtil.toJSON(boJson, true);
            jsondata.set(boJson.getBoDefAlias(), (JsonNode)json);
        }
        return jsondata;
    }
}

