/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.query.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizQueryResultMainManager;
import com.artfess.query.model.BizQueryResultMain;
import com.artfess.query.vo.BizQueryResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u67e5\u67e5--\u67e5\u8be2\u7ed3\u679c\u914d\u7f6e\u4fe1\u606f\u4e3b\u8868"})
@ApiGroup(group={"group_biz_query"})
@RestController
@RequestMapping(value={"/query/resultMain/v1/"})
public class BizQueryResultMainController
extends BaseController<BizQueryResultMainManager, BizQueryResultMain> {
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u67e5\u8be2\u7ed3\u679c\u914d\u7f6e\u4fe1\u606f\u8868")
    @PostMapping(value={"saveOrUpdateBatchResult"})
    public CommonResult<String> saveOrUpdateBatchResult(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizQueryResultVo queryResultVo) throws Exception {
        boolean status = ((BizQueryResultMainManager)this.baseService).saveOrUpdateBatchResult(queryResultVo);
        return status ? CommonResult.success(null, (String)"\u6279\u91cf\u4fdd\u5b58\u67e5\u8be2\u7ed3\u679c\u914d\u7f6e\u4fe1\u606f\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizQueryResultVo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizQueryResultMainManager)this.baseService).getVoById(id);
    }

    @ApiOperation(value="\u6839\u636e\u6807\u7b7e\u67e5\u8be2\u5bf9\u5e94\u7ed3\u679c\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"qureyResultConfigByTag"})
    public CommonResult<String> qureyResultConfigByTag(@RequestParam String tagId) {
        List<BizQueryResultVo> list = ((BizQueryResultMainManager)this.baseService).qureyResultConfigByTag(tagId);
        ArrayList reList = new ArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, List<BizQueryResultVo>> map = list.stream().collect(Collectors.groupingBy(BizQueryResultMain::getGroupName));
            for (Map.Entry<String, List<BizQueryResultVo>> entry : map.entrySet()) {
                String key = entry.getKey();
                List<BizQueryResultVo> value = entry.getValue();
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("group", key);
                result.put("data", value);
                reList.add(result);
            }
        }
        return CommonResult.success(reList, (String)"\u83b7\u53d6\u6210\u529f\uff01");
    }
}

