/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataCollect.dao.BizClusterInfoDao;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.model.BizClusterInfo;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.vo.BizClusterInfoVo;
import com.artfess.dataShare.util.AKSKGenerator;
import com.artfess.dataShare.util.MySQLUtils;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizClusterInfoManagerImpl
extends BaseManagerImpl<BizClusterInfoDao, BizClusterInfo>
implements BizClusterInfoManager {
    @Resource
    SysDataSourceManager sysDataSourceManager;
    @Resource
    BizClusterInfoModeManager infoModeManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> saveClusterInfo(BizClusterInfoVo vo) throws Exception {
        if (StringUtil.isEmpty((String)vo.getCompanyName())) {
            throw new RequiredException("\u6dfb\u52a0\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f\u5931\u8d25\uff0c\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f\u540d\u79f0\u5fc5\u586b\uff01");
        }
        BizClusterInfo info = BizClusterInfoVo.parse(vo);
        BizClusterInfoMode infoMode = BizClusterInfoVo.parseMode(vo);
        if (StringUtil.isNotEmpty((String)info.getId())) {
            BizClusterInfo temp = this.queryByName(vo.getCompanyName());
            if (null != temp && !temp.getId().equals(vo.getId())) {
                throw new RequiredException("\u6570\u636e\u6c47\u805a\u65b9\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            BizClusterInfo temp1 = this.queryBySysCode(vo.getSysCode());
            if (null != temp1 && !temp1.getId().equals(vo.getId())) {
                throw new RequiredException("\u7cfb\u7edf\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            this.update((Model)info);
            this.infoModeManager.update((Model)infoMode);
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
            MySQLUtils.updateDateUser(template, infoMode.getDatabaseUser(), infoMode.getDatabasePwd());
        } else {
            BizClusterInfo temp = this.queryByName(vo.getCompanyName());
            if (null != temp) {
                throw new RequiredException("\u6570\u636e\u6c47\u805a\u65b9\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            BizClusterInfo temp1 = this.queryBySysCode(vo.getSysCode());
            if (null != temp1) {
                throw new RequiredException("\u7cfb\u7edf\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
            SysDataSource dataSource = this.sysDataSourceManager.getByAlias(infoMode.getDatabaseAlias());
            String dataBaseName = (String)template.queryForObject("SELECT DATABASE()", String.class);
            String id = UniqueIdUtil.getSuid();
            info.setId(id);
            this.create((Model)info);
            infoMode.setId(id);
            infoMode.setSourceId(dataSource.getId());
            infoMode.setDatabaseName(dataBaseName);
            infoMode.setDatabaseAlias(infoMode.getDatabaseAlias());
            infoMode.setApiAk(AKSKGenerator.generateAccessKey());
            infoMode.setApiSk(AKSKGenerator.generateSecretKey());
            this.infoModeManager.create((Model)infoMode);
            String user = infoMode.getDatabaseUser();
            String dbName = infoMode.getDatabaseName();
            String pwd = infoMode.getDatabasePwd();
            String grant = "all";
            MySQLUtils.createDataUser(template, user, pwd);
            MySQLUtils.createGrant(template, grant, dbName, user);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public BizClusterInfoVo queryClusterInfo(String id) throws Exception {
        BizClusterInfoMode mode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)id)));
        BizClusterInfo info = (BizClusterInfo)((Object)this.getById((Serializable)((Object)id)));
        BizClusterInfoVo vo = new BizClusterInfoVo();
        BeanUtils.copyNotNullProperties((Object)vo, (Object)((Object)info));
        BeanUtils.copyNotNullProperties((Object)vo, (Object)((Object)mode));
        return vo;
    }

    @Override
    public BizClusterInfo queryByName(String name) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"COMPANY_NAME_", (Object)name);
        queryWrapper.last(" limit 1");
        return (BizClusterInfo)((Object)((BizClusterInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    public BizClusterInfo queryBySysCode(String sysCode) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SYS_CODE_", (Object)sysCode);
        queryWrapper.last(" limit 1");
        return (BizClusterInfo)((Object)((BizClusterInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    public boolean checkUserExists(String dbAlias, String user) throws Exception {
        String sql = "SELECT COUNT(*) FROM mysql.user WHERE user = ?";
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)dbAlias);
        Integer count = (Integer)jdbcTemplate.queryForObject(sql, new Object[]{user}, Integer.class);
        return count <= 0;
    }
}

