/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.export.FieldExtensionExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.EventListener;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.apache.commons.lang3.StringUtils;

public class ActivitiListenerExport
implements BpmnXMLConstants {
    public static boolean writeListeners(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (element instanceof HasExecutionListeners) {
            didWriteExtensionStartElement = ActivitiListenerExport.writeListeners("executionListener", ((HasExecutionListeners)element).getExecutionListeners(), didWriteExtensionStartElement, xtw);
        }
        if (element instanceof UserTask) {
            didWriteExtensionStartElement = ActivitiListenerExport.writeListeners("taskListener", ((UserTask)element).getTaskListeners(), didWriteExtensionStartElement, xtw);
        }
        if (element instanceof Process) {
            didWriteExtensionStartElement = ActivitiListenerExport.writeEventListeners(((Process)element).getEventListeners(), didWriteExtensionStartElement, xtw);
        }
        return didWriteExtensionStartElement;
    }

    protected static boolean writeEventListeners(List<EventListener> eventListeners, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (eventListeners != null && !eventListeners.isEmpty()) {
            for (EventListener eventListener : eventListeners) {
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("activiti", "eventListener", "http://activiti.org/bpmn");
                BpmnXMLUtil.writeDefaultAttribute("events", eventListener.getEvents(), xtw);
                BpmnXMLUtil.writeDefaultAttribute("entityType", eventListener.getEntityType(), xtw);
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("class", eventListener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("delegateExpression", eventListener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_SIGNAL_EVENT.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("signalName", eventListener.getImplementation(), xtw);
                    BpmnXMLUtil.writeDefaultAttribute("throwEvent", "signal", xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_GLOBAL_SIGNAL_EVENT.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("signalName", eventListener.getImplementation(), xtw);
                    BpmnXMLUtil.writeDefaultAttribute("throwEvent", "globalSignal", xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_MESSAGE_EVENT.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("messageName", eventListener.getImplementation(), xtw);
                    BpmnXMLUtil.writeDefaultAttribute("throwEvent", "message", xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_ERROR_EVENT.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("errorCode", eventListener.getImplementation(), xtw);
                    BpmnXMLUtil.writeDefaultAttribute("throwEvent", "error", xtw);
                }
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }

    private static boolean writeListeners(String xmlElementName, List<ActivitiListener> listenerList, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (listenerList != null) {
            for (ActivitiListener listener : listenerList) {
                if (!StringUtils.isNotEmpty((CharSequence)listener.getEvent())) continue;
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("activiti", xmlElementName, "http://activiti.org/bpmn");
                BpmnXMLUtil.writeDefaultAttribute("event", listener.getEvent(), xtw);
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("class", listener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("expression", listener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("delegateExpression", listener.getImplementation(), xtw);
                }
                FieldExtensionExport.writeFieldExtensions(listener.getFieldExtensions(), true, xtw);
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }
}

