/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.service.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.manager.SysLogsManager;
import com.artfess.sysConfig.persistence.model.SysLogs;
import com.artfess.sysConfig.service.SysLogsBatchService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Service;

@Service
public class SysLogsBatchServiceImpl
implements SysLogsBatchService,
ApplicationListener<ContextClosedEvent> {
    private static final Map<String, List<SysLogs>> map = new HashMap<String, List<SysLogs>>();
    @Value(value="${system.batch.max-size:500}")
    private Integer maxSize;
    @Value(value="${system.batch.max-time:30}")
    private int maxTime;
    private long lastWriteTime = 0L;
    @Resource
    SysLogsManager sysLogsManager;
    @Resource
    BaseContext baseContext;

    private void push(String tenantId, SysLogs sysLogs) {
        List<Object> list = null;
        if (!map.containsKey(tenantId)) {
            list = new ArrayList();
            map.put(tenantId, list);
        }
        list = map.get(tenantId);
        list.add((Object)sysLogs);
    }

    private boolean countOver() {
        int[] count = new int[1];
        map.forEach((key, list) -> {
            count[0] = count[0] + list.size();
        });
        return count[0] > this.maxSize;
    }

    private boolean timeExpire() {
        long now = System.currentTimeMillis();
        if (this.lastWriteTime == 0L) {
            this.lastWriteTime = now;
            return false;
        }
        return now - this.lastWriteTime > (long)(this.maxTime * 1000);
    }

    @Override
    public void reader(ObjectNode objectNode) throws Exception {
        SysLogs sysLogs = (SysLogs)((Object)JsonUtil.toBean((JsonNode)objectNode, SysLogs.class));
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)((Object)sysLogs)), (String)"\u8bb0\u5f55\u65e5\u5fd7\u65f6\u51fa\u9519\uff0c\u65e5\u5fd7\u6570\u636e\u5e8f\u5217\u5316\u65f6\u5931\u8d25\u3002");
        String tenantId = JsonUtil.getString((JsonNode)objectNode, (String)"tenantId");
        if (StringUtil.isEmpty((String)tenantId)) {
            tenantId = "-1";
        }
        this.push(tenantId, sysLogs);
        this.process();
    }

    @Override
    public void process() {
        if (this.countOver() || this.timeExpire()) {
            this.write();
        }
    }

    public void write() {
        this.lastWriteTime = System.currentTimeMillis();
        map.forEach((key, list) -> {
            if (list.size() > 0) {
                try {
                    this.baseContext.setTempTenantId(key);
                    this.sysLogsManager.saveBatch((Collection)list);
                }
                finally {
                    list.clear();
                }
            }
        });
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.write();
    }
}

