/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.util;

import com.aspose.cells.IndividualFontConfigs;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ExcelToPdfUtil {
    public static void excelToPdf(String sourceFilePath, String desFilePathd) {
        try {
            IndividualFontConfigs configs = new IndividualFontConfigs();
            configs.setFontFolder("/usr/share/fonts/chinese", true);
            LoadOptions loadOptions = new LoadOptions();
            loadOptions.setFontConfigs(configs);
            Workbook wb = new Workbook(sourceFilePath);
            FileOutputStream fileOS = new FileOutputStream(desFilePathd);
            PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
            pdfSaveOptions.setOnePagePerSheet(true);
            int[] autoDrawSheets = new int[]{3};
            ExcelToPdfUtil.autoDraw(wb, autoDrawSheets);
            int[] showSheets = new int[]{0};
            ExcelToPdfUtil.printSheetPage(wb, showSheets);
            wb.save((OutputStream)fileOS, (SaveOptions)pdfSaveOptions);
            fileOS.flush();
            fileOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void excelToPdf(Workbook wb, String desFilePathd) {
        try {
            FileOutputStream fileOS = new FileOutputStream(desFilePathd);
            PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
            pdfSaveOptions.setOnePagePerSheet(true);
            int[] autoDrawSheets = new int[]{3};
            ExcelToPdfUtil.autoDraw(wb, autoDrawSheets);
            int[] showSheets = new int[]{0};
            ExcelToPdfUtil.printSheetPage(wb, showSheets);
            wb.save((OutputStream)fileOS, (SaveOptions)pdfSaveOptions);
            fileOS.flush();
            fileOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void autoDraw(Workbook wb, int[] page) {
        if (null != page && page.length > 0) {
            for (int i = 0; i < page.length; ++i) {
                wb.getWorksheets().get(i).getHorizontalPageBreaks().clear();
                wb.getWorksheets().get(i).getVerticalPageBreaks().clear();
            }
        }
    }

    public static void printSheetPage(Workbook wb, int[] page) {
        int i;
        for (i = 1; i < wb.getWorksheets().getCount(); ++i) {
            wb.getWorksheets().get(i).setVisible(false);
        }
        if (null == page || page.length == 0) {
            wb.getWorksheets().get(0).setVisible(true);
        } else {
            for (i = 0; i < page.length; ++i) {
                wb.getWorksheets().get(i).setVisible(true);
            }
        }
    }

    public static void main(String[] args) {
        ExcelToPdfUtil.excelToPdf("F:\\bak\\xls\u8f6cpdf\\\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868.xls", "F:\\bak\\xls\u8f6cpdf\\\u5de5\u7a0b\u6536\u65b9\u8bb0\u5f55\u8868.pdf");
    }
}

