/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.check.detail.dao.SideRegularCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.SideRegularCheckDetailManager;
import com.artfess.yhxt.check.detail.model.SideRegularCheckDetail;
import com.artfess.yhxt.check.regular.dao.SideSlopeRegularCheckDao;
import com.artfess.yhxt.check.regular.manager.SideSlopeRegularCheckManager;
import com.artfess.yhxt.check.regular.model.SideSlopeRegularCheck;
import com.artfess.yhxt.check.regular.vo.SideSlopeRegularCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SideSlopeRegularCheckManagerImpl
extends BaseManagerImpl<SideSlopeRegularCheckDao, SideSlopeRegularCheck>
implements SideSlopeRegularCheckManager {
    @Resource
    private SideRegularCheckDetailManager sideRegularCheckDetailManager;
    @Resource
    private SideRegularCheckDetailDao sideRegularCheckDetailDao;
    @Resource
    private SideSlopeInformationManager slopeInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public PageList<SideSlopeRegularCheck> querySideSlopeRegularCheck(QueryFilter<SideSlopeRegularCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<SideSlopeRegularCheck> result = ((SideSlopeRegularCheckDao)this.baseMapper).querySideSlopeRegularCheck((IPage<SideSlopeRegularCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SideSlopeRegularCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void saveSideSlopeRegularCheck(SideSlopeRegularCheckVo vo) {
        SideSlopeRegularCheck sideSlopeRegularCheck = vo.getSideSlopeRegularCheck();
        sideSlopeRegularCheck.setIsDele("0");
        this.saveOrUpdate((Object)sideSlopeRegularCheck);
        List<SideRegularCheckDetail> list = vo.getSideRegularCheckDetails();
        if (list.size() > 0) {
            for (SideRegularCheckDetail sideRegularCheckDetail : list) {
                sideRegularCheckDetail.setId(null);
                sideRegularCheckDetail.setSideSlopeRegularCheckId(sideSlopeRegularCheck.getId());
                this.sideRegularCheckDetailManager.create((Model)sideRegularCheckDetail);
            }
        }
        List<Accessory> accessoryList = vo.getAccessories();
        String id = sideSlopeRegularCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateSideSlopeRegularCheck(SideSlopeRegularCheckVo vo) {
        SideSlopeRegularCheck sideSlopeRegularCheck = vo.getSideSlopeRegularCheck();
        this.update((Model)sideSlopeRegularCheck);
        List<SideRegularCheckDetail> details = vo.getSideRegularCheckDetails();
        if (details.size() > 0) {
            for (SideRegularCheckDetail detail : details) {
                detail.setSideSlopeRegularCheckId(sideSlopeRegularCheck.getId());
                this.sideRegularCheckDetailManager.saveOrUpdate((Object)detail);
            }
        }
        List<Accessory> accessoryList = vo.getAccessories();
        String id = sideSlopeRegularCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public SideSlopeRegularCheckVo getSideSlopeRegularCheckById(String id) {
        SideSlopeRegularCheckVo sideSlopeRegularCheckVo = new SideSlopeRegularCheckVo();
        SideSlopeRegularCheck sideSlopeRegularCheck = (SideSlopeRegularCheck)((Object)this.getById((Serializable)((Object)id)));
        sideSlopeRegularCheckVo.setSideSlopeRegularCheck(sideSlopeRegularCheck);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)sideSlopeRegularCheck.getId()), (Object)"SIDE_SLOPE_REGULAR_CHECK_ID_", (Object)id);
        List detailList = this.sideRegularCheckDetailDao.selectList((Wrapper)queryWrapper);
        sideSlopeRegularCheckVo.setSideRegularCheckDetails(detailList);
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        sideSlopeRegularCheckVo.setAccessories(accessories);
        return sideSlopeRegularCheckVo;
    }

    @Override
    public void importExcelData(MultipartFile file, SideSlopeRegularCheck parseObject) {
        Assert.notNull((Object)((Object)parseObject), (String)"\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, SideRegularCheckDetail.class, (ImportParams)new ImportParams());
            SideSlopeRegularCheckVo vo = new SideSlopeRegularCheckVo();
            vo.setSideSlopeRegularCheck(parseObject);
            vo.setSideRegularCheckDetails(data);
            this.saveSideSlopeRegularCheck(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveSiteStatistic(SideSlopeRegularCheck sideSlopeRegularCheck) {
        SiteStatistic siteStatistic = new SiteStatistic();
        String sideSlopeId = sideSlopeRegularCheck.getSideSlopeId();
        SideSlopeInformation sideSlopeInformation = (SideSlopeInformation)((Object)this.slopeInformationManager.getById((Serializable)((Object)sideSlopeId)));
        siteStatistic.setRoadSegmentId(sideSlopeInformation.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(sideSlopeInformation.getRoadSegmentName());
        siteStatistic.setCompanyId(sideSlopeInformation.getCompanyId());
        siteStatistic.setCompanyName(sideSlopeInformation.getCompanyName());
        siteStatistic.setSiteCode(10);
        siteStatistic.setSiteName("\u8fb9\u5761\u5b9a\u671f\u68c0\u67e5");
        LocalDate checkDate = sideSlopeRegularCheck.getCheckDate();
        String month = checkDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        siteStatistic.setAccDateMonth(month);
        String year = checkDate.format(DateTimeFormatter.ofPattern("yyyy"));
        siteStatistic.setAccDateYear(year);
        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)month), (Object)"ACC_DATE_MONTH_", (Object)month);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)year), (Object)"ACC_DATE_YEAR_", (Object)year);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)sideSlopeInformation.getRoadSegmentId()), (Object)"ROAD_SEGMENT_ID_", (Object)sideSlopeInformation.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)sideSlopeInformation.getCompanyId()), (Object)"COMPANY_ID_", (Object)sideSlopeInformation.getCompanyId());
        queryWrapper.eq((Object)"SITE_CODE_", (Object)10);
        queryWrapper.eq((Object)"SITE_NAME_", (Object)"\u8fb9\u5761\u5b9a\u671f\u68c0\u67e5");
        List siteStatistics = this.siteStatisticDao.selectList((Wrapper)queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = (SiteStatistic)((Object)siteStatistics.get(0));
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update((Object)siteStatistic, (Wrapper)queryWrapper);
        } else {
            this.siteStatisticDao.insert((Object)siteStatistic);
        }
    }
}

