/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.taskcallback;

import com.artfess.base.groovy.IScript;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.uc.util.ContextUtil;
import com.artfess.yhxt.budget.dao.YearBudgetDetailedDao;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.WorkOrderInformationVo;
import com.artfess.yhxt.disease.manager.DiseaseManager;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.util.ArithUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TaskCallBackScript
implements IScript {
    @Resource
    private DiseaseManager diseaseManager;
    @Resource
    private YearBudgetManager yearBudgetManager;
    @Resource
    private WorkOrderInformationManager workOrderInformationManager;
    @Resource
    private YearBudgetDetailedManager yearBudgetDetailedManager;
    @Resource
    private YearBudgetDetailedDao yearBudgetDetailedDao;

    public void updateHandlingSituatioByWorkId(BpmNodeDef nodeDef, BpmDelegateTask delegateTask, ActionCmd cmd, int node) throws Exception {
        WorkOrderInformation workOrderInformation;
        WorkOrderInformationVo vo;
        String businessKey;
        if (null == nodeDef && null == delegateTask && null == cmd) {
            return;
        }
        if (3 == node) {
            businessKey = cmd.getBusinessKey();
            if (StringUtils.isBlank((CharSequence)businessKey)) {
                return;
            }
            vo = this.workOrderInformationManager.getVo(businessKey);
            workOrderInformation = vo.getWorkOrderInformation();
            workOrderInformation.setConstructionFinishTime(LocalDateTime.now());
            this.workOrderInformationManager.update((Model)workOrderInformation);
        }
        if (4 == node) {
            businessKey = cmd.getBusinessKey();
            if (StringUtils.isBlank((CharSequence)businessKey)) {
                return;
            }
            vo = this.workOrderInformationManager.getVo(businessKey);
            workOrderInformation = vo.getWorkOrderInformation();
            workOrderInformation.setReceiveror(ContextUtil.getCurrentUserId());
            workOrderInformation.setReceiverDate(LocalDate.now());
            this.workOrderInformationManager.update((Model)workOrderInformation);
        }
        if (5 == node) {
            businessKey = cmd.getBusinessKey();
            if (StringUtils.isBlank((CharSequence)businessKey)) {
                return;
            }
            vo = this.workOrderInformationManager.getVo(businessKey);
            workOrderInformation = vo.getWorkOrderInformation();
            workOrderInformation.setAuditor(ContextUtil.getCurrentUserId());
            workOrderInformation.setAuditDate(LocalDate.now());
            this.workOrderInformationManager.update((Model)workOrderInformation);
        }
        if (99 == node) {
            businessKey = cmd.getBusinessKey();
            if (StringUtils.isBlank((CharSequence)businessKey)) {
                return;
            }
            vo = this.workOrderInformationManager.getVo(businessKey);
            workOrderInformation = vo.getWorkOrderInformation();
            workOrderInformation.setEndTime(LocalDate.now());
            workOrderInformation.setStatus("1");
            workOrderInformation.setOverdue(0);
            this.workOrderInformationManager.update((Model)workOrderInformation);
            String diseaseId = workOrderInformation.getDiseaseId();
            if (StringUtils.isNotEmpty((CharSequence)diseaseId)) {
                List<String> ids = Arrays.asList(diseaseId.split(";"));
                LocalDateTime deadLineHandledTime = LocalDateTime.now();
                for (String id : ids) {
                    Disease disease = (Disease)((Object)this.diseaseManager.getById((Serializable)((Object)id)));
                    LocalDate demandFinishTime = workOrderInformation.getDemandFinishTime();
                    if (null != demandFinishTime) {
                        Period between = Period.between(demandFinishTime, LocalDate.now());
                        if (between.getDays() > 0) {
                            disease.setDeadlineStatus(1);
                            disease.setDeadlineEnd(deadLineHandledTime);
                        } else {
                            disease.setDeadlineStatus(0);
                        }
                    }
                    if (disease.getHandlingSituation() != null && disease.getHandlingSituation() != 1) continue;
                    disease.setHandlingSituation(2);
                    disease.setHandledTimeEnd(deadLineHandledTime);
                    this.diseaseManager.update((Model)disease);
                }
            }
            Double zf = 0.0;
            List<BillOfQuantities> billOfQuantities = vo.getBillOfQuantities();
            for (BillOfQuantities billOfQuantitie : billOfQuantities) {
                Float auditMoney = billOfQuantitie.getTaxMoney();
                if (auditMoney == null) continue;
                zf = ArithUtil.add(zf, (double)auditMoney.floatValue());
            }
            if (zf > 0.0) {
                String roadSegmentId = workOrderInformation.getRoadSegmentId();
                QueryFilter queryFilter = QueryFilter.build();
                LocalDate localDate = LocalDate.now();
                queryFilter.addFilter("ASCRIPTION_YEAR_", (Object)localDate.getYear(), QueryOP.EQUAL);
                queryFilter.addFilter("ROAD_SEGMENT_ID_", (Object)roadSegmentId, QueryOP.EQUAL);
                queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
                List yearBudgetList = this.yearBudgetManager.queryNoPage(queryFilter);
                if (null != yearBudgetList && yearBudgetList.size() > 0) {
                    for (YearBudget yearBudget : yearBudgetList) {
                        QueryWrapper queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"YEAR_BUDGET_ID_", (Object)yearBudget.getId());
                        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                        queryWrapper.eq((Object)"EXPENDITURE_TYPE_", (Object)"FXCBXZC");
                        queryWrapper.eq((Object)"BUDGET_TYPE_", (Object)"RCJF");
                        queryWrapper.eq((Object)"BUDGET_ITEM_", (Object)"RCYH");
                        queryWrapper.eq((Object)"BUDGET_CONTENT", (Object)"\u65e5\u5e38\u517b\u62a4");
                        List detaileds = this.yearBudgetDetailedManager.list((Wrapper)queryWrapper);
                        for (YearBudgetDetailed detailed : detaileds) {
                            BigDecimal imageProgress = detailed.getImageProgress();
                            if (imageProgress == null) {
                                imageProgress = new BigDecimal(0);
                            }
                            BigDecimal bigDecimal = imageProgress.add(BigDecimal.valueOf(zf / 10000.0));
                            detailed.setImageProgress(bigDecimal);
                            this.yearBudgetDetailedManager.update((Model)detailed);
                        }
                        yearBudget.setAlreadyCount(this.yearBudgetDetailedDao.sumImageProgress(yearBudget.getId()));
                        this.yearBudgetManager.updateById((Object)yearBudget);
                    }
                }
            }
        }
    }
}

