layui.define(['jquery','contextMenu'], function (exports) {
    var contextMenu = layui.contextMenu;
    var $ = layui.jquery;

    var ext = {
        init : function(){//定义右键操作
            $(".layim-list-friend >li > ul > li").contextMenu({
                width: 140, // width
                itemHeight: 30, // 菜单项height
                bgColor: "#fff", // 背景颜色
                color: "#333", // 字体颜色
                fontSize: 15, // 字体大小
                hoverBgColor: "#009bdd", // hover背景颜色
                hoverColor: "#fff", // hover背景颜色
                target: function(ele) { // 当前元素
                    $(".ul-context-menu").attr("data-id",ele.find("b").html());
                    $(".ul-context-menu").attr("data-fid",ele.find("c").html());
                    $(".ul-context-menu").attr("data-name",ele.find("span").html());
                    $(".ul-context-menu").attr("data-img",ele.find("img").attr('src'));
                },
                menu: [
                    { // 菜单项
                        text: "删除好友",
                        icon: "&#xe640;",
                        callback: function(ele) {
                        	var othis = ele.parent();
                        	del(othis[0].dataset.fid,othis[0].dataset.name);
                        	
                        }
                    },                
                    {
                        text: "拉黑名单",
                        icon: "&#xe612;",
                        callback: function(ele) {
                        	var othis = ele.parent();
                        	pullblack(othis[0].dataset.fid,othis[0].dataset.name);
                        }
                    },
                    {
                        text: "转移分组",
                        icon: "&#xe66b;",
                        callback: function(ele) {
                        	var othis = ele.parent();
                        	moveGroup(othis[0].dataset.fid);
                        }
                    },
                    {
                        text: "查看资料",
                        icon: "&#xe66e;",
                        callback: function(ele) {
                        	var othis = ele.parent();
                        	viewUser(othis[0].dataset.id);
                        }
                    }                                                    
                ]
            });
        }
    }
  exports('readyMenu', ext);
})
var layer = layui.layer,layim = layui.layim;

//删除
function del(id,NAME){
	var index = layer.confirm('确认要删除'+NAME+'吗?', {
		btn: ['删除','取消'] //按钮
	}, function(){
		$.ajax({
			xhrFields: {
				withCredentials: false
			},
			type: "POST",
			headers: {
				Authorization: "Bearer " + JSON.parse(window.sessionStorage.currentUser).token
			},
			url: window.httpurl+'/friends/delete',
			data: {friendId:id, tm:new Date().getTime()},
			dataType:'json',
			success: function(data){
				if(data.state) {
					removeFriendByI(id); 		//从自己好友栏移除  此方法在im.jsp页面中
					removeFriendFromMobile(id);	//从自己手机好友栏里面删除对方
					layer.msg('已删除好友'+NAME+'', {icon: 1});
					layer.close(index)
				}
			}
		});
	}, function(){
		layer.close(index)
	});
}

//拉黑
function pullblack(id,NAME){
	var index = layer.confirm('确认要把'+NAME+'拉入黑名单吗?', {
		btn: ['拉入','取消'] //按钮
	}, function(){

		$.ajax({
			xhrFields: {
				withCredentials: false
			},
			type: "POST",
			headers: {
				Authorization: "Bearer " + JSON.parse(window.sessionStorage.currentUser).token
			},
			url:  window.httpurl+'/friends/pullblack',
			data: {friendId:id, tm:new Date().getTime()},
			dataType:'json',
			success: function(data){
				if(data.state) {
					removeFriendByI(id); 		//从自己好友栏移除  此方法在im.jsp页面中
					removeIFromFriend(id);		//从对方好友栏里面删除自己
					removeFriendFromMobile(id);	//从自己手机好友栏里面删除对方
					layer.msg('拉黑成功，已经从互相好友列表中删除', {icon: 1});
					layer.close(index)
				}
			}
		});
	}, function(){
		layer.close(index)
	});
}

//转移分组
function moveGroup(friendId){
	layer.open({
		type: 2,
		title: '选择分组',
		shadeClose: true,
		shade: 0.8,
		area: ['400px', '200px'],
		content: pageurl + "/static/IM/choseGroup.html?friendId=" + friendId
	});
}

//查看用户资料
function viewUser(USERNAME){
	if('admin' == USERNAME){
		layer.msg('不能查看admin用户', {icon: 2});
		return;
	}

	layer.open({
		type: 2,
		title: '查看信息',
		shadeClose: true,
		shade: 0.8,
		area: ['400px','500px'],
		content: pageurl + "/static/IM/personInfo.html?userName=" + USERNAME
	});

	//  var diag = new Dialog();
	//  diag.Drag=true;
	//  diag.Title ="好友资料";
	//  diag.URL = '../user/user_view.html?USERNAME='+USERNAME;
	//  diag.Width = 600;
	//  diag.Height = 319;
	//  diag.CancelEvent = function(){ //关闭事件
	// 	diag.close();
	//  };
	//  diag.show();
}



//从自己手机好友栏里面删除对方
function removeFriendFromMobile(FUSERNAME) {
	if(!window.webSocket) return;
	window.webSocket.send(',fhadmin-remove,' + FUSERNAME + ',fh,' + window.user);
}

//从对方好友栏里面删除自己
function removeIFromFriend(FUSERNAME) {
	if(!window.webSocket) return;
	window.webSocket.send(',fhadmin-remove,' + window.user + ',fh,' + FUSERNAME);
}

//从自己好友栏删除好友
function removeFriendByI(FUSERNAME) {
	layui.layim.removeList({
		type: 'friend'
		, id: FUSERNAME //好友用户名
	});
}

//退出群
function removeQgroup(QGROUP_ID, TYPE) {
	layui.layim.removeList({
		type: 'group'
		, id: QGROUP_ID //群ID
	});
	if ('del' == TYPE) {
		window.webSocket.send(',fhadmin-delqgroup,' + QGROUP_ID); 	//解散群，通知所有群成员
	} else {
		window.webSocket.send(',fhadmin-applyqgroup,' + QGROUP_ID);  //申请群和退群，都是通知群主，此函数可共用一个
	}
}

//新建群时，把群添加到群组栏里面
function addQgroup(id, avatar, groupname) {
	layui.layim.addList({
		type: 'group' 			//列表类型
		, avatar: avatar 		//群组头像
		, groupname: groupname 	//群组名称
		, id: id					//群组id
	});
}

//同意对方申请好友，发送同意信息给对方
function agreeFriend(FUSERNAME) {
	window.webSocket.send(',fhadmin-agreefriend,' + window.user + ",fh," + FUSERNAME);
}

//同意对方申请加群，发送同意信息给对方
function agreeQgroup(uid, group) {
	window.webSocket.send(',fhadmin-agreeqgroup,' + uid + ",fh," + group);
}

//踢出群，发踢出信息给对方
function kickoutQgroup(uid, group) {
	window.webSocket.send(',fhadmin-kickoutqgroup,' + uid + ",fh," + group);
}

//申请好友，发送消息
function applyFriend(uid) {
	window.webSocket.send(',fhadmin-applyfriend,' + uid);
}

//申请加群，发送消息
function applyQgroup(QGROUP_ID) {
	window.webSocket.send(',fhadmin-applyqgroup,' + QGROUP_ID);
}