/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.consts;

import com.alibaba.xxpt.gateway.shared.api.request.OapiGettokenJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.request.OapiRpcOauth2DingtalkAppUserJsonRequest;
import com.alibaba.xxpt.gateway.shared.api.response.OapiGettokenJsonResponse;
import com.alibaba.xxpt.gateway.shared.api.response.OapiRpcOauth2DingtalkAppUserJsonResponse;
import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentGetClient;
import com.alibaba.xxpt.gateway.shared.client.http.IntelligentPostClient;
import com.alibaba.xxpt.gateway.shared.client.http.api.OapiRequest;
import com.artfess.base.conf.YkzDingConfig;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.integrate.model.YkbTokenModel;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class YyzDingConsts {
    protected static Logger log = LoggerFactory.getLogger(YyzDingConsts.class);
    @Autowired
    @Lazy
    private ExecutableClient executableClient;
    @Autowired
    private YkzDingConfig ykzDingConfig;
    private YkbTokenModel model = new YkbTokenModel();

    public String getUserInfoByAuthCode(String authCode) throws IOException {
        String agentToken = this.getAgentToken();
        IntelligentPostClient intelligentPostClient = this.executableClient.newIntelligentPostClient("/rpc/oauth2/dingtalk_app_user.json");
        OapiRpcOauth2DingtalkAppUserJsonRequest oapiRpcOauth2DingtalkAppUserJsonRequest = new OapiRpcOauth2DingtalkAppUserJsonRequest();
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAccess_token(agentToken);
        oapiRpcOauth2DingtalkAppUserJsonRequest.setAuth_code(authCode);
        OapiRpcOauth2DingtalkAppUserJsonResponse apiResult = (OapiRpcOauth2DingtalkAppUserJsonResponse)intelligentPostClient.post((OapiRequest)oapiRpcOauth2DingtalkAppUserJsonRequest);
        if (apiResult.getSuccess().booleanValue()) {
            JsonNode jsonNode = JsonUtil.toJsonNode((String)apiResult.getContent());
            JsonNode content = jsonNode.get("content");
            if (content.get("success").asText().equals("true")) {
                JsonNode userJson = content.get("data");
                String user = userJson.toString();
                return user;
            }
            String msg = content.get("responseMessage").asText();
            String msgCode = content.get("responseCode").asText();
            HashMap<String, String> msgMap = new HashMap<String, String>();
            msgMap.put("message", msg);
            msgMap.put("code", msgCode);
            log.error("\u83b7\u53d6\u6109\u5feb\u653f\u7528\u6237\u9519\u8bef\uff1a" + msg);
            JsonNode j = JsonUtil.toJsonNode(msgMap);
            return j.toString();
        }
        String msg = apiResult.getMessage();
        String eizErrorCode = apiResult.getBizErrorCode();
        HashMap<String, String> msgMap = new HashMap<String, String>();
        msgMap.put("message", msg);
        msgMap.put("code", eizErrorCode);
        log.error("\u83b7\u53d6\u6109\u5feb\u653f\u7528\u6237\u9519\u8bef\uff1a" + msg);
        JsonNode j = JsonUtil.toJsonNode(msgMap);
        return j.toString();
    }

    public synchronized String getAgentToken() throws IOException {
        if (!this.model.isAgentInit()) {
            String agentToken = this.requestAgentToken();
            return agentToken;
        }
        if (this.model.isExpire(this.model.getAgentTokenlastUpdTime(), this.model.getExprieIn())) {
            String agentToken = this.requestAgentToken();
            return agentToken;
        }
        return this.model.getAgentToken();
    }

    public String requestAgentToken() throws IOException {
        this.executableClient.init();
        IntelligentGetClient intelligentGetClient = this.executableClient.newIntelligentGetClient("/gettoken.json");
        OapiGettokenJsonRequest oapiGettokenJsonRequest = new OapiGettokenJsonRequest();
        oapiGettokenJsonRequest.setAppkey(this.ykzDingConfig.getWebAppKey());
        oapiGettokenJsonRequest.setAppsecret(this.ykzDingConfig.getWebAppSecret());
        OapiGettokenJsonResponse apiResult = (OapiGettokenJsonResponse)intelligentGetClient.get((OapiRequest)oapiGettokenJsonRequest);
        if (apiResult.getSuccess().booleanValue()) {
            String result = apiResult.getContent().getData();
            if (StringUtil.isNotEmpty((String)result)) {
                JsonNode jsonNode = JsonUtil.toJsonNode((String)result);
                String token = jsonNode.get("accessToken").asText();
                int expiresIn = jsonNode.get("expiresIn").asInt();
                this.model.setAgentToken(token, expiresIn);
                return token;
            }
            this.model.setInit(false);
            log.error("\u83b7\u53d6\u5e94\u7528token\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u83b7\u53d6\u5e94\u7528token\u4e3a\u7a7a!");
        }
        String errMsg = apiResult.getMessage();
        throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:<br>" + errMsg);
    }
}

