package com.artfess.bpm.plugin.core.util;

import java.util.ArrayList;
import java.util.List;

import com.artfess.base.util.AppUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;

public final class UserConverter {
	/**
	 * 根据BpmIdentity查询并转换
	 * @param bpmIdentities
	 * @param userService
	 * @return 
	 * List<User>
	 * @exception 
	 * @since  1.0.0
	 */
	public static List<IUser> queryAndConvert(List<BpmIdentity> bpmIdentities){
		IUserService userService = AppUtil.getBean(IUserService.class);
		
		List<IUser> userList = new ArrayList<IUser>();
		for(BpmIdentity bpmIdentity:bpmIdentities){
			IUser user = userService.getUserById(bpmIdentity.getId());
			userList.add(user);
		}
		return userList;
	}
}
