/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.editor;

import com.artfess.poi.ExcelContext;
import com.artfess.poi.editor.AbstractEditor;
import com.artfess.poi.editor.ColumnEditor;
import com.artfess.poi.editor.IFontEditor;
import com.artfess.poi.editor.RowEditor;
import com.artfess.poi.editor.SheetEditor;
import com.artfess.poi.editor.font.BoldFontEditor;
import com.artfess.poi.editor.font.FontColorEditor;
import com.artfess.poi.editor.font.FontHeightEditor;
import com.artfess.poi.editor.font.ItalicFontEditor;
import com.artfess.poi.editor.listener.CellValueListener;
import com.artfess.poi.style.Align;
import com.artfess.poi.style.BorderStyle;
import com.artfess.poi.style.Color;
import com.artfess.poi.style.FillPattern;
import com.artfess.poi.style.VAlign;
import com.artfess.poi.style.font.Font;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class CellEditor
extends AbstractEditor {
    private static ItalicFontEditor italicFont = new ItalicFontEditor();
    private static BoldFontEditor boldFont = new BoldFontEditor();
    private static FontColorEditor fontColor = new FontColorEditor();
    private static FontHeightEditor fontHeight = new FontHeightEditor();
    private List<HSSFCell> workingCell = new ArrayList<HSSFCell>(2);

    public CellEditor(int row, int col, ExcelContext context) {
        this(context);
        this.add(row, col);
    }

    public CellEditor(ExcelContext context) {
        super(context);
    }

    public CellEditor value(Object value) {
        for (HSSFCell cell : this.workingCell) {
            this.setCellValue(cell, value, null);
        }
        return this;
    }

    public CellEditor value(Object value, String pattern) {
        for (HSSFCell cell : this.workingCell) {
            this.setCellValue(cell, value, pattern);
        }
        return this;
    }

    public Object value() {
        if (this.workingCell.size() == 1) {
            return this.getCellValue(this.workingCell.get(0));
        }
        Object[] vals = new Object[this.workingCell.size()];
        int i = 0;
        for (HSSFCell cell : this.workingCell) {
            vals[i++] = this.getCellValue(cell);
        }
        return vals;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (HSSFCell cell : this.workingCell) {
            str.append(cell.toString()).append("\t");
        }
        if (str.length() > 0) {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    protected CellEditor add(int row, int col) {
        HSSFCell cell = this.getCell(row, col);
        this.workingCell.add(cell);
        return this;
    }

    protected CellEditor add(RowEditor row, int col) {
        HSSFCell cell = this.getCell(row.getHSSFRow(), col);
        this.workingCell.add(cell);
        return this;
    }

    protected CellEditor add(int row, ColumnEditor col) {
        return this.add(row, col.getCol());
    }

    protected CellEditor add(CellEditor cell) {
        this.workingCell.addAll(cell.getWorkingCell());
        return this;
    }

    public CellEditor border(BorderStyle borderStyle, Color borderColor) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setBorderBottom(borderStyle.getBorderType());
            this.tempCellStyle.setBorderTop(borderStyle.getBorderType());
            this.tempCellStyle.setBorderLeft(borderStyle.getBorderType());
            this.tempCellStyle.setBorderRight(borderStyle.getBorderType());
            this.tempCellStyle.setBottomBorderColor(borderColor.getIndex());
            this.tempCellStyle.setTopBorderColor(borderColor.getIndex());
            this.tempCellStyle.setLeftBorderColor(borderColor.getIndex());
            this.tempCellStyle.setRightBorderColor(borderColor.getIndex());
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor borderLeft(BorderStyle borderStyle, Color borderColor) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setBorderLeft(borderStyle.getBorderType());
            this.tempCellStyle.setLeftBorderColor(borderColor.getIndex());
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor borderRight(BorderStyle borderStyle, Color borderColor) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setBorderRight(borderStyle.getBorderType());
            this.tempCellStyle.setRightBorderColor(borderColor.getIndex());
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor borderTop(BorderStyle borderStyle, Color borderColor) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setBorderTop(borderStyle.getBorderType());
            this.tempCellStyle.setTopBorderColor(borderColor.getIndex());
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor borderBottom(BorderStyle borderStyle, Color borderColor) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setBorderBottom(borderStyle.getBorderType());
            this.tempCellStyle.setBottomBorderColor(borderColor.getIndex());
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor font(IFontEditor fontEditor) {
        Map<Integer, HSSFFont> fontCache = this.ctx.getFontCache();
        for (HSSFCell cell : this.workingCell) {
            HSSFFont font = cell.getCellStyle().getFont((Workbook)this.workBook);
            this.copyFont(font, this.tempFont);
            fontEditor.updateFont(new Font(this.tempFont));
            int fontHash = this.tempFont.hashCode() - this.tempFont.getIndex();
            this.tempCellStyle.cloneStyleFrom(cell.getCellStyle());
            if (fontCache.containsKey(fontHash)) {
                this.tempCellStyle.setFont(fontCache.get(fontHash));
            } else {
                HSSFFont newFont = this.workBook.createFont();
                this.copyFont(this.tempFont, newFont);
                this.tempCellStyle.setFont(newFont);
                int newFontHash = newFont.hashCode() - newFont.getIndex();
                fontCache.put(newFontHash, newFont);
            }
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor bold() {
        this.font(boldFont);
        return this;
    }

    public CellEditor fontHeightInPoint(int height) {
        fontHeight.setHeight(height);
        this.font(fontHeight);
        return this;
    }

    public CellEditor color(Color color) {
        fontColor.setColor(color);
        this.font(fontColor);
        return this;
    }

    public CellEditor italic() {
        this.font(italicFont);
        return this;
    }

    public CellEditor bgColor(Color bg) {
        return this.bgColor(bg, FillPattern.SOLID_FOREGROUND);
    }

    public CellEditor bgColor(Color bg, FillPattern fillPattern) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setFillPattern(fillPattern.getFillPattern());
            this.tempCellStyle.setFillForegroundColor(bg.getIndex());
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor align(Align align) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setAlignment(align.getAlignment());
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor vAlign(VAlign align) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setVerticalAlignment(align.getAlignment());
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor warpText(boolean autoWarp) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setWrapText(autoWarp);
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor hidden(boolean hidden) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setHidden(hidden);
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor indent(int indent) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setIndention((short)indent);
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor lock(boolean locked) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setLocked(locked);
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor rotate(int rotation) {
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            this.tempCellStyle.setRotation((short)rotation);
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor comment(String content) {
        HSSFPatriarch patr = this.ctx.getHSSFPatriarch(this.workingSheet);
        for (HSSFCell cell : this.workingCell) {
            HSSFComment comment = patr.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, (short)cell.getColumnIndex(), cell.getRowIndex(), (short)(cell.getColumnIndex() + 3), cell.getRowIndex() + 4));
            comment.setString((RichTextString)new HSSFRichTextString(content));
            cell.setCellComment((Comment)comment);
        }
        return this;
    }

    public CellEditor style(HSSFCellStyle style) {
        for (HSSFCell cell : this.workingCell) {
            cell.setCellStyle(style);
        }
        return this;
    }

    public CellEditor dataFormat(String format) {
        short index = HSSFDataFormat.getBuiltinFormat((String)format);
        for (HSSFCell cell : this.workingCell) {
            HSSFCellStyle style = cell.getCellStyle();
            this.tempCellStyle.cloneStyleFrom(style);
            if (index == -1) {
                HSSFDataFormat dataFormat = this.ctx.getWorkBook().createDataFormat();
                index = dataFormat.getFormat(format);
            }
            this.tempCellStyle.setDataFormat(index);
            this.updateCellStyle(cell);
        }
        return this;
    }

    public CellEditor width(int width) {
        return this.width(new int[]{width});
    }

    protected CellEditor width(int[] widths) {
        int i = -1;
        for (HSSFCell cell : this.workingCell) {
            if (i >= widths.length - 1) break;
            this.workingSheet.setColumnWidth(cell.getColumnIndex(), widths[++i]);
        }
        return this;
    }

    public CellEditor addWidth(int width) {
        for (HSSFCell cell : this.workingCell) {
            int w = this.workingSheet.getColumnWidth(cell.getColumnIndex());
            this.workingSheet.setColumnWidth(cell.getColumnIndex(), width + w);
        }
        return this;
    }

    public CellEditor height(float height) {
        for (HSSFCell cell : this.workingCell) {
            HSSFRow row = this.getRow(cell.getRowIndex());
            row.setHeightInPoints(height);
        }
        return this;
    }

    protected CellEditor height(float[] heights) {
        int i = -1;
        for (HSSFCell cell : this.workingCell) {
            if (i >= heights.length - 1) break;
            HSSFRow row = this.getRow(cell.getRowIndex());
            row.setHeightInPoints(heights[++i]);
        }
        return this;
    }

    public CellEditor addHeight(float height) {
        for (HSSFCell cell : this.workingCell) {
            HSSFRow row = this.getRow(cell.getRowIndex());
            float h = row.getHeightInPoints();
            row.setHeightInPoints(height + h);
        }
        return this;
    }

    public RowEditor row() {
        return new RowEditor(this.workingCell.get(0).getRowIndex(), this.ctx);
    }

    public ColumnEditor colunm() {
        return new ColumnEditor(this.workingCell.get(0).getColumnIndex(), this.ctx);
    }

    public SheetEditor sheet() {
        return new SheetEditor(this.workingCell.get(0).getSheet(), this.ctx);
    }

    public HSSFCell toHSSFCell() {
        if (this.workingCell.size() > 0) {
            return this.workingCell.get(0);
        }
        return null;
    }

    public CellEditor activeCell() {
        if (this.workingCell.size() > 0) {
            this.workingCell.get(0).setAsActiveCell();
        }
        return this;
    }

    private void updateCellStyle(HSSFCell cell) {
        int tempStyleHash;
        Map<Integer, HSSFCellStyle> styleCache = this.ctx.getStyleCache();
        if (styleCache.containsKey(tempStyleHash = this.tempCellStyle.hashCode() - this.tempCellStyle.getIndex())) {
            cell.setCellStyle(styleCache.get(tempStyleHash));
        } else {
            HSSFCellStyle newStyle = this.workBook.createCellStyle();
            newStyle.cloneStyleFrom(this.tempCellStyle);
            cell.setCellStyle(newStyle);
            int newStyleHash = newStyle.hashCode() - newStyle.getIndex();
            styleCache.put(newStyleHash, newStyle);
        }
    }

    private void copyFont(HSSFFont src, HSSFFont dest) {
        dest.setBold(src.getBold());
        dest.setCharSet(src.getCharSet());
        dest.setColor(src.getColor());
        dest.setFontHeight(src.getFontHeight());
        dest.setFontHeightInPoints(src.getFontHeightInPoints());
        dest.setFontName(src.getFontName());
        dest.setItalic(src.getItalic());
        dest.setStrikeout(src.getStrikeout());
        dest.setTypeOffset(src.getTypeOffset());
        dest.setUnderline(src.getUnderline());
    }

    private void setCellValue(HSSFCell cell, Object value, String pattern) {
        if (value == null) {
            return;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof BigDecimal || value instanceof Byte) {
            cell.setCellValue(value.toString());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
            cell.setCellType(CellType.BOOLEAN);
        } else if (value != null && value.toString().startsWith("=")) {
            cell.setCellFormula(value.toString().substring(1));
            cell.setCellType(CellType.FORMULA);
        } else if (value instanceof Date) {
            if (pattern == null || pattern.trim().equals("")) {
                pattern = this.ctx.getDefaultStyle().getDefaultDatePattern();
            }
            cell.setCellValue((Date)value);
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(value == null ? "" : value.toString()));
            cell.setCellType(CellType.STRING);
        }
        if (pattern != null) {
            this.dataFormat(pattern);
        }
        this.invokeListener(cell, value);
    }

    private Object getCellValue(HSSFCell cell) {
        CellType cellType = cell.getCellTypeEnum();
        switch (cellType) {
            case BLANK: {
                return "";
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case ERROR: {
                return cell.getErrorCellValue();
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case STRING: {
                return cell.getRichStringCellValue().toString();
            }
        }
        return "";
    }

    private void invokeListener(HSSFCell cell, Object value) {
        StackTraceElement[] st = new Throwable().getStackTrace();
        try {
            for (StackTraceElement e : st) {
                Class<?>[] interfacesList;
                for (Class<?> clazz : interfacesList = Class.forName(e.getClassName()).getInterfaces()) {
                    if (!clazz.getSimpleName().equals("CellValueListener")) continue;
                    return;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int sheetIndex = this.workBook.getSheetIndex((Sheet)cell.getSheet());
        List<CellValueListener> listeners = this.ctx.getListenerList(sheetIndex);
        for (CellValueListener l : listeners) {
            l.onValueChange(this, value, cell.getRowIndex(), cell.getColumnIndex(), this.ctx.getExcel());
        }
    }

    protected List<HSSFCell> getWorkingCell() {
        return this.workingCell;
    }

    private double null2Double(Object s) {
        double v = 0.0;
        if (s != null) {
            try {
                v = Double.parseDouble(s.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }
}

