import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizCategory/v1/tree`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 查询绑定分类数量
export function treeCount(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizCategory/v1/count/type`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 查询物资分类
export function dataSupplierClass(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierMaterialCategory/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格绑定
export function dataAdd(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierMaterialCategoryDetails/v1/bathBind`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格删除绑定
export function dataDelete(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierMaterialCategoryDetails/v1/bathCancel?materialCategoryIds=${ids}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
