/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.dao.SysAreasDao;
import com.artfess.sysConfig.persistence.manager.SysAreasManager;
import com.artfess.sysConfig.persistence.model.SysAreas;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SysAreasManagerImpl
extends BaseManagerImpl<SysAreasDao, SysAreas>
implements SysAreasManager {
    @Resource
    SysAreasDao sysAreasDao;
    @Autowired
    RedisUtil redisUtil;

    @Override
    @Transactional
    public String saveSysAreas(SysAreas sysAreas) {
        Assert.notNull((Object)((Object)sysAreas), (String)"\u884c\u653f\u533a\u5212\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String msg = "";
        if (StringUtils.isNotBlank((CharSequence)sysAreas.getId())) {
            SysAreas old = (SysAreas)((Object)this.sysAreasDao.selectById((Serializable)((Object)sysAreas.getId())));
            this.newUpdateTree(sysAreas, old.getName());
            msg = "\u66f4\u65b0\u6210\u529f";
        } else {
            sysAreas.setHasChildren(0);
            sysAreas.setSn(this.getNextSequenceByParentId(sysAreas.getParentId()));
            this.newInsertTree(sysAreas);
            msg = "\u65b0\u589e\u6210\u529f";
        }
        this.redisUtil.del(new String[]{"bpm:sys:areas"});
        return msg;
    }

    @Override
    @Transactional
    public String saveBatchSysAreas(List<SysAreas> list) {
        String msg = "";
        if (!CollectionUtils.isEmpty(list)) {
            for (SysAreas sysAreas : list) {
                msg = this.saveSysAreas(sysAreas);
            }
        }
        return msg;
    }

    @Override
    public List<SysAreas> queryAreasEntity(SysAreas sysAreas) {
        List<Object> list = Collections.synchronizedList(new ArrayList());
        list = this.redisUtil.lGet("bpm:sys:areas", 0L, -1L);
        ArrayList<SysAreas> newList = new ArrayList<SysAreas>();
        if (CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty(list = this.sysAreasDao.selectAreasList(sysAreas))) {
            this.redisUtil.lSet("bpm:sys:areas", list);
        }
        for (Object e : list) {
            SysAreas newObj = (SysAreas)((Object)e);
            newList.add(newObj);
        }
        return newList;
    }

    @Override
    public List<SysAreas> queryByParentId(String parentId) {
        if (StringUtil.isEmpty((String)parentId)) {
            parentId = "root";
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PARENT_ID_", (Object)parentId);
        queryWrapper.orderByAsc((Object)"CODE_");
        List list = ((SysAreasDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    @Transactional
    public void updateSequence(Map<String, Integer> params) {
        Assert.notNull(params, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String key : params.keySet()) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.set((Object)"SN_", (Object)params.get(key))).eq((Object)"ID_", (Object)key);
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    @Transactional
    public void deleteBatch(String ids) {
        Assert.hasText((String)ids, (String)"\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> idsList = Arrays.asList(ids.split(","));
        idsList.forEach(s -> {
            SysAreas sysAreas = (SysAreas)((Object)((Object)this.sysAreasDao.selectById((Serializable)((Object)s))));
            if (!sysAreas.getParentId().equals("root")) {
                SysAreas parent = (SysAreas)((Object)((Object)this.sysAreasDao.selectById((Serializable)((Object)sysAreas.getParentId()))));
                parent.setHasChildren(parent.getHasChildren() - 1);
                this.update((Model)parent);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.like((Object)"FULL_ID_", (Object)sysAreas.getFullId());
            this.sysAreasDao.delete((Wrapper)queryWrapper);
        });
        this.redisUtil.del(new String[]{"bpm:sys:areas"});
    }

    @Override
    public JSONArray tree(SysAreas sysAreas) {
        List<SysAreas> list = this.queryAreasEntity(sysAreas);
        List tree = BeanUtils.listToTree(list);
        JSONArray array = JSONArray.parseArray((String)JSON.toJSONString((Object)BeanUtils.listToTree((List)tree)));
        for (Object o : array) {
            JSONObject jsonObject = (JSONObject)o;
            JSONArray childrenList = JSONArray.parseArray((String)JSON.toJSONString((Object)jsonObject.get((Object)"children")));
            if (null == childrenList || childrenList.size() < 1) {
                jsonObject.remove((Object)"children");
                continue;
            }
            jsonObject.put("children", (Object)this.processChildren(childrenList));
        }
        return array;
    }

    private JSONArray processChildren(JSONArray array) {
        for (Object o : array) {
            JSONObject jsonObject = (JSONObject)o;
            JSONArray childrenList = JSONArray.parseArray((String)JSON.toJSONString((Object)jsonObject.get((Object)"children")));
            if (null == childrenList || childrenList.size() < 1) {
                jsonObject.remove((Object)"children");
                continue;
            }
            jsonObject.put("children", (Object)this.processChildren(childrenList));
        }
        return array;
    }
}

