/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.process.def.BpmBoDef;
import com.artfess.bpm.api.model.process.def.BpmFormInit;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.def.FormInitItem;
import com.artfess.bpm.api.model.process.def.Restful;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.BaseBpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.model.form.Form;
import com.artfess.bpm.persistence.dao.BpmDefinitionDao;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class BpmDefUtil {
    public static ArrayNode getProcBoDef(BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt) throws IOException {
        DefaultBpmProcessDefExt defaultBpmProcessDefExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        List<ProcBoDef> procBoDefList = defaultBpmProcessDefExt.getBoDefList();
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode(procBoDefList);
        return jsonAry;
    }

    public static BpmBoDef getBpmBoDef(BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt) {
        DefaultBpmProcessDefExt defaultBpmProcessDefExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        List<ProcBoDef> procBoDefList = defaultBpmProcessDefExt.getBoDefList();
        String saveMode = defaultBpmProcessDefExt.isBoSaveToDb() ? "database" : "boObject";
        BpmBoDef boDef = new BpmBoDef();
        boDef.setBoDefs(procBoDefList);
        boDef.setBoSaveMode(saveMode);
        return boDef;
    }

    public static BpmBoDef getBpmBoDef(String defKey) throws Exception {
        BpmDefinitionAccessor definitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmDefinitionDao definitionDao = (BpmDefinitionDao)AppUtil.getBean(BpmDefinitionDao.class);
        DefaultBpmDefinition def = definitionDao.getMainByDefKey(defKey);
        BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt = definitionAccessor.getBpmProcessDef(def.getDefId());
        BpmBoDef boDef = BpmDefUtil.getBpmBoDef(bpmProcessDefExt);
        return boDef;
    }

    public static DefaultBpmProcessDefExt getProcessExt(BpmProcessInstance instance) throws Exception {
        BpmDefinitionAccessor definitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        if (definitionAccessor == null) {
            definitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
        }
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmProcessInstance topInstance = bpmProcessInstanceManager.getTopBpmProcessInstance(instance);
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = definitionAccessor.getBpmProcessDef(topInstance.getProcDefId());
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        return defExt;
    }

    public static List<BpmNodeDef> getNodeDefs(BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt) {
        List<BpmNodeDef> nodeDefs = bpmProcessDefExt.getBpmnNodeDefs();
        ArrayList<BpmNodeDef> list = new ArrayList<BpmNodeDef>();
        for (BpmNodeDef bpmNodeDef : nodeDefs) {
            NodeType nodeType = bpmNodeDef.getType();
            if (nodeType != NodeType.START && nodeType != NodeType.USERTASK && nodeType != NodeType.SIGNTASK) continue;
            list.add(bpmNodeDef);
        }
        return list;
    }

    public static List<ProcBoDef> parseBoDef(String json) throws JsonParseException, JsonMappingException, IOException {
        List procBoDefList = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<ProcBoDef>>(){});
        return procBoDefList;
    }

    public static BpmFormInit getBpmFormInit(BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt, String parentDefKey) {
        List<BpmNodeDef> nodeDefs = bpmProcessDefExt.getBpmnNodeDefs();
        BpmFormInit formInit = new BpmFormInit();
        for (BpmNodeDef bpmNodeDef : nodeDefs) {
            NodeType nodeType = bpmNodeDef.getType();
            if (nodeType != NodeType.START && nodeType != NodeType.USERTASK && nodeType != NodeType.SIGNTASK) continue;
            if (StringUtil.isNotEmpty((String)parentDefKey)) {
                formInit.setParentDefKey(parentDefKey);
            }
            BpmDefUtil.addFormInitItem(bpmNodeDef, formInit);
        }
        return formInit;
    }

    private static void addFormInitItem(BpmNodeDef def, BpmFormInit formInit) {
        BaseBpmNodeDef nodeDef = (BaseBpmNodeDef)def;
        List<FormInitItem> items = nodeDef.getFormInitItems();
        for (FormInitItem item : items) {
            if (!item.getParentDefKey().equals(formInit.getParentDefKey())) continue;
            formInit.addFormInitItem(item);
        }
    }

    public static String getFormXml(Form form) {
        if (form == null) {
            return "";
        }
        String pre = form.getFormType().equals(FormType.PC.value()) ? "ext:form" : "ext:mobileForm";
        return BpmDefUtil.getXmlBuilder(form, pre);
    }

    public static String getInstFormXml(Form form, boolean isPc) {
        if (form == null) {
            return "";
        }
        String pre = isPc ? "ext:instForm" : "ext:instMobileForm";
        return BpmDefUtil.getXmlBuilder(form, pre);
    }

    private static String getXmlBuilder(Form form, String xmlName) {
        String xml = "";
        if (BeanUtils.isEmpty((Object)form) || BeanUtils.isEmpty((Object)((Object)form.getType()))) {
            return "";
        }
        if (StringUtil.isEmpty((String)form.getFormValue()) && StringUtil.isEmpty((String)form.getHelpFile())) {
            return "";
        }
        try {
            XMLBuilder ruleBuilder = XMLBuilder.create((String)xmlName).a("xmlns:ext", "http://www.jee-soft.cn/bpm").a("name", form.getName()).a("type", BeanUtils.isEmpty((Object)((Object)form.getType())) ? "" : form.getType().value()).a("formValue", form.getFormValue()).a("formExtraConf", form.getFormExtraConf()).a("helpFile", form.getHelpFile());
            if (StringUtil.isNotEmpty((String)form.getParentFlowKey())) {
                ruleBuilder.a("parentFlowKey", form.getParentFlowKey());
            }
            if (form instanceof FormExt) {
                String postHandler;
                FormExt formExt = (FormExt)form;
                String prevHandler = formExt.getPrevHandler();
                if (StringUtil.isNotEmpty((String)prevHandler)) {
                    ruleBuilder.a("prevHandler", prevHandler);
                }
                if (StringUtil.isNotEmpty((String)(postHandler = formExt.getPostHandler()))) {
                    ruleBuilder.a("postHandler", postHandler);
                }
            }
            xml = ruleBuilder.asString();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public static String getRestfulXml(List<Restful> restfuls) {
        String xml = "";
        if (BeanUtils.isNotEmpty(restfuls)) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("<ext:globalRestFuls xmlns:ext=\"http://www.jee-soft.cn/bpm\" >");
                for (Restful restful : restfuls) {
                    try {
                        XMLBuilder xmlBuilder = XMLBuilder.create((String)"ext:globalRestFul", (String)"http://www.jee-soft.cn/bpm").e("ext:url").t(restful.getUrl()).up().e("ext:desc").t(restful.getDesc()).up().e("ext:header").t(restful.getHeader()).up().e("ext:invokeMode").t(String.valueOf(restful.getInvokeMode())).up().e("ext:callTime").t(restful.getCallTime()).up().a("params", restful.getParams()).a("outPutScript", restful.getOutPutScript()).a("parentDefKey", restful.getParentDefKey());
                        sb.append(xmlBuilder.asString() + "\n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sb.append("</ext:globalRestFuls>");
                xml = sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return xml;
    }
}

