/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.api.model.process.nodedef.ext.extmodel;

import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.constant.DecideType;
import com.artfess.bpm.api.constant.FollowMode;
import com.artfess.bpm.api.constant.VoteType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;

public class SignRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DecideType decideType = DecideType.REFUSE;
    private VoteType voteType = VoteType.AMOUNT;
    private FollowMode followMode = FollowMode.COMPLETE;
    private int voteAmount = 1;

    public SignRule() {
    }

    public SignRule(DecideType decideType, VoteType voteType, FollowMode followMode, int voteAmount) {
        this.decideType = decideType;
        this.voteType = voteType;
        this.followMode = followMode;
        this.voteAmount = voteAmount;
    }

    public DecideType getDecideType() {
        return this.decideType;
    }

    public void setDecideType(DecideType decideType) {
        this.decideType = decideType;
    }

    public VoteType getVoteType() {
        return this.voteType;
    }

    public void setVoteType(VoteType voteType) {
        this.voteType = voteType;
    }

    public FollowMode getFollowMode() {
        return this.followMode;
    }

    public void setFollowMode(FollowMode followMode) {
        this.followMode = followMode;
    }

    public int getVoteAmount() {
        return this.voteAmount;
    }

    public void setVoteAmount(int voteAmount) {
        this.voteAmount = voteAmount;
    }

    public static ObjectNode toJson(SignRule signRule) {
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        if (signRule == null) {
            return json;
        }
        json.put("voteAmount", signRule.getVoteAmount());
        json.put("followMode", signRule.getFollowMode().getKey());
        json.put("voteType", signRule.getVoteType().getKey());
        json.put("decideType", signRule.getDecideType().getKey());
        return json;
    }
}

