/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.service.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.manager.BpmCustomSignDataManager;
import com.artfess.bpm.persistence.manager.BpmReadRecordManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.BpmCustomSignData;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.workflow.runtime.params.CustomSignRevokeParam;
import com.artfess.workflow.runtime.service.RevokeService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BeforeSignRevokeService
implements RevokeService {
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;
    @Resource
    BpmReadRecordManager bpmReadRecordManager;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    public void canRevoke(Map<String, Object> map, List<DefaultBpmCheckOpinion> list, String isReadRevoke) {
        String type;
        String instId = MapUtil.getString(map, (String)"id");
        String taskId = MapUtil.getString(map, (String)"taskId");
        if (StringUtil.isEmpty((String)instId) || StringUtil.isEmpty((String)taskId)) {
            return;
        }
        List signDataList = this.bpmCustomSignDataManager.getSignDataByBeforeSignTaskId(instId, taskId);
        if (BeanUtils.isEmpty((Object)signDataList)) {
            return;
        }
        switch (type = ((BpmCustomSignData)signDataList.get(0)).getType()) {
            case "Sequential": {
                this.setRevoke(map, ((BpmCustomSignData)signDataList.get(0)).getTaskId(), isReadRevoke, this.bpmReadRecordManager);
                break;
            }
            case "Parallel": {
                map.put("needGetRevokeTasks", true);
                map.put("revoke", true);
                break;
            }
            case "ParallelApprove": {
                List allSignDataByBeforeSignTaskId = this.bpmCustomSignDataManager.getAllSignDataByBeforeSignTaskId(instId, taskId);
                if (!BeanUtils.isNotEmpty((Object)allSignDataByBeforeSignTaskId) || allSignDataByBeforeSignTaskId.size() != signDataList.size()) break;
                boolean revoke = true;
                for (BpmCustomSignData bpmCustomSignData : allSignDataByBeforeSignTaskId) {
                    Boolean isRead = this.bpmReadRecordManager.isTaskReadByOwner(bpmCustomSignData.getTaskId());
                    if (!"false".equals(isReadRevoke) || !isRead.booleanValue()) continue;
                    revoke = false;
                    break;
                }
                map.put("revoke", revoke);
            }
        }
    }

    @Override
    public void doRevoke(CustomSignRevokeParam revokeParamObject) throws Exception {
        String status;
        String instanceId = revokeParamObject.getInstanceId();
        List currentTasks = this.bpmTaskManager.getByInstId(instanceId);
        if (BeanUtils.isEmpty((Object)currentTasks)) {
            throw new BaseException("A\u540e\u7eed\u6ca1\u6709\u4efb\u52a1\u53ef\u4ee5\u64a4\u56de");
        }
        DefaultBpmTask currentTask = (DefaultBpmTask)currentTasks.get(0);
        String currentTaskIds = revokeParamObject.getCurrentTaskIds();
        switch (status = currentTask.getStatus()) {
            case "SIGNSEQUENCEED": {
                this.bpmTaskManager.sequentialTaskARevoke(instanceId, currentTask.getTaskId(), revokeParamObject.getTargetNodeId());
                break;
            }
            case "APPROVELINEED": {
                this.bpmTaskManager.approvalTaskARevoke(instanceId, currentTask.getTaskId(), revokeParamObject.getTargetTaskId(), revokeParamObject.getTargetNodeId());
                break;
            }
            case "SIGNLINEED": {
                if (StringUtil.isEmpty((String)currentTaskIds)) {
                    throw new BaseException("\u8bf7\u9009\u62e9\u64a4\u56de\u7684\u5e76\u7b7e\u4efb\u52a1");
                }
                this.bpmTaskManager.parallaelARevoke(instanceId, revokeParamObject.getTargetNodeId(), revokeParamObject.getCurrentTaskIds());
                break;
            }
            default: {
                throw new BaseException("\u64a4\u56de\u4efb\u52a1\u7c7b\u578b\u5fc5\u987b\u662f\u7b7e\u7f72\u5e76\u5ba1\u4efb\u52a1");
            }
        }
    }
}

