/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class IPUtils {
    public static String getIpAddr(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            if ((StringUtils.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) && (ip = request.getHeader("Proxy-Client-IP")) != null && !ip.isEmpty() && !"unKnown".equalsIgnoreCase(ip)) {
                int index = ip.indexOf(",");
                if (index != -1) {
                    return ip.substring(0, index);
                }
                return ip;
            }
            if (StringUtils.isEmpty((String)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("X-Real-IP");
            }
            if (StringUtils.isEmpty((String)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("IPUtils ERROR\uff01" + e.getMessage(), e);
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public static String getServerIp() {
        String sysType = System.getProperties().getProperty("os.name");
        if (sysType.toLowerCase().startsWith("win")) {
            String localIP = null;
            try {
                localIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("IPUtils ERROR\uff01" + e.getMessage(), e);
            }
            if (localIP != null) {
                return localIP;
            }
        } else {
            String ip = IPUtils.getIpByEthNum("eth0");
            if (ip != null) {
                return ip;
            }
        }
        return "\u83b7\u53d6\u670d\u52a1\u5668IP\u9519\u8bef";
    }

    private static String getIpByEthNum(String ethNum) {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (!ethNum.equals(netInterface.getName())) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("IPUtils ERROR\uff01" + e.getMessage(), e);
        }
        return "\u83b7\u53d6\u670d\u52a1\u5668IP\u9519\u8bef";
    }

    public static long ip2Long(String strIP) {
        long[] ip = new long[4];
        int position1 = strIP.indexOf(".");
        int position2 = strIP.indexOf(".", position1 + 1);
        int position3 = strIP.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIP.substring(0, position1));
        ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIP.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static long getIp2long(String ip) {
        ip = ip.trim();
        String[] ips = ip.split("\\.");
        long ip1 = Integer.parseInt(ips[0]);
        long ip2 = Integer.parseInt(ips[1]);
        long ip3 = Integer.parseInt(ips[2]);
        long ip4 = Integer.parseInt(ips[3]);
        long ip2long = 1L * ip1 * 256L * 256L * 256L + ip2 * 256L * 256L + ip3 * 256L + ip4;
        return ip2long;
    }

    public static boolean ipExistsInRange(String ip, String startIP, String endIP) {
        return IPUtils.getIp2long(startIP) <= IPUtils.getIp2long(ip) && IPUtils.getIp2long(ip) <= IPUtils.getIp2long(endIP);
    }

    public static String getLocalMac() throws Exception {
        InetAddress ia = InetAddress.getLocalHost();
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        System.out.println("mac\u6570\u7ec4\u957f\u5ea6\uff1a" + mac.length);
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mac.length; ++i) {
            int temp = mac[i] & 0xFF;
            String str = Integer.toHexString(temp);
            if (str.length() == 1) {
                sb.append("0" + str);
            } else {
                sb.append(str);
            }
            if (i >= mac.length - 1) continue;
            sb.append(':');
        }
        System.out.println("\u672c\u673aMAC\u5730\u5740:" + sb.toString().toUpperCase());
        return sb.toString().toUpperCase();
    }

    public static String getMacAddr() {
        String MacAddr = "";
        String str = "";
        try {
            NetworkInterface NIC = NetworkInterface.getByName("eth0");
            byte[] buf = NIC.getHardwareAddress();
            for (int i = 0; i < buf.length; ++i) {
                str = str + IPUtils.byteHEX(buf[i]);
            }
            MacAddr = str.toUpperCase();
        }
        catch (SocketException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return MacAddr;
    }

    public static String byteHEX(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    public static String getServerMac() throws Exception {
        String sysType = System.getProperties().getProperty("os.name");
        String mac = "\u83b7\u53d6\u670d\u52a1\u5668MAC\u9519\u8bef";
        mac = sysType.toLowerCase().startsWith("win") ? IPUtils.getLocalMac() : IPUtils.getMacAddr();
        return mac;
    }

    public static void main(String[] args) throws Exception {
        IPUtils.getLocalMac();
    }
}

