/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.persistence.manager.impl;

import com.artfess.application.model.MessageReceiver;
import com.artfess.application.model.SysExecutor;
import com.artfess.application.model.SysMessage;
import com.artfess.application.persistence.dao.SysMessageDao;
import com.artfess.application.persistence.manager.MessageReceiverManager;
import com.artfess.application.persistence.manager.SysMessageManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="sysMessageManager")
public class SysMessageManagerImpl
extends BaseManagerImpl<SysMessageDao, SysMessage>
implements SysMessageManager {
    @Resource
    MessageReceiverManager messageReceiverManager;

    @Override
    public PageList<SysMessage> getMsgByUserId(QueryFilter queryFilter) {
        this.page(queryFilter.getPageBean());
        Map<String, Object> map = new HashMap();
        map = queryFilter.getInitParams();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        queryFilter.setQuerys(new ArrayList());
        return new PageList(((SysMessageDao)this.baseMapper).getMsgByUserId((IPage<SysMessage>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SysMessage>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Override
    public CommonResult<String> sendMsg(String subject, String content, String messageType, String typeKey, String senderId, String senderName, List<SysExecutor> receivers) {
        String id = UniqueIdUtil.getSuid();
        SysMessage sysMessage = new SysMessage();
        sysMessage.setId(id);
        sysMessage.setSubject(subject);
        sysMessage.setContent(content);
        sysMessage.setOwnerId(StringUtil.isEmpty((String)senderId) ? "-1" : senderId);
        sysMessage.setOwner(StringUtil.isEmpty((String)senderName) ? "x7\u7cfb\u7edf" : senderName);
        sysMessage.setMessageType(messageType);
        sysMessage.setTypeKey(typeKey);
        sysMessage.setCanReply((short)0);
        sysMessage.setIsPublic((short)0);
        sysMessage.setCreateTime(LocalDateTime.now());
        this.create((Model)sysMessage);
        for (SysExecutor sysExecutor : receivers) {
            MessageReceiver receiver = new MessageReceiver();
            receiver.setId(UniqueIdUtil.getSuid());
            receiver.setMsgId(id);
            receiver.setReceiverId(sysExecutor.getId());
            receiver.setReceiver(sysExecutor.getName());
            receiver.setReceiverType(sysExecutor.getType());
            this.messageReceiverManager.create((Model)receiver);
        }
        return new CommonResult(true, "\u53d1\u9001\u6d88\u606f\u6210\u529f!");
    }

    @Override
    public void addMessageSend(SysMessage sysMessage) {
        MessageReceiver receiver;
        String name;
        String id;
        int i;
        String messageId = sysMessage.getId();
        String receiverIds = sysMessage.getReceiverId();
        String receiverNames = sysMessage.getReceiverName();
        String receiverOrgIds = sysMessage.getReceiverOrgId();
        String receiverOrgNames = sysMessage.getReceiverOrgName();
        IUser sender = ContextUtil.getCurrentUser();
        messageId = UniqueIdUtil.getSuid();
        sysMessage.setId(messageId);
        sysMessage.setOwnerId(sender.getUserId());
        sysMessage.setOwner(sender.getFullname());
        sysMessage.setCreateTime(LocalDateTime.now());
        if (sysMessage.getIsPublic() == SysMessage.iS_PUBLIC_YES) {
            this.create((Model)sysMessage);
            return;
        }
        String receriver = "";
        if (StringUtil.isNotEmpty((String)receiverNames) && StringUtil.isNotEmpty((String)receiverOrgNames)) {
            receriver = receiverNames + "," + receiverOrgNames;
        } else if (StringUtil.isNotEmpty((String)receiverNames) && StringUtil.isEmpty((String)receiverOrgNames)) {
            receriver = receiverNames;
        } else if (StringUtil.isEmpty((String)receiverNames) && StringUtil.isNotEmpty((String)receiverOrgNames)) {
            receriver = receiverOrgNames;
        }
        sysMessage.setReceiverName(receriver);
        this.create((Model)sysMessage);
        if (StringUtil.isNotEmpty((String)receiverIds)) {
            String[] idArr = receiverIds.split(",");
            String[] nameArr = receiverNames.split(",");
            for (i = 0; i < idArr.length; ++i) {
                id = idArr[i];
                if (StringUtil.isEmpty((String)id)) continue;
                name = "";
                if (nameArr.length > i) {
                    name = nameArr[i];
                }
                receiver = new MessageReceiver();
                receiver.setId(UniqueIdUtil.getSuid());
                receiver.setMsgId(messageId);
                receiver.setReceiverType(MessageReceiver.TYPE_USER);
                receiver.setReceiverId(id);
                receiver.setReceiver(name);
                this.messageReceiverManager.create((Model)receiver);
            }
        }
        if (StringUtil.isNotEmpty((String)receiverOrgIds)) {
            String[] orgIdArr = receiverOrgIds.split(",");
            String[] orgNameArr = receiverOrgNames.split(",");
            for (i = 0; i < orgIdArr.length; ++i) {
                id = orgIdArr[i];
                if (StringUtil.isEmpty((String)id)) continue;
                name = "";
                if (orgNameArr.length > i) {
                    name = orgNameArr[i];
                }
                receiver = new MessageReceiver();
                receiver.setId(UniqueIdUtil.getSuid());
                receiver.setMsgId(messageId);
                receiver.setReceiverType(MessageReceiver.TYPE_GROUP);
                receiver.setReceiverId(id);
                receiver.setReceiver(name);
                this.messageReceiverManager.create((Model)receiver);
            }
        }
    }

    @Override
    public SysMessage getNotReadMsg(String userId) {
        String dbtype = SQLUtil.getDbType();
        if (dbtype.equals("db2")) {
            return ((SysMessageDao)this.baseMapper).getOneNotReadMsgByUserIdDb2(userId);
        }
        if (dbtype.equals("oracle")) {
            return ((SysMessageDao)this.baseMapper).getOneNotReadMsgByUserIdOracl(userId);
        }
        if (dbtype.equals("mssql")) {
            return ((SysMessageDao)this.baseMapper).getOneNotReadMsgByUserIdMssql(userId);
        }
        return ((SysMessageDao)this.baseMapper).getOneNotReadMsgByUserIdMysql(userId);
    }

    @Override
    public int getNotReadMsgNum(String userId) {
        return ((SysMessageDao)this.baseMapper).getNotReadMsgNum(userId).size();
    }

    @Override
    public int getMsgSize(String receiverId) {
        return ((SysMessageDao)this.baseMapper).getMsgSize(receiverId).size();
    }
}

