/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterTableBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.artfess.dataShare.util.ExcelFillCellMergeStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class EasyExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(EasyExcelUtil.class);
    private static Sheet initSheet = new Sheet(1, 0);

    public static List<Object> readLessThan1000Row(String filePath) {
        return EasyExcelUtil.readLessThan1000RowBySheet(filePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> readLessThan1000RowBySheet(String filePath, Sheet sheet) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        sheet = sheet != null ? sheet : initSheet;
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(filePath);
            List list = EasyExcelFactory.read((InputStream)fileStream, (Sheet)sheet);
            return list;
        }
        catch (FileNotFoundException e) {
            log.info("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)filePath);
        }
        finally {
            try {
                if (fileStream != null) {
                    ((InputStream)fileStream).close();
                }
            }
            catch (IOException e) {
                log.info("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
        return null;
    }

    public static List<Object> readMoreThan1000Row(String filePath) {
        return EasyExcelUtil.readMoreThan1000RowBySheet(filePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> readMoreThan1000Row(InputStream fileStream) {
        try {
            ExcelListener excelListener = new ExcelListener();
            EasyExcelFactory.readBySax((InputStream)fileStream, (Sheet)initSheet, (AnalysisEventListener)excelListener);
            List<Object> list = excelListener.getDatas();
            return list;
        }
        catch (Exception e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e) {
                log.error("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> readMoreThan1000RowBySheet(String filePath, Sheet sheet) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        sheet = sheet != null ? sheet : initSheet;
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(filePath);
            ExcelListener excelListener = new ExcelListener();
            EasyExcelFactory.readBySax((InputStream)fileStream, (Sheet)sheet, (AnalysisEventListener)excelListener);
            List<Object> list = excelListener.getDatas();
            return list;
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)filePath);
        }
        finally {
            try {
                if (fileStream != null) {
                    ((InputStream)fileStream).close();
                }
            }
            catch (IOException e) {
                log.error("excel\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
        return null;
    }

    public static void writeBySimple(String filePath, List<List<Object>> data, List<String> head) {
        EasyExcelUtil.writeSimpleBySheet(filePath, data, head, null);
    }

    public static void writeBySimple(String filePath, List<String> head) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSimpleBySheet(String filePath, List<List<Object>> data, List<String> head, Sheet sheet) {
        Sheet sheet2 = sheet = sheet != null ? sheet : initSheet;
        if (head != null) {
            ArrayList list = new ArrayList();
            head.forEach(h -> list.add(Collections.singletonList(h)));
            sheet.setHead(list);
        }
        FileOutputStream outputStream = null;
        ExcelWriter writer = null;
        try {
            outputStream = new FileOutputStream(filePath);
            writer = EasyExcelFactory.getWriter((OutputStream)outputStream);
            writer.write1(data, sheet);
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)filePath);
        }
        finally {
            try {
                if (writer != null) {
                    writer.finish();
                }
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                log.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
    }

    public static void writeWithTemplate(String filePath, List<? extends BaseRowModel> data) {
        EasyExcelUtil.writeWithTemplateAndSheet(filePath, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithTemplateAndSheet(String filePath, List<? extends BaseRowModel> data, Sheet sheet) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        sheet = sheet != null ? sheet : initSheet;
        sheet.setClazz(data.get(0).getClass());
        FileOutputStream outputStream = null;
        ExcelWriter writer = null;
        try {
            outputStream = new FileOutputStream(filePath);
            writer = EasyExcelFactory.getWriter((OutputStream)outputStream);
            writer.write(data, sheet);
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)filePath);
        }
        finally {
            try {
                if (writer != null) {
                    writer.finish();
                }
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                log.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithMultipleSheel(String filePath, List<MultipleSheelPropety> multipleSheelPropetys) {
        if (CollectionUtils.isEmpty(multipleSheelPropetys)) {
            return;
        }
        FileOutputStream outputStream = null;
        ExcelWriter writer = null;
        try {
            outputStream = new FileOutputStream(filePath);
            writer = EasyExcelFactory.getWriter((OutputStream)outputStream);
            for (MultipleSheelPropety multipleSheelPropety : multipleSheelPropetys) {
                Sheet sheet;
                Sheet sheet2 = sheet = multipleSheelPropety.getSheet() != null ? multipleSheelPropety.getSheet() : initSheet;
                if (!CollectionUtils.isEmpty(multipleSheelPropety.getData())) {
                    sheet.setClazz(multipleSheelPropety.getData().get(0).getClass());
                }
                writer.write(multipleSheelPropety.getData(), sheet);
            }
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)filePath);
        }
        finally {
            try {
                if (writer != null) {
                    writer.finish();
                }
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                log.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
    }

    public static void writeWithMultipleSheet(String filePath, List<List<String>> headList, List<List<String>> data) {
        try {
            FileOutputStream outputStream = new FileOutputStream(new File(filePath));
            ExcelWriter writer = EasyExcel.write((OutputStream)outputStream).build();
            WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0).needHead(Boolean.FALSE)).sheetName("sheet\u9875\u540d\u79f0").build();
            WriteTable table = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)1).head(headList)).registerWriteHandler((WriteHandler)new ExcelFillCellMergeStrategy(1, new int[]{0, 1, 2}))).needHead(Boolean.TRUE)).build();
            writer.write(data, sheet, table);
            WriteSheet sheet1 = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1).needHead(Boolean.FALSE)).sheetName("sheet\u9875\u540d\u79f02").build();
            WriteTable table1 = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)2).head(headList)).registerWriteHandler((WriteHandler)new ExcelFillCellMergeStrategy(1, new int[]{0, 1, 2}))).needHead(Boolean.TRUE)).build();
            writer.write(data, sheet1, table1);
            writer.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        initSheet.setSheetName("sheet");
        initSheet.setAutoWidth(Boolean.TRUE);
    }

    public static class ExcelListener
    extends AnalysisEventListener {
        private List<Object> datas = new ArrayList<Object>();

        public void invoke(Object object, AnalysisContext context) {
            if (object != null) {
                this.datas.add(object);
            }
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public List<Object> getDatas() {
            return this.datas;
        }

        public void setDatas(List<Object> datas) {
            this.datas = datas;
        }
    }

    public static class MultipleSheelPropety {
        private List<? extends BaseRowModel> data;
        private Sheet sheet;

        public List<? extends BaseRowModel> getData() {
            return this.data;
        }

        public Sheet getSheet() {
            return this.sheet;
        }

        public void setData(List<? extends BaseRowModel> data) {
            this.data = data;
        }

        public void setSheet(Sheet sheet) {
            this.sheet = sheet;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultipleSheelPropety)) {
                return false;
            }
            MultipleSheelPropety other = (MultipleSheelPropety)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<? extends BaseRowModel> this$data = this.getData();
            List<? extends BaseRowModel> other$data = other.getData();
            if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
                return false;
            }
            Sheet this$sheet = this.getSheet();
            Sheet other$sheet = other.getSheet();
            return !(this$sheet == null ? other$sheet != null : !this$sheet.equals(other$sheet));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultipleSheelPropety;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<? extends BaseRowModel> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            Sheet $sheet = this.getSheet();
            result = result * 59 + ($sheet == null ? 43 : $sheet.hashCode());
            return result;
        }

        public String toString() {
            return "EasyExcelUtil.MultipleSheelPropety(data=" + this.getData() + ", sheet=" + this.getSheet() + ")";
        }
    }
}

