/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.app.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.app.dao.BizAppCatalogsTableFieldDao;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableFieldManager;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsTableManager;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTable;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTableField;
import com.artfess.dataShare.dataResource.app.vo.BizAppFieldVo;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableDetailVo;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizAppCatalogsTableFieldManagerImpl
extends BaseManagerImpl<BizAppCatalogsTableFieldDao, BizAppCatalogsTableField>
implements BizAppCatalogsTableFieldManager {
    @Autowired
    BizAppCatalogsTableManager tableManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void export(MultipartFile file, String tableId) throws Exception {
        BizAppCatalogsTable table = (BizAppCatalogsTable)this.tableManager.get((Serializable)((Object)tableId));
        String tableName = table.getTableNameEn();
        ExcelTool util = new ExcelTool(BizAppFieldVo.class);
        List list = util.importExcel(file.getInputStream(), Integer.valueOf(2), Integer.valueOf(2));
        list = list.stream().filter(vo -> StringUtil.isNotEmpty((String)vo.getFieldCode())).collect(Collectors.toList());
        for (int i = 1; i < list.size(); ++i) {
            BizAppFieldVo vo2 = (BizAppFieldVo)list.get(i);
            if (!this.checkExistsField(tableId, vo2.getFieldCode())) continue;
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u5b57\u6bb5(" + vo2.getFieldCode() + ")\u3011\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
        }
        List disFieldList = list.stream().map(p -> p.getFieldCode()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < list.size()) {
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        for (int i = 1; i < list.size(); ++i) {
            BizAppFieldVo vo3 = (BizAppFieldVo)list.get(i);
            if (StringUtil.isEmpty((String)vo3.getFieldCode())) continue;
            BizAppCatalogsTableField field = BizAppFieldVo.parse(vo3);
            field.setTableId(tableId);
            if ("\u7ba1\u7406\u5b57\u6bb5".equals(vo3.getFieldType())) {
                field.setFieldType("1");
            } else if ("\u4e1a\u52a1\u5b57\u6bb5".equals(vo3.getFieldType())) {
                field.setFieldType("2");
            }
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
            field.setFlSql(fieldSq);
            field.setMouldName(table.getName());
            field.setMouldCode(table.getCode());
            field.setCode(field.getFieldCode());
            field.setIsDele("0");
            this.create((Model)field);
        }
    }

    public boolean checkExistsField(String tableId, String fieldName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID_", (Object)tableId);
        queryWrapper.eq((Object)"FIELD_CODE_", (Object)fieldName);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    public boolean checkExistsField(String tableId, String fieldName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID_", (Object)tableId);
        queryWrapper.eq((Object)"FIELD_CODE_", (Object)fieldName);
        queryWrapper.ne((Object)"ID_", (Object)id);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public List<BizAppCatalogsTableField> queryFieldByTableId(String tableId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_id_", (Object)tableId);
        queryWrapper.orderByAsc((Object)"sn_");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTableField(BizAppTableDetailVo vo) {
        BizAppCatalogsTable table = vo.getTable();
        List<BizAppCatalogsTableField> listField = vo.getFieldList();
        List disFieldList = listField.stream().map(p -> p.getFieldCode()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < listField.size()) {
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        if (StringUtil.isEmpty((String)table.getId())) {
            this.tableManager.create((Model)table);
        } else {
            this.tableManager.update((Model)table);
        }
        for (BizAppCatalogsTableField item : listField) {
            if (StringUtil.isEmpty((String)item.getId()) ? this.checkExistsField(table.getTableNameEn(), item.getFieldCode()) : this.checkExistsField(table.getTableNameEn(), item.getFieldCode(), item.getId())) {
                throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u5b57\u6bb5(" + item.getFieldCode() + ")\u3011\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
            }
            item.setTableId(table.getId());
            item.setFieldType("2");
        }
        this.saveOrUpdateBatch(listField);
    }

    @Override
    public void saveOrUpdates(List<BizAppCatalogsTableField> field) {
        List disFieldList = field.stream().map(p -> p.getFieldCode()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < field.size()) {
            throw new BaseException("\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        String tableId = field.get(0).getTableId();
        List<BizAppCatalogsTableField> oldFields = this.queryFieldByTableId(tableId);
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0) {
            this.removeByIds(oldFields.stream().filter(p -> "2".equals(p.getFieldType())).map(entity -> entity.getId()).collect(Collectors.toList()));
        }
        if (oldFields.size() == 0) {
            this.addManageField(oldFields);
        }
        for (BizAppCatalogsTableField item : field) {
            if (StringUtil.isEmpty((String)item.getId())) {
                if (this.checkExistsField(tableId, item.getFieldCode())) {
                    throw new BaseException("\u8868\u4e2d\u5b58\u5728\u5b57\u6bb5(" + item.getFieldCode() + ")\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
                }
            } else if (this.checkExistsField(tableId, item.getFieldCode(), item.getId())) {
                throw new BaseException("\u8868\u4e2d\u5b58\u5728\u5b57\u6bb5(" + item.getFieldCode() + "\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
            }
            item.setTableId(tableId);
            item.setFieldCode(item.getCode());
            item.setId(null);
        }
        if (field.size() > 0) {
            this.saveBatch(field);
        }
    }

    private void addManageField(List<BizAppCatalogsTableField> fieldList) {
        BizAppCatalogsTableField createBy = new BizAppCatalogsTableField();
        createBy.setFieldCode("CREATE_BY_");
        createBy.setName("\u521b\u5efa\u4eba");
        createBy.setCode("CREATE_BY_");
        createBy.setDesc("\u521b\u5efa\u4eba");
        createBy.setDataType("varchar");
        createBy.setAttrLength(200);
        createBy.setIsPk("0");
        createBy.setIsRequired("0");
        createBy.setIsEncrypt("0");
        createBy.setDecimalLen(0);
        createBy.setFieldType("1");
        createBy.setIsDele("0");
        BizAppCatalogsTableField createOrgId = new BizAppCatalogsTableField();
        createOrgId.setFieldCode("CREATE_ORG_ID_");
        createOrgId.setName("\u521b\u5efa\u5355\u4f4d");
        createOrgId.setCode("CREATE_ORG_ID_");
        createOrgId.setDesc("\u521b\u5efa\u5355\u4f4d");
        createOrgId.setDataType("varchar");
        createOrgId.setAttrLength(200);
        createOrgId.setIsPk("0");
        createOrgId.setIsRequired("0");
        createOrgId.setIsEncrypt("0");
        createOrgId.setDecimalLen(0);
        createOrgId.setFieldType("1");
        createOrgId.setIsDele("0");
        BizAppCatalogsTableField createTime = new BizAppCatalogsTableField();
        createTime.setFieldCode("CREATE_TIME_");
        createTime.setName("\u521b\u5efa\u65f6\u95f4");
        createTime.setCode("CREATE_TIME_");
        createTime.setDesc("\u521b\u5efa\u65f6\u95f4");
        createTime.setDataType("date");
        createTime.setAttrLength(0);
        createTime.setIsPk("0");
        createTime.setIsRequired("0");
        createTime.setIsEncrypt("0");
        createTime.setDecimalLen(0);
        createTime.setFieldType("1");
        createTime.setIsDele("0");
        BizAppCatalogsTableField id = new BizAppCatalogsTableField();
        id.setFieldCode("ID_");
        id.setName("\u4e3b\u952e");
        id.setCode("ID_");
        id.setDesc("\u4e3b\u952e");
        id.setDataType("varchar");
        id.setAttrLength(500);
        id.setIsPk("1");
        id.setIsRequired("0");
        id.setIsEncrypt("0");
        id.setDecimalLen(0);
        id.setFieldType("1");
        id.setIsDele("0");
        id.setSn(-1);
        Set set = fieldList.stream().map(entity -> entity.getCode()).collect(Collectors.toSet());
        if (!set.contains(createBy.getCode())) {
            fieldList.add(createBy);
        }
        if (!set.contains(createOrgId.getCode())) {
            fieldList.add(createOrgId);
        }
        if (!set.contains(createTime.getCode())) {
            fieldList.add(createTime);
        }
        if (!set.contains(id.getCode())) {
            fieldList.add(id);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateFields(List<BizAppCatalogsTableField> fields) throws Exception {
        if (fields.size() == 0) {
            throw new ApplicationException("\u6ca1\u6709\u4fee\u6539\u7684\u5b57\u6bb5");
        }
        String tableId = fields.get(0).getTableId();
        BizAppCatalogsTable table = (BizAppCatalogsTable)this.tableManager.get((Serializable)((Object)tableId));
        List disFieldList = fields.stream().map(p -> p.getFieldCode()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < fields.size()) {
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        String tableName = table.getTableNameEn();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"app");
        for (BizAppCatalogsTableField field : fields) {
            String fieldSq;
            field.setIsCreate("1");
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            field.setDecimalLen(decimalLen);
            field.setFieldCode(field.getCode());
            if (StringUtil.isEmpty((String)field.getId())) {
                if (field.getSn() == null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("TABLE_ID_", tableId);
                    field.setSn(this.getNextSequence(map));
                }
                field.setMouldCode(fields.get(0).getMouldCode());
                field.setMouldName(fields.get(0).getMouldName());
                String fieldSq2 = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
                field.setFlSql(fieldSq2);
                template.execute(fieldSq2);
                continue;
            }
            if (!this.fieldEquals(field)) continue;
            BizAppCatalogsTableField oldField = (BizAppCatalogsTableField)((Object)this.getById((Serializable)((Object)field.getId())));
            if (!field.getFieldCode().equals(oldField.getFieldCode())) {
                fieldSq = "ALTER TABLE `" + tableName + "` RENAME COLUMN `" + oldField.getFieldCode() + "` `" + field.getFieldCode() + "` ";
                template.execute(fieldSq);
            }
            if (field.getDesc().equals(oldField.getDesc())) continue;
            fieldSq = "ALTER TABLE `" + tableName + "` MODIFY COLUMN `" + field.getFieldCode() + "`  COMMENT " + field.getDesc() + " ";
            template.execute(fieldSq);
        }
        this.saveOrUpdateBatch(fields);
        String createSql = DorisUtils.createAppTable(template, table.getTableNameEn(), table.getTableDesc(), fields);
        table.setCreateTableSql(createSql);
        table.setFieldTotal(fields.size());
        this.tableManager.updateById((Object)table);
    }

    public boolean fieldEquals(BizAppCatalogsTableField field) {
        BizAppCatalogsTableField oldField = (BizAppCatalogsTableField)((Object)this.getById((Serializable)((Object)field.getId())));
        return !field.getFieldCode().equals(oldField.getFieldCode()) || !field.getDesc().equals(oldField.getDesc());
    }
}

