/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/dataShare/shareTable/v1/"})
@Api(tags={"\u6570\u636e\u5171\u4eab\u7ba1\u7406--\u5171\u4eab\u8d44\u6e90\u8868\u7ba1\u7406 \uff08\u5143\u6570\u636e\u4fe1\u606f+TABLE\u4fe1\u606f\uff09"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizShareTableController
extends BaseController<BizShareTableManager, BizShareTable> {
    @PostMapping(value={"deploy"})
    @ApiOperation(value="\u8d44\u6e90\u53d1\u5e03\u4e0a\u7ebf")
    public CommonResult<String> deploy(@RequestParam(value="id") String id) {
        boolean result = ((BizShareTableManager)this.baseService).deploy(id);
        return result ? CommonResult.success(null, (String)"\u53d1\u5e03\u6210\u529f\uff01") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@Validated(value={AddGroup.class}) @RequestBody BizShareTable table) {
        boolean result = ((BizShareTableManager)this.baseService).saveInfo(table);
        return result ? CommonResult.success(null, (String)"\u521b\u5efa\u6210\u529f\uff01") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8868\u8be6\u60c5")
    public PageList<BizShareTable> queryPage(@RequestBody QueryFilter<BizShareTable> queryFilter) {
        PageList<BizShareTable> pageList = ((BizShareTableManager)this.baseService).queryPage(queryFilter);
        return pageList;
    }

    @PostMapping(value={"/queryTableField"})
    @ApiOperation(value="\u67e5\u770b\u8868\u5b57\u6bb5")
    public CommonResult<BizShareTable> queryTableField(@RequestParam String id) {
        BizShareTable table = ((BizShareTableManager)this.baseService).queryTableField(id);
        return CommonResult.success((Object)((Object)table), (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/queryTableInfo"})
    @ApiOperation(value="\u67e5\u770b\u8868\u8be6\u60c5")
    public CommonResult<BizShareTable> queryTableInfo(@RequestParam String id) {
        BizShareTable table = ((BizShareTableManager)this.baseService).queryTableInfo(id);
        return CommonResult.success((Object)((Object)table), (String)"\u67e5\u8be2\u6210\u529f");
    }

    @PostMapping(value={"/queryAuthPage"})
    @ApiOperation(value="\u67e5\u8be2-\u672a\u7ed9-\u9700\u6c42\u65b9\u6388\u6743\u7684\u8d44\u6e90")
    public PageList<BizShareTable> queryAuthPage(@RequestBody QueryFilter<BizShareTable> queryFilter, @RequestParam(value="consumerId") String consumerId) {
        PageList<BizShareTable> pageList = ((BizShareTableManager)this.baseService).queryAuthPage(queryFilter, consumerId);
        return pageList;
    }

    @DeleteMapping(value={"/removeTable/{id}"})
    @ApiOperation(value="\u5220\u9664\u8868\u548c\u5b57\u6bb5-\u5982\u679c\u8868\u5df2\u7ecf\u521b\u5efa\u540c\u6b65\u5220\u9664\u5b9e\u4f53\u8868")
    public CommonResult<String> delete(@PathVariable(value="id") String id) throws Exception {
        boolean result = ((BizShareTableManager)this.baseService).removeTable(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/removeTableBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u548c\u5b57\u6bb5-\u5982\u679c\u8868\u5df2\u7ecf\u521b\u5efa\u540c\u6b65\u5220\u9664\u5b9e\u4f53\u8868")
    public CommonResult<String> removeBatch(@ApiParam(name="ids", value="\u5b9e\u4f53\u96c6\u5408") @RequestParam List<String> ids) throws Exception {
        boolean result = ((BizShareTableManager)this.baseService).removeBatch(ids);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/queryTableSql"})
    @ApiOperation(value="\u83b7\u53d6\u5efa\u8868sql")
    public CommonResult<String> queryTableSql(@RequestParam(value="id") String id) {
        String sql = ((BizShareTableManager)this.baseService).queryTableSql(id);
        return CommonResult.success((Object)sql, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"checkTableExists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<String> checkTableExists(@ApiParam(name="tableId", value="\u8868ID", required=false, defaultValue="") @RequestParam String tableId, @ApiParam(name="dbAlias", value="\u6570\u636e\u5e93\u522b\u540d") @RequestParam String dbAlias, @ApiParam(name="tableNameEn", value="\u8868\u82f1\u6587\u540d") @RequestParam String tableNameEn) throws Exception {
        boolean isExists = ((BizShareTableManager)this.baseService).checkTableExists(tableId, dbAlias, tableNameEn);
        if (isExists) {
            return new CommonResult(false, "\u8868" + tableNameEn + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u8868\u540d");
        }
        return new CommonResult(true, "\u53ef\u4ee5\u4f7f\u7528\u8868\u540d");
    }

    @PostMapping(value={"checkPhysicsTableExists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u7269\u7406\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<String> checkPhysicsTableExists(@ApiParam(name="tableId", value="\u8868ID") @RequestParam String tableId, @ApiParam(name="tableNameEn", value="\u8868\u82f1\u6587\u540d") @RequestParam String tableNameEn) throws Exception {
        boolean isExists = ((BizShareTableManager)this.baseService).checkPhysicsTableExists(tableId, tableNameEn);
        if (isExists) {
            return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f\uff0c\u53ef\u4ee5\u53d1\u5e03");
        }
        return new CommonResult(false, "\u8868" + tableNameEn + "\u4e0d\u5b58\u5728\uff01");
    }

    @RequestMapping(value={"deployHaveTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5df2\u6709\u8868\u53d1\u5e03", httpMethod="POST", notes="\u5df2\u6709\u8868\u53d1\u5e03")
    public CommonResult<String> deployHaveTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId) throws Exception {
        ((BizShareTableManager)this.baseService).deployHaveTable(tableId);
        return new CommonResult(true, "\u5df2\u6709\u8868\u53d1\u5e03\u6210\u529f");
    }

    @RequestMapping(value={"deployDotHaveTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u672a\u6709\u8868\u53d1\u5e03", httpMethod="POST", notes="\u672a\u6709\u8868\u53d1\u5e03")
    public CommonResult<String> deployDotHaveTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId, @ApiParam(name="tableSql", value="\u5efa\u8868\u8bed\u53e5") @RequestParam String tableSql) throws Exception {
        ((BizShareTableManager)this.baseService).deployDotHaveTable(tableId, tableSql);
        return new CommonResult(true, "\u672a\u6709\u8868\u53d1\u5e03\u6210\u529f");
    }

    @RequestMapping(value={"updateCatalog"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u8868\u8d44\u6e90\u76ee\u5f55", httpMethod="PUT", notes="\u4fee\u6539\u8868\u8d44\u6e90\u76ee\u5f55")
    public CommonResult<String> updateCatalog(@RequestParam String[] ids, @RequestParam String catalogId) {
        boolean result = ((BizShareTableManager)this.baseService).updateCatalog(ids, catalogId);
        if (result) {
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
        }
        return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25");
    }
}

