/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.dw.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.dataResource.dw.manager.BizDwTableManager;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTable;
import com.artfess.dataShare.dataResource.dw.vo.DwTableDetailVo;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.DorisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/biz/dataResource/dwTable/v1/"})
@Api(tags={"\u6570\u636e\u8d44\u4ea7--DW\u6570\u636e\u9879\u4fe1\u606f"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizDwTableController
extends BaseController<BizDwTableManager, BizDwdCatalogsTable> {
    @Resource
    BizDwTableManager tableManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizDwdCatalogsTable t) {
        boolean result;
        if (StringUtil.isEmpty((String)t.getId())) {
            t.setDeployed("0");
            t.setIsCreateTable("0");
            t.setIsDele("0");
            t.setTableNameEn("dw_" + t.getTableNameEn());
        }
        if (!(result = ((BizDwTableManager)this.baseService).save((Object)t))) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/importFile"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e\u8d44\u4ea7-DW\u6570\u636e\u9879", httpMethod="POST", notes="\u5bfc\u5165\u6570\u636e\u8d44\u4ea7-DW\u6570\u636e\u9879")
    public CommonResult export(@RequestParam(value="file", required=true) MultipartFile file, String catalogId) throws Exception {
        this.tableManager.export(file, catalogId);
        return new CommonResult("\u5bfc\u5165\u4e3b\u8868\u6210\u529f");
    }

    @RequestMapping(value={"downloadMainTempFile/{tableId}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadMainTempFile(HttpServletResponse response, @ApiParam(name="tableId", value="\u6a21\u677f\u522b\u540d", required=true) @PathVariable String tableId) throws Exception {
        ((BizDwTableManager)this.baseService).downloadMainTempFile(response, tableId);
    }

    @PostMapping(value={"importMain"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u4e3b\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u4e3b\u8868\u6570\u636e")
    public CommonResult<String> importMain(@ApiParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody MultipartFile file, @ApiParam(name="tableId", value="\u6570\u636e\u6a21\u677f\u5225\u540d") @RequestParam String tableId) throws Exception {
        ((BizDwTableManager)this.baseService).importMain(file, tableId);
        return new CommonResult("\u5bfc\u5165\u4e3b\u8868\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"/queryTableVo"})
    @ApiOperation(value="\u6839\u636e\u8868\u67e5\u8be2\u8868\u4fe1\u606f\u3001\u5b57\u6bb5\u4fe1\u606f\u3001\u6a21\u578b")
    public DwTableDetailVo queryTableVo(@RequestParam(value="tableId", required=true) String tableId) throws Exception {
        DwTableDetailVo vo = this.tableManager.queryTableVo(tableId);
        return vo;
    }

    @PostMapping(value={"/Deploy"})
    @ApiOperation(value="\u53d1\u5e03\u8868\u521b\u5efa\u5b9e\u4f53\u8868")
    public CommonResult Deploy(@RequestParam(value="tableId", required=true) String tableId) throws Exception {
        this.tableManager.Deploy(tableId);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/queryTableData"})
    @ApiOperation(value="\u7269\u7406\u8868 \u6570\u636e\u67e5\u8be2  \u5206\u9875\uff0c\u52a0\u641c\u7d22\u3001\u6392\u5e8f")
    public QueryResultData queryTableData(@RequestBody QueryParamVo queryParamVo) throws Exception {
        return this.tableManager.queryTableData(queryParamVo);
    }

    @PostMapping(value={"/removeTable"})
    @ApiOperation(value="\u5220\u9664\u8868\u548c\u5b57\u6bb5")
    public CommonResult queryTableData(@RequestParam String tableId) throws Exception {
        this.tableManager.removeTable(tableId);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/queryDTTableData"})
    @ApiOperation(value="\u52a8\u6001\u8868 \u6570\u636e\u67e5\u8be2")
    public QueryResultData queryDTTableData(@RequestBody QueryParamVo queryParamVo) throws Exception {
        return this.tableManager.queryDTTableData(queryParamVo);
    }

    @PostMapping(value={"/queryTableDetailData"})
    @ApiOperation(value="\u52a8\u6001\u8868 \u660e\u7ec6\u6570\u636e\u67e5\u8be2")
    public Map<String, Object> queryTableDetailData(String tableId, String pcId) throws Exception {
        return this.tableManager.queryTableDetailData(tableId, pcId);
    }

    @PostMapping(value={"/queryTableSql/{tableId}"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u7406\u8868\u8868\u5efa\u8868\u8bed\u53e5")
    public CommonResult<String> queryTableSql(@PathVariable String tableId) throws Exception {
        DwTableDetailVo vo = this.tableManager.queryTableVo(tableId);
        if (StringUtils.isNotBlank((CharSequence)vo.getTable().getCreateTableSql())) {
            return CommonResult.success((Object)vo.getTable().getCreateTableSql(), (String)"\u83b7\u53d6\u6210\u529f");
        }
        String tableDesc = vo.getTable().getTableDesc() == null ? vo.getTable().getTableNameCh() : vo.getTable().getTableDesc();
        String sql = DorisUtils.getDWDWLTableSql(vo.getTable().getTableNameEn(), tableDesc, vo.getFieldList());
        return CommonResult.success((Object)sql, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/queryDtTableSql/{tableId}"})
    @ApiOperation(value="\u83b7\u53d6\u52a8\u6001\u8868\u8868\u5efa\u8868\u8bed\u53e5")
    public CommonResult<Map<String, String>> queryDtTableSql(@PathVariable String tableId) throws Exception {
        Map<String, String> result = ((BizDwTableManager)this.baseService).queryDwTable(tableId);
        return CommonResult.success(result, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"checkTableExists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<String> checkTableExists(@ApiParam(name="tableNameEn", value="\u8868\u82f1\u6587\u540d") @RequestParam String tableNameEn, @ApiParam(name="type", value="\u53d1\u5e03\u7c7b\u578b(0:\u672a\u6709\u8868\u53d1\u5e03\uff0c1:\u5df2\u6709\u8868\u53d1\u5e03)") @RequestParam(required=false) String type) throws Exception {
        boolean isExists = this.tableManager.checkTableExists(tableNameEn);
        if ("1".equals(type)) {
            if (isExists) {
                return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f\uff0c\u53ef\u4ee5\u53d1\u5e03");
            }
            return new CommonResult(false, "\u8868" + tableNameEn + "\u4e0d\u5b58\u5728\uff01");
        }
        if (isExists) {
            return new CommonResult(false, "\u8868" + tableNameEn + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u8868\u540d");
        }
        return new CommonResult(true, "\u53ef\u4ee5\u4f7f\u7528\u8868\u540d");
    }

    @PostMapping(value={"checkPhysicsTableExists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u7269\u7406\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<String> checkPhysicsTableExists(@ApiParam(name="tableNameEn", value="\u8868\u82f1\u6587\u540d") @RequestParam String tableNameEn, @ApiParam(name="type", value="\u53d1\u5e03\u7c7b\u578b(0:\u672a\u6709\u8868\u53d1\u5e03\uff0c1:\u5df2\u6709\u8868\u53d1\u5e03)") @RequestParam(required=false) String type) throws Exception {
        boolean isExists = this.tableManager.checkPhysicsTableExists(tableNameEn);
        if ("1".equals(type)) {
            if (isExists) {
                return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f\uff0c\u53ef\u4ee5\u53d1\u5e03");
            }
            return new CommonResult(false, "\u8868" + tableNameEn + "\u4e0d\u5b58\u5728\uff01");
        }
        if (isExists) {
            return new CommonResult(false, "\u8868" + tableNameEn + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u8868\u540d");
        }
        return new CommonResult(true, "\u53ef\u4ee5\u4f7f\u7528\u8868\u540d");
    }

    @PostMapping(value={"saveTableSql"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5efa\u8868SQL", httpMethod="POST", notes="\u4fdd\u5b58\u5efa\u8868SQL")
    public CommonResult<String> saveTableSql(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId, @ApiParam(name="tableSql", value="\u5efa\u8868\u8bed\u53e5") @RequestParam String tableSql) throws Exception {
        BizDwdCatalogsTable table = (BizDwdCatalogsTable)((Object)this.tableManager.getById((Serializable)((Object)tableId)));
        table.setCreateTableSql(tableSql);
        this.tableManager.updateById((Object)table);
        return new CommonResult(true, "\u4fdd\u5b58\u5efa\u8868SQL\u6210\u529f");
    }

    @RequestMapping(value={"deployHaveTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5df2\u6709\u8868\u53d1\u5e03", httpMethod="POST", notes="\u5df2\u6709\u8868\u53d1\u5e03")
    public CommonResult<String> deployHaveTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId) throws Exception {
        this.tableManager.deployHaveTable(tableId);
        return new CommonResult(true, "\u5df2\u6709\u8868\u53d1\u5e03\u6210\u529f");
    }

    @RequestMapping(value={"deployDotHaveTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u672a\u6709\u8868\u53d1\u5e03", httpMethod="POST", notes="\u672a\u6709\u8868\u53d1\u5e03-\u7269\u7406\u8868")
    public CommonResult<String> deployDotHaveTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId, @ApiParam(name="tableSql", value="\u4e3b\u8868\u5efa\u8868\u8bed\u53e5") @RequestParam String tableSql, @ApiParam(name="detailTableSql", value="\u660e\u7ec6\u8868\u5efa\u8868\u8bed\u53e5", required=false) @RequestParam String detailTableSql) throws Exception {
        this.tableManager.deployDotHaveTable(tableId, tableSql, detailTableSql);
        return new CommonResult(true, "\u672a\u6709\u8868\u53d1\u5e03");
    }

    @RequestMapping(value={"updateCatalog"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u8868\u8d44\u6e90\u76ee\u5f55", httpMethod="PUT", notes="\u4fee\u6539\u8868\u8d44\u6e90\u76ee\u5f55")
    public CommonResult<String> updateCatalog(@RequestParam String[] ids, @RequestParam String catalogId) {
        boolean result = this.tableManager.updateCatalog(ids, catalogId);
        if (result) {
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
        }
        return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25");
    }
}

