/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.ext.listener;

import com.artfess.activiti.ext.factory.BpmDelegateFactory;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.model.HtJsonNodeFactory;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.ScriptType;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.plugin.core.cmd.ExecutionCommand;
import com.artfess.bpm.api.plugin.core.cmd.TaskCommand;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.exception.BusinessException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskListener
implements TaskListener {
    private static final long serialVersionUID = -296298349312307694L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;
    private List<TaskCommand> taskCommands;
    private List<ExecutionCommand> executionCommands;

    public abstract EventType getBeforeTriggerEventType();

    public abstract EventType getAfterTriggerEventType();

    public abstract void beforePluginExecute(BpmDelegateTask var1) throws Exception;

    public abstract void triggerExecute(BpmDelegateTask var1);

    public abstract void afterPluginExecute(BpmDelegateTask var1);

    public void notify(DelegateTask delegateTask) {
        BpmDelegateTask task = BpmDelegateFactory.getBpmDelegateTask(delegateTask);
        try {
            this.beforePluginExecute(task);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        if (this.taskCommands != null && this.getBeforeTriggerEventType() != null) {
            for (TaskCommand taskCommand : this.taskCommands) {
                try {
                    taskCommand.execute(this.getBeforeTriggerEventType(), task);
                }
                catch (Exception e) {
                    throw new BaseException(ExceptionUtil.getExceptionMessage((Throwable)e));
                }
            }
        }
        if (this.executionCommands != null && this.getBeforeTriggerEventType() != null) {
            ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
            taskCmd.getVariables().put("restful_task", task);
            for (ExecutionCommand cmd : this.executionCommands) {
                BpmDelegateExecution exection = BpmDelegateFactory.getBpmDelegateExecution(delegateTask.getExecution());
                if (!BeanUtils.isNotEmpty((Object)exection)) continue;
                try {
                    cmd.execute(this.getBeforeTriggerEventType(), BpmDelegateFactory.getBpmDelegateExecution(delegateTask.getExecution()));
                }
                catch (Exception e) {
                    throw new BaseException(ExceptionUtil.getExceptionMessage((Throwable)e));
                }
            }
        }
        this.triggerExecute(task);
        if (this.taskCommands != null && this.getAfterTriggerEventType() != null) {
            for (TaskCommand taskCommand : this.taskCommands) {
                try {
                    taskCommand.execute(this.getAfterTriggerEventType(), task);
                }
                catch (Exception e) {
                    throw new BaseException(ExceptionUtil.getExceptionMessage((Throwable)e));
                }
            }
        }
        this.afterPluginExecute(task);
        try {
            this.exeEventScript(task);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    protected abstract ScriptType getScriptType();

    private void exeEventScript(BpmDelegateTask delegateTask) throws Exception {
        String bpmnDefId = delegateTask.getBpmnDefId();
        String defId = this.bpmDefinitionService.getDefIdByBpmnDefId(bpmnDefId);
        String nodeId = delegateTask.getTaskDefinitionKey();
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        ScriptType scriptType = this.getScriptType();
        String script = (String)nodeDef.getScripts().get(scriptType);
        if (StringUtil.isEmpty((String)script)) {
            return;
        }
        Map vars = delegateTask.getVariables();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Map boMap = BpmContextUtil.getBoFromContext();
        if (BeanUtils.isEmpty((Object)boMap)) {
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(delegateTask.getProcessInstanceId());
            List boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext((List)boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty((Object)boMap)) {
            HashMap newMap = new HashMap();
            for (Map.Entry next : boMap.entrySet()) {
                newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)next.getValue()));
            }
            vars.putAll(newMap);
        }
        vars.put("nodeDef", nodeDef);
        vars.put("task", delegateTask);
        vars.put("cmd", cmd);
        try {
            this.groovyScriptEngine.execute(script, vars);
        }
        catch (BusinessException e) {
            throw new WorkFlowException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("\u6d41\u7a0b\u811a\u672c\u5f02\u5e38\uff1a", (Throwable)e);
            StringBuffer sb = new StringBuffer();
            sb.append("<br/><br/>\u6d41\u7a0b\u5728\u8282\u70b9\uff1a" + nodeDef.getName() + "(" + nodeDef.getNodeId() + ")\u6267\u884c" + scriptType.getValue() + "\u65f6\u51fa\u73b0\u5f02\u5e38\u60c5\u51b5\uff01");
            sb.append("<br/>\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            sb.append("<br/>\u53ef\u80fd\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
            sb.append("<br/>\u6267\u884c\u811a\u672c\u4e3a\uff1a" + script);
            sb.append("\u811a\u672c\u53d8\u91cf\uff1a" + vars.toString());
            String errorMsg = "\u6d41\u7a0b\u5728\u8282\u70b9\u3010" + nodeDef.getName() + "(" + nodeDef.getNodeId() + ")\u3011\u6267\u884c" + scriptType.getValue() + "\u65f6\u51fa\u73b0\u5f02\u5e38\u60c5\u51b5\uff01\u53ef\u80fd\u539f\u56e0\u4e3a\uff1a" + e.getMessage();
            ThreadMsgUtil.addMapMsg((String)"msg_flow_error", (String)errorMsg);
            throw new WorkFlowException(sb.toString(), (Throwable)new RuntimeException(errorMsg));
        }
    }

    public List<TaskCommand> getTaskCommands() {
        return this.taskCommands;
    }

    public void setTaskCommands(List<TaskCommand> taskCommands) {
        this.taskCommands = taskCommands;
    }

    public List<ExecutionCommand> getExecutionCommands() {
        return this.executionCommands;
    }

    public void setExecutionCommands(List<ExecutionCommand> executionCommands) {
        this.executionCommands = executionCommands;
    }
}

