/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.filter;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CsrfFilter.class);
    FilterConfig filterConfig = null;
    private boolean enable;
    private List<String> excludes;

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (!this.enable || this.isExcludeUrl(request.getServletPath())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String referer = request.getHeader("Referer");
        String serverName = request.getServerName();
        if (null != referer && referer.indexOf(serverName) < 0) {
            log.error("CSRF\u8fc7\u6ee4\u5668 => \u670d\u52a1\u5668\uff1a{} => \u5f53\u524d\u57df\u540d\uff1a{}", (Object)serverName, (Object)referer);
            servletResponse.setContentType("text/html; charset=utf-8");
            servletResponse.getWriter().write("\u7cfb\u7edf\u4e0d\u652f\u6301\u5f53\u524d\u57df\u540d\u7684\u8bbf\u95ee\uff01");
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private boolean isExcludeUrl(String url) {
        if (this.excludes == null || this.excludes.isEmpty()) {
            return false;
        }
        return this.excludes.stream().map(pattern -> Pattern.compile("^" + pattern)).map(p -> p.matcher(url)).anyMatch(Matcher::find);
    }
}

