/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.SystemException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.constant.InterPoseType;
import com.artfess.bpm.api.constant.MultiInstanceType;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.NoExecutorModel;
import com.artfess.bpm.api.event.NotifyTaskModel;
import com.artfess.bpm.api.event.PushStackEvent;
import com.artfess.bpm.api.event.TaskNotifyEvent;
import com.artfess.bpm.api.helper.identity.BpmIdentityConverter;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.CustomSignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmAgentService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmFormService;
import com.artfess.bpm.api.service.BpmIdentityService;
import com.artfess.bpm.api.service.BpmTaskActionService;
import com.artfess.bpm.engine.form.BpmFormFactory;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.helper.identity.DefaultBpmIdentityConverter;
import com.artfess.bpm.model.form.FormModel;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.dao.BpmTaskDao;
import com.artfess.bpm.persistence.manager.ActExecutionManager;
import com.artfess.bpm.persistence.manager.ActTaskManager;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmCustomSignDataManager;
import com.artfess.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmInterposeRecoredManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmReadRecordManager;
import com.artfess.bpm.persistence.manager.BpmSecretaryManageManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskTurnManager;
import com.artfess.bpm.persistence.manager.TaskTurnAssignManager;
import com.artfess.bpm.persistence.model.ActTask;
import com.artfess.bpm.persistence.model.BpmCustomSignData;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.persistence.model.BpmInterposeRecored;
import com.artfess.bpm.persistence.model.BpmReadRecord;
import com.artfess.bpm.persistence.model.BpmSignData;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.artfess.bpm.persistence.model.DefaultBpmTaskTurn;
import com.artfess.bpm.persistence.model.PushStackModel;
import com.artfess.bpm.persistence.model.ResultMessage;
import com.artfess.bpm.persistence.model.TaskTurnAssign;
import com.artfess.bpm.persistence.util.BpmUtil;
import com.artfess.bpm.util.BoDataUtil;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.bpm.util.PortalDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="bpmTaskManager")
public class BpmTaskManagerImpl
extends BaseManagerImpl<BpmTaskDao, DefaultBpmTask>
implements BpmTaskManager {
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    IUserGroupService defaultUserGroupService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    ActTaskManager actTaskManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmAgentService bpmAgentService;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmIdentityService bpmIdentityService;
    @Resource
    NatTaskService natTaskService;
    @Resource
    ActExecutionManager actExecutionManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    BpmSecretaryManageManager bpmSecretaryManageManager;
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    DefaultBpmIdentityConverter defaultBpmIdentityConverter;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmReadRecordManager bpmReadRecordManager;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BoDataService boDataService;
    @Resource
    TaskTurnAssignManager taskTurnAssignManager;
    private Map<String, Object> actRightMap;

    @Override
    @Transactional
    public CommonResult<String> retrieveBpmTask(IUser user, String taskId) {
        DefaultBpmTaskTurn bpmTaskTurn = (DefaultBpmTaskTurn)this.bpmTaskTurnManager.getByTaskId(taskId);
        if (BeanUtils.isNotEmpty((Object)bpmTaskTurn)) {
            List<BpmReadRecord> bpmReadRecord;
            if ("finish".equals(bpmTaskTurn.getStatus())) {
                return new CommonResult(false, "\u6536\u56de\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u5904\u7406");
            }
            boolean hasTask = false;
            List<TaskTurnAssign> turnAssigns = this.bpmTaskTurnManager.getTurnAssignByTaskTurnId(bpmTaskTurn.getId());
            for (TaskTurnAssign taskTurnAssign : turnAssigns) {
                if (!user.getUserId().equals(taskTurnAssign.getFromUserId())) continue;
                hasTask = true;
            }
            if (!hasTask) {
                return new CommonResult(false, "\u8f6c\u529e\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u88ab\u5176\u4ed6\u4eba\u6536\u56de");
            }
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)super.get((Serializable)((Object)taskId));
            String defId = defaultBpmTask.getProcDefId();
            DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
            String isReadRevoke = def.getIsReadRevoke();
            if ("false".equals(isReadRevoke) && BeanUtils.isNotEmpty(bpmReadRecord = this.bpmReadRecordManager.getByTaskIdandrecord(taskId, bpmTaskTurn.getAssigneeId()))) {
                return new CommonResult(false, "\u5f53\u524d\u6d41\u7a0b\u4e0d\u5141\u8bb8\u5df2\u9605\u64a4\u56de");
            }
            bpmTaskTurn.setAssigneeId(user.getUserId());
            bpmTaskTurn.setAssigneeName(user.getFullname());
            this.bpmTaskTurnManager.update((Model)bpmTaskTurn);
            DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskIdStatus(taskId, OpinionStatus.AWAITING_CHECK.getKey());
            checkOpinion.setId(UniqueIdUtil.getSuid());
            checkOpinion.setStatus(OpinionStatus.DELIVERTO_CANCEL.getKey());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            checkOpinion.setAuditor(user.getUserId());
            checkOpinion.setAuditorName(user.getFullname());
            checkOpinion.setQualfiedNames(user.getFullname());
            checkOpinion.setOpinion("\u53d6\u6d88\u8f6c\u529e");
            checkOpinion.setFiles("");
            checkOpinion.setFormData("");
            this.bpmCheckOpinionManager.create((Model)checkOpinion);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("assigneeId", user.getUserId());
            map.put("assigneeName", user.getFullname());
            map.put("taskId", taskId);
            this.deleteTurnAssignsByFormUserUId(turnAssigns, AuthenticationUtil.getCurrentUserId());
            ((BpmTaskDao)this.baseMapper).retrieveBpmTask(map);
            this.bpmCheckOpinionManager.retrieveBpmTask(map);
            if (BeanUtils.isEmpty(turnAssigns)) {
                this.bpmTaskTurnManager.remove((Serializable)((Object)bpmTaskTurn.getId()));
            }
            return new CommonResult(true, "\u6536\u56de\u6210\u529f");
        }
        return new CommonResult(false, "\u8f6c\u529e\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u88ab\u5176\u4ed6\u4eba\u6536\u56de");
    }

    private void deleteTurnAssignsByFormUserUId(List<TaskTurnAssign> turnAssigns, String formUserUId) {
        if (BeanUtils.isEmpty(turnAssigns) || StringUtil.isEmpty((String)formUserUId)) {
            return;
        }
        Iterator<TaskTurnAssign> iterator = turnAssigns.iterator();
        while (iterator.hasNext()) {
            TaskTurnAssign taskTurnAssign = iterator.next();
            if (!formUserUId.equals(taskTurnAssign.getFromUserId())) continue;
            formUserUId = taskTurnAssign.getReceiverId();
            this.taskTurnAssignManager.remove((Serializable)((Object)taskTurnAssign.getId()));
            iterator.remove();
            this.deleteTurnAssignsByFormUserUId(turnAssigns, formUserUId);
            return;
        }
    }

    @Override
    public DefaultBpmTask getByRelateTaskId(String relateTaskId) {
        return ((BpmTaskDao)this.baseMapper).getByRelateTaskId(relateTaskId);
    }

    @Override
    @Transactional
    public void delByRelateTaskId(String relateTaskId) {
        this.bpmTaskCandidateManager.removeByTaskId(relateTaskId);
        ((BpmTaskDao)this.baseMapper).removeByTaskId(relateTaskId);
    }

    @Override
    public PageList<DefaultBpmTask> getByUserId(String userId) {
        PageBean pageBean = new PageBean();
        pageBean.setShowTotal(false);
        IPage<DefaultBpmTask> result = ((BpmTaskDao)this.baseMapper).getByUserId((IPage<DefaultBpmTask>)this.convert2IPage(pageBean), this.convertGroupList(userId), (Wrapper<DefaultBpmTask>)this.convert2Wrapper(QueryFilter.build(), this.currentModelClass()));
        List<Map<String, Object>> countByUserId = this.getCountByUserId(userId);
        result.setTotal(this.getTotalCount(countByUserId));
        return new PageList(result);
    }

    private Map<String, String> convertGroupList(String userId) {
        List list = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", "'" + userId + "'");
        if (BeanUtils.isEmpty((Object)list)) {
            return map;
        }
        for (IGroup group : list) {
            String type = group.getGroupType();
            if (map.containsKey(type)) {
                String groupId = (String)map.get(type);
                groupId = groupId + ",'" + group.getGroupId() + "'";
                map.put(type, groupId);
                continue;
            }
            map.put(type, "'" + group.getGroupId() + "'");
        }
        return map;
    }

    @Override
    public PageList<DefaultBpmTask> getByUserId(String userId, QueryFilter<DefaultBpmTask> queryFilter) {
        Class currentModelClass = this.currentModelClass();
        Wrapper convert2Wrapper = this.convert2Wrapper(queryFilter, currentModelClass);
        PageBean pageBean = queryFilter.getPageBean();
        if (BeanUtils.isEmpty((Object)pageBean)) {
            pageBean = new PageBean(Integer.valueOf(1));
        }
        pageBean.setShowTotal(false);
        Map<String, String> map = this.convertGroupList(userId);
        IPage<DefaultBpmTask> list = null;
        String keyWord = null;
        Integer supportMobile = null;
        for (QueryField query : queryFilter.getQuerys()) {
            if ("LIKE".equals(query.getOperation().name().toUpperCase())) {
                keyWord = query.getValue().toString();
                continue;
            }
            if (!"EQUAL".equals(query.getOperation().name().toUpperCase()) || !query.getProperty().toUpperCase().contains("SUPPORT_MOBILE_")) continue;
            supportMobile = (Integer)query.getValue();
        }
        if (StringUtil.isNotEmpty(keyWord)) {
            map.put("keyWord", "%" + keyWord + "%");
        }
        if (BeanUtils.isNotEmpty(supportMobile)) {
            map.put("supportMobile", String.valueOf(supportMobile));
        }
        list = ((BpmTaskDao)this.baseMapper).getByUserId((IPage<DefaultBpmTask>)this.convert2IPage(pageBean), map, (Wrapper<DefaultBpmTask>)convert2Wrapper);
        queryFilter.setSorter(new ArrayList());
        Wrapper countWrapper = this.convert2Wrapper(queryFilter, currentModelClass);
        Long total = null;
        total = ((BpmTaskDao)this.baseMapper).getCountByUserIdWithWhere(map, (Wrapper<DefaultBpmTask>)countWrapper);
        list.setTotal(total.longValue());
        return new PageList(list);
    }

    @Override
    public PageList<DefaultBpmTask> getLeaderByUserId(String userId, QueryFilter queryFilter) {
        Map<String, Object> leadersRigths = this.bpmSecretaryManageManager.getLeadersRigthMapBySecretaryId(userId, "2", false);
        Map<String, Object> groupMap = new HashMap<String, Map<String, Object>>();
        if (BeanUtils.isNotEmpty((Object)queryFilter) && queryFilter.getParams() != null) {
            groupMap = queryFilter.getParams();
        }
        groupMap.put("rightMap", leadersRigths);
        groupMap.put("userId", ContextUtil.getCurrentUserId());
        queryFilter.setParams(new HashMap());
        UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        ArrayNode users = ucFeignService.getUserByIdsOrAccounts(StringUtil.join(new ArrayList<String>(leadersRigths.keySet()), (String)","));
        if (BeanUtils.isEmpty((Object)users) || users.isEmpty()) {
            throw new BaseException("\u65e0\u79d8\u4e66\u5ba1\u6279\u6743\u9650\uff01");
        }
        Wrapper convert2Wrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        IPage<DefaultBpmTask> list = ((BpmTaskDao)this.baseMapper).getLeaderByUserId((IPage<DefaultBpmTask>)this.convert2IPage(queryFilter.getPageBean()), groupMap, (Wrapper<DefaultBpmTask>)convert2Wrapper);
        if (BeanUtils.isEmpty(list)) {
            return new PageList();
        }
        HashMap<String, String> userNameMap = new HashMap<String, String>();
        for (JsonNode jsonNode : users) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            userNameMap.put(objectNode.get("id").asText(), objectNode.get("fullname").asText());
        }
        for (DefaultBpmTask task : list.getRecords()) {
            String[] ids;
            HashSet<String> idSet;
            if (!StringUtil.isNotEmpty((String)task.getLeaderIds()) || userId.equals(task.getLeaderIds()) || (idSet = new HashSet<String>(Arrays.asList(ids = task.getLeaderIds().split(",")))).contains(userId)) continue;
            ArrayList<BpmIdentity> lIdentities = new ArrayList<BpmIdentity>();
            for (String id : ids) {
                lIdentities.add(new DefaultBpmIdentity(id, (String)userNameMap.get(id), "user"));
            }
            if (TaskType.BACK.getKey().equals(task.getStatus())) {
                task.setStatus(TaskType.BACKSHARE.getKey());
            } else {
                task.setStatus(TaskType.SHARE.getKey());
            }
            task.setIdentityList(lIdentities);
        }
        return new PageList(list);
    }

    @Override
    public List<Map<String, Object>> getCountByUserId(String userId) {
        Map<String, String> map = this.convertGroupList(userId);
        return ((BpmTaskDao)this.baseMapper).getCountByUserId(map);
    }

    @Override
    public List<Map<String, Object>> getLeaderCountByUserId(String userId) {
        Map<String, Object> leadersRigths = this.bpmSecretaryManageManager.getLeadersRigthMapBySecretaryId(userId, "2", false);
        HashMap<String, Object> groupMap = new HashMap<String, Object>();
        groupMap.put("rightMap", leadersRigths);
        String dbType = SQLUtil.getDbType();
        List<Map<String, Object>> leaderTaskCount = null;
        if (dbType.equals("postgresql")) {
            groupMap.put("userId", userId);
            leaderTaskCount = ((BpmTaskDao)this.baseMapper).getLeaderTaskCount(groupMap);
        } else {
            leaderTaskCount = ((BpmTaskDao)this.baseMapper).getLeaderCountByUserId(groupMap);
        }
        return leaderTaskCount;
    }

    @Override
    public Long getTodoCountByUserIdOverdue(String userId) {
        Map<String, String> map = this.convertGroupList(userId);
        return ((BpmTaskDao)this.baseMapper).getTodoCountByUserIdOverdue(map);
    }

    @Override
    public Long getTodoCountByUserIdTimeOut(String userId) {
        Map<String, String> map = this.convertGroupList(userId);
        return ((BpmTaskDao)this.baseMapper).getTodoCountByUserIdTimeOut(map);
    }

    @Override
    public Long getTodoCountByUserId(String userId, String isMobile) {
        Map<String, String> map = this.convertGroupList(userId);
        map.put("isMobile", isMobile);
        return ((BpmTaskDao)this.baseMapper).getTodoCountByUserId(map);
    }

    private long getTotalCount(List<Map<String, Object>> list) {
        long total = 0L;
        for (Map<String, Object> map : list) {
            Object count = map.get("count");
            if (count == null || !(count instanceof Long)) continue;
            total += ((Long)count).longValue();
        }
        return total;
    }

    @Override
    public PageList<DefaultBpmTask> getByUserId(String userId, PageBean pageBean) {
        pageBean.setShowTotal(false);
        PageList pageList = new PageList(((BpmTaskDao)this.baseMapper).getByUserId((IPage<DefaultBpmTask>)this.convert2IPage(pageBean), this.convertGroupList(userId), null));
        List<Map<String, Object>> countByUserId = this.getCountByUserId(userId);
        pageList.setTotal(this.getTotalCount(countByUserId));
        return pageList;
    }

    @Override
    public List<DefaultBpmTask> getAllByUserId(String userId, QueryFilter<DefaultBpmTask> queryFilter) {
        Class currentModelClass = this.currentModelClass();
        Wrapper convert2Wrapper = this.convert2Wrapper(queryFilter, currentModelClass);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setShowTotal(false);
        Map<String, String> map = this.convertGroupList(userId);
        IPage<DefaultBpmTask> list = ((BpmTaskDao)this.baseMapper).getByUserId((IPage<DefaultBpmTask>)this.convert2IPage(pageBean), map, (Wrapper<DefaultBpmTask>)convert2Wrapper);
        return list.getRecords();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    private void updateExtraPropData(DefaultBpmTask bpmTask, ActionCmd cmd) {
        try {
            if (StringUtil.isEmpty((String)cmd.getBusData())) {
                return;
            }
            BpmFormService bpmFormService = BpmFormFactory.getFormService(FormType.PC);
            FormModel formModel = bpmFormService.getByDefId(bpmTask.getProcDefId(), bpmTask.getNodeId(), (BpmProcessInstance)cmd.getTransitVars("processInstance"), true);
            if (BeanUtils.isEmpty((Object)formModel) || StringUtil.isEmpty((String)formModel.getFormExtraConf())) {
                return;
            }
            boolean isUpdatePropValue = false;
            ObjectNode busData = (ObjectNode)JsonUtil.toJsonNode((String)cmd.getBusData());
            ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)formModel.getFormExtraConf());
            Iterator iterator = objectNode.fields();
            while (iterator.hasNext()) {
                int subIndex;
                String[] split;
                Map.Entry node = (Map.Entry)iterator.next();
                ObjectNode conf = (ObjectNode)node.getValue();
                String extraValue = "";
                if (BeanUtils.isEmpty((Object)conf) || !conf.hasNonNull("field") || (split = conf.get("field").asText().split("\\.")).length < 2) continue;
                String bodefCode = split[0];
                String attrName = split[1];
                String subFiledName = split.length == 3 ? split[2] : "";
                int n = subIndex = conf.hasNonNull("subIndex") ? conf.get("subIndex").asInt() : 1;
                if (!busData.hasNonNull(bodefCode) || !busData.get(bodefCode).hasNonNull(attrName)) continue;
                ObjectNode entData = (ObjectNode)busData.get(bodefCode);
                if (StringUtil.isEmpty((String)subFiledName)) {
                    extraValue = entData.get(attrName).asText();
                } else {
                    ObjectNode subData;
                    ArrayNode subDatas = (ArrayNode)entData.get(attrName);
                    if (BeanUtils.isNotEmpty((Object)subDatas) && subDatas.size() >= subIndex && (subData = (ObjectNode)subDatas.get(subIndex - 1)).hasNonNull(subFiledName)) {
                        extraValue = subData.get(subFiledName).asText();
                    }
                }
                if (!StringUtil.isNotEmpty((String)extraValue)) continue;
                isUpdatePropValue = true;
                this.setExtarPropValua(bpmTask, (String)node.getKey(), extraValue);
            }
            if (!isUpdatePropValue) return;
        }
        catch (Exception e) {
            throw new SystemException("\u66f4\u65b0\u5f85\u529e\u4e1a\u52a1\u6269\u5c55\u5b57\u6bb5\u5931\u8d25:" + e.getMessage());
        }
    }

    @Override
    @Transactional
    public void assignUser(BpmDelegateTask delegateTask, List<BpmIdentity> identityList) throws Exception {
        DefaultBpmTask bpmTask = this.getByRelateTaskId(delegateTask.getId());
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (cmd.getTransitVars("IsDoneUnused") != null) {
            cmd.addTransitVars("create_bpm_task", bpmTask);
        }
        this.updateExtraPropData(bpmTask, cmd);
        bpmTask.setIdentityEmpty(BeanUtils.isEmpty(identityList));
        if (BeanUtils.isEmpty(identityList)) {
            ContextThreadUtil.addTask(bpmTask);
            NoExecutorModel noExcutor = NoExecutorModel.getNoExecutorModel(bpmTask.getTaskId(), bpmTask.getBpmnInstId(), bpmTask.getSubject(), bpmTask.getNodeId(), bpmTask.getName(), bpmTask.getBpmnDefId());
            BpmUtil.publishNoExecutorEvent(noExcutor);
            return;
        }
        bpmTask.setIdentityList(identityList);
        Map<String, Object> vars = delegateTask.getVariables();
        ActionType actionType = ActionType.APPROVE;
        String actionName = "start";
        String opinion = "";
        if (cmd instanceof DefaultTaskFinishCmd) {
            DefaultTaskFinishCmd finishCmd = (DefaultTaskFinishCmd)cmd;
            actionType = finishCmd.getActionType();
            actionName = finishCmd.getActionName();
            opinion = finishCmd.getApprovalOpinion();
        }
        List<IUser> userList = this.bpmIdentityExtractService.extractUser(identityList);
        NotifyTaskModel model = NotifyTaskModel.getNotifyModel(bpmTask.getTaskId(), bpmTask.getBpmnInstId(), bpmTask.getProcInstId(), bpmTask.getSubject(), bpmTask.getNodeId(), bpmTask.getName(), bpmTask.getBpmnDefId(), vars, userList, actionType, actionName, opinion);
        if (identityList.size() == 1) {
            BpmIdentity identity = identityList.get(0);
            if ("user".equals(identity.getType())) {
                this.handTask(bpmTask, delegateTask, vars, model);
            } else {
                this.bpmTaskCandidateManager.addCandidate(bpmTask, identityList);
            }
        } else {
            this.bpmTaskCandidateManager.addCandidate(bpmTask, identityList);
        }
        ContextThreadUtil.addTask(bpmTask);
        this.publishIdentityListWhenEmpty(bpmTask, identityList, userList);
        BpmUtil.setTaskSkip(bpmTask);
        if (!ActionType.RECOVER.equals((Object)actionType) && !bpmTask.getSkipResult().isSkipTask()) {
            this.publishNotifyEvent(model);
        }
        if (StringUtil.isNotEmpty((String)bpmTask.getAssigneeId()) && ContextUtil.getCurrentUserId().equals(bpmTask.getAssigneeId()) || "0".equals(bpmTask.getAssigneeId())) {
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            actionCmd.addTransitVars("revokeTaskId", bpmTask.getId());
        }
    }

    private void setExtarPropValua(DefaultBpmTask bpmTask, String prop, String value) {
        switch (prop) {
            case "prop1": {
                bpmTask.setProp1(value);
                break;
            }
            case "prop2": {
                bpmTask.setProp2(value);
                break;
            }
            case "prop3": {
                bpmTask.setProp3(value);
                break;
            }
            case "prop4": {
                bpmTask.setProp4(value);
                break;
            }
            case "prop5": {
                bpmTask.setProp5(value);
                break;
            }
            case "prop6": {
                bpmTask.setProp6(value);
                break;
            }
        }
    }

    private void publishNotifyEvent(NotifyTaskModel model) {
        if (model.getActionType() == ActionType.RECOVER) {
            return;
        }
        TaskNotifyEvent ev = new TaskNotifyEvent(model);
        AppUtil.publishEvent((ApplicationEvent)ev);
    }

    @Transactional
    private void handTask(DefaultBpmTask bpmTask, BpmDelegateTask delegateTask, Map<String, Object> vars, NotifyTaskModel model) throws Exception {
        BpmSignData signData;
        BpmIdentity identity = bpmTask.getIdentityList().get(0);
        IUser agent = this.getAgent(identity, delegateTask, vars);
        if (agent == null) {
            bpmTask.setAssigneeId(identity.getId());
            bpmTask.setAssigneeName(identity.getName());
            delegateTask.setAssignee(identity.getId());
        } else {
            IUser delegator = this.userServiceImpl.getUserById(identity.getId());
            bpmTask.setAssigneeId(agent.getUserId());
            bpmTask.setAssigneeName(agent.getFullname());
            bpmTask.setStatus(TaskType.AGENT.name());
            delegateTask.setAssignee(agent.getUserId());
            this.bpmTaskTurnManager.add(bpmTask, delegator, agent, "\u4ee3\u7406\u4efb\u52a1\u9ed8\u8ba4\u8f6c\u529e", "agent");
            model.setAgent(true);
            model.setAgent(agent);
            model.setDelegator(delegator);
            DefaultBpmCheckOpinion byTaskId = this.bpmCheckOpinionManager.getByTaskId(bpmTask.getId());
            byTaskId.setCompleteTime(TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)0, (int)2, (long)TimeUtil.getCurrentTimeMillis())));
            byTaskId.setStatus(OpinionStatus.AGENT.getKey());
            byTaskId.setAuditor(delegator.getUserId());
            byTaskId.setAuditorName(delegator.getFullname());
            byTaskId.setOpinion(OpinionStatus.AGENT.getValue() + "\u3010" + agent.getFullname() + "\u3011\u4ee3\u4e3a\u5904\u7406");
            this.bpmCheckOpinionManager.update((Model)byTaskId);
            byTaskId.setQualfiedNames(agent.getFullname());
            ArrayList<BpmIdentity> identities = new ArrayList<BpmIdentity>();
            DefaultBpmIdentity agentIdentity = new DefaultBpmIdentity(agent);
            identities.add(agentIdentity);
            byTaskId.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identities));
            byTaskId.setId(UniqueIdUtil.getSuid());
            byTaskId.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
            byTaskId.setCompleteTime(null);
            byTaskId.setAuditorName(null);
            byTaskId.setAuditor(null);
            byTaskId.setOpinion("");
            this.bpmCheckOpinionManager.create((Model)byTaskId);
        }
        delegateTask.setOwner(identity.getId());
        bpmTask.setOwnerId(identity.getId());
        bpmTask.setOwnerName(identity.getName());
        MultiInstanceType instanceType = delegateTask.multiInstanceType();
        if (BeanUtils.isNotEmpty((Object)((Object)instanceType)) && MultiInstanceType.SEQUENTIAL.equals((Object)instanceType) && BeanUtils.isNotEmpty((Object)((Object)(signData = this.bpmSignDataManager.getByInstanIdAndUserId(bpmTask.getProcInstId(), bpmTask.getOwnerId(), bpmTask.getTaskId())))) && "ADDSIGN".equals(signData.getType())) {
            bpmTask.setStatus(TaskType.ADDSIGN.getKey());
        }
        this.update((Model)bpmTask);
    }

    private IUser getAgent(BpmIdentity identity, BpmDelegateTask delegateTask, Map<String, Object> vars) {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        IUser agent = null;
        if (cmd instanceof DefaultTaskFinishCmd) {
            DefaultTaskFinishCmd finishCmd = (DefaultTaskFinishCmd)cmd;
            if (ActionType.APPROVE.equals((Object)finishCmd.getActionType())) {
                agent = this.bpmAgentService.getAgent(identity.getId(), delegateTask, vars);
            }
        } else {
            agent = this.bpmAgentService.getAgent(identity.getId(), delegateTask, vars);
        }
        return agent;
    }

    private void publishIdentityListWhenEmpty(BpmTask bpmTask, List<BpmIdentity> list, List<IUser> users) {
        if (BeanUtils.isNotEmpty(users)) {
            return;
        }
        NoExecutorModel noExcutor = NoExecutorModel.getNoExecutorModel(bpmTask.getTaskId(), bpmTask.getBpmnInstId(), bpmTask.getSubject(), bpmTask.getNodeId(), bpmTask.getName(), bpmTask.getBpmnDefId());
        noExcutor.setIdentifyList(list);
        BpmUtil.publishNoExecutorEvent(noExcutor);
    }

    @Override
    public List<DefaultBpmTask> getByInstId(String instId) {
        return ((BpmTaskDao)this.baseMapper).getByInstId(instId);
    }

    @Override
    public List<DefaultBpmTask> getByExeIdAndNodeId(String instId, String nodeId) {
        return ((BpmTaskDao)this.baseMapper).getByExeIdAndNodeId(instId, nodeId);
    }

    @Override
    public List<DefaultBpmTask> getByInstUser(String instId, String userId) {
        return ((BpmTaskDao)this.baseMapper).getByInstUser(instId, userId);
    }

    @Override
    public List<BpmIdentity> getIdentitysByTaskId(String taskId) {
        return Collections.emptyList();
    }

    @Override
    @Transactional
    public ResultMessage addSignTask(String taskId, String[] aryUsers) throws Exception {
        if (aryUsers == null || aryUsers.length == 0) {
            throw new BaseException("\u6ca1\u6709\u6307\u5b9a\u6267\u884c\u4eba!");
        }
        BpmTask bpmTask = (BpmTask)super.get((Serializable)((Object)taskId));
        String bpmnTaskId = bpmTask.getTaskId();
        ActTask actTask = (ActTask)this.actTaskManager.get((Serializable)((Object)bpmnTaskId));
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), actTask.getTaskDefKey());
        if (!(nodeDef instanceof SignNodeDef)) {
            throw new BaseException("\u5f53\u524d\u8282\u70b9\u4e0d\u662f\u4f1a\u7b7e\u8282\u70b9!");
        }
        SignNodeDef signNodeDef = (SignNodeDef)nodeDef;
        String actInstId = actTask.getProcInstId();
        String executionId = actTask.getExecutionId();
        String nodeId = nodeDef.getNodeId();
        String instId = bpmTask.getProcInstId();
        List<BpmSignData> signDataList = this.bpmSignDataManager.getVoteByExecuteNode(bpmTask.getExecId(), nodeId, 1);
        if (BeanUtils.isEmpty(signDataList)) {
            throw new BaseException("\u6ca1\u6709\u4f1a\u7b7e\u6570\u636e!");
        }
        List<BpmIdentity> users = this.getCanAddUsers(signDataList, aryUsers);
        if (BeanUtils.isEmpty(users)) {
            throw new BaseException("\u6307\u5b9a\u7684\u4eba\u5458\u5df2\u5b58\u5728!");
        }
        int userAmount = users.size();
        Integer nrOfInstances = (Integer)this.natProInstanceService.getVariable(executionId, "nrOfInstances");
        if (nrOfInstances != null) {
            this.natProInstanceService.setVariable(executionId, "nrOfInstances", nrOfInstances + userAmount);
        }
        ArrayList taskIds = new ArrayList();
        if (signNodeDef.isParallel()) {
            Integer loopCounter = nrOfInstances - 1;
            Integer nrOfActiveInstances = (Integer)this.natProInstanceService.getVariable(executionId, "nrOfActiveInstances");
            this.natProInstanceService.setVariable(executionId, "nrOfActiveInstances", nrOfActiveInstances + userAmount);
            for (int i = 0; i < userAmount; ++i) {
                BpmIdentity bpmIdentity = users.get(i);
                ActTask newActTask = this.actTaskManager.createTask(taskId, bpmIdentity.getId());
                DefaultBpmTask signBpmTask = (DefaultBpmTask)super.get((Serializable)((Object)newActTask.getId()));
                signBpmTask.setStatus(TaskType.ADDSIGN.getKey());
                signBpmTask.setExecId(bpmTask.getExecId());
                super.update((Model)signBpmTask);
                this.addSignCheckOpinion(signBpmTask, OpinionStatus.AWAITING_CHECK, bpmIdentity.getId());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", bpmIdentity.getId());
                map.put("taskId", signBpmTask.getTaskId());
                taskIds.add(map);
                String newExecutionId = newActTask.getExecutionId();
                Integer index = loopCounter + i + 1;
                this.natProInstanceService.setVariableLocal(newExecutionId, "loopCounter", index);
                this.natProInstanceService.setVariableLocal(newExecutionId, "assignee", bpmIdentity);
                this.natProInstanceService.setVariableLocal(newExecutionId, "token_", index + 100);
                BaseActionCmd cmd = new BaseActionCmd();
                ContextThreadUtil.setActionCmd(cmd);
                this.bpmExeStackManager.pushStack(bpmTask.getProcDefId(), String.valueOf(index + 100), instId, nodeId, MultiInstanceType.PARALLEL, signBpmTask);
                this.bpmSignDataManager.addSignData(bpmTask.getProcDefId(), instId, actInstId, bpmTask.getExecId(), nodeId, signBpmTask.getTaskId(), bpmIdentity.getId(), bpmIdentity.getName(), index.shortValue(), "ADDSIGN");
            }
        } else {
            String varName = "signUsers_" + nodeId;
            ArrayList<BpmIdentity> addList = new ArrayList<BpmIdentity>();
            for (int i = 0; i < userAmount; ++i) {
                Integer index = nrOfInstances + i;
                BpmIdentity bpmIdentity = users.get(i);
                this.bpmSignDataManager.addSignData(bpmTask.getProcDefId(), instId, actInstId, bpmTask.getExecId(), nodeId, bpmTask.getTaskId(), bpmIdentity.getId(), bpmIdentity.getName(), index.shortValue(), "ADDSIGN");
                addList.add(bpmIdentity);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", bpmIdentity.getId());
                map.put("taskId", bpmTask.getTaskId());
                taskIds.add(map);
            }
            List list = (List)this.natProInstanceService.getVariable(executionId, varName);
            list.addAll(addList);
            this.natProInstanceService.setVariable(executionId, varName, list);
        }
        ResultMessage rtnMessage = ResultMessage.getSuccess("\u52a0\u7b7e\u6210\u529f!");
        rtnMessage.addVariable("actTask", actTask);
        rtnMessage.addVariable("users", users);
        rtnMessage.addVariable("taskIds", taskIds);
        return rtnMessage;
    }

    @Transactional
    private void addSignCheckOpinion(DefaultBpmTask bpmTask, OpinionStatus opinionStatus, String toUser) {
        IUser user = BpmUtil.getUser(toUser);
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        String signType = null;
        String status = bpmTask.getStatus();
        if (TaskType.SIGNLINEED.getKey().equals(status)) {
            signType = "Parallel";
        }
        if (TaskType.SIGNSEQUENCEED.getKey().equals(status)) {
            signType = "Sequential";
        }
        if (TaskType.APPROVELINEED.getKey().equals(status)) {
            signType = "ParallelApprove";
        }
        DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
        checkOpinion.setId(UniqueIdUtil.getSuid());
        checkOpinion.setProcDefId(bpmTask.getBpmnDefId());
        checkOpinion.setProcInstId(bpmTask.getProcInstId());
        checkOpinion.setSignType(signType);
        checkOpinion.setTaskId(bpmTask.getTaskId());
        checkOpinion.setTaskKey(bpmTask.getNodeId());
        checkOpinion.setTaskName(bpmTask.getName());
        checkOpinion.setStatus(opinionStatus.getKey());
        checkOpinion.setCreateTime(LocalDateTime.now());
        checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        checkOpinion.setQualfiedNames(user.getFullname());
        this.bpmCheckOpinionManager.create((Model)checkOpinion);
    }

    private List<BpmIdentity> getCanAddUsers(List<BpmSignData> list, String[] aryUsers) {
        ArrayList<BpmIdentity> rtnList = new ArrayList<BpmIdentity>();
        ArrayList<String> userList = new ArrayList<String>();
        for (BpmSignData signData : list) {
            if (!"no".equals(signData.getVoteResult())) continue;
            userList.add(signData.getQualifiedId());
        }
        for (String userId : aryUsers) {
            if (userList.contains(userId)) continue;
            IUser user = this.userServiceImpl.getUserById(userId);
            BpmIdentity identity = DefaultBpmIdentity.getIdentityByUserId(userId, user.getFullname());
            rtnList.add(identity);
        }
        return rtnList;
    }

    @Override
    public List<DefaultBpmTask> getByBpmInstIdUserIdGroupList(String bpmnInstId, String userId, List<IGroup> groupList) {
        return ((BpmTaskDao)this.baseMapper).getByBpmInstIdUserIdGroupList(bpmnInstId, userId, groupList);
    }

    @Override
    @Transactional
    public void lockTask(String taskId, String userId) {
        DefaultBpmCheckOpinion opinion = new DefaultBpmCheckOpinion();
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)super.get((Serializable)((Object)taskId));
        opinion.setAuditor(userId);
        opinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        opinion.setQualfiedNames(ContextUtil.getCurrentUser().getFullname());
        opinion.setStatus(OpinionStatus.LOCK_TASK.getKey());
        opinion.setOpinion(OpinionStatus.LOCK_TASK.getValue() + "\u4efb\u52a1");
        opinion.setProcDefId(defaultBpmTask.getProcDefId());
        opinion.setProcInstId(defaultBpmTask.getProcInstId());
        opinion.setTaskName(defaultBpmTask.getName());
        opinion.setCreateTime(LocalDateTime.now());
        opinion.setCompleteTime(LocalDateTime.now());
        this.bpmCheckOpinionManager.create((Model)opinion);
        ((BpmTaskDao)this.baseMapper).updateAssigneeOwnerId(taskId, userId, userId);
    }

    @Override
    @Transactional
    public void unLockTask(String taskId, String userId) {
        DefaultBpmCheckOpinion opinion = new DefaultBpmCheckOpinion();
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)super.get((Serializable)((Object)taskId));
        opinion.setAuditor(userId);
        opinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        opinion.setQualfiedNames(ContextUtil.getCurrentUser().getFullname());
        opinion.setStatus(OpinionStatus.UN_LOCK_TASK.getKey());
        opinion.setOpinion(OpinionStatus.UN_LOCK_TASK.getValue() + "\u4efb\u52a1");
        opinion.setProcDefId(defaultBpmTask.getProcDefId());
        opinion.setProcInstId(defaultBpmTask.getProcInstId());
        opinion.setTaskName(defaultBpmTask.getName());
        opinion.setCreateTime(LocalDateTime.now());
        opinion.setCompleteTime(LocalDateTime.now());
        this.bpmCheckOpinionManager.create((Model)opinion);
        ((BpmTaskDao)this.baseMapper).updateAssigneeOwnerId(taskId, "0", "0");
    }

    @Override
    @Transactional
    public void assignTask(String taskId, String assigneeId) {
        DefaultBpmTask bpmTask = (DefaultBpmTask)super.get((Serializable)((Object)taskId));
        ((BpmTaskDao)this.baseMapper).updateAssigneeById(taskId, assigneeId);
        this.natTaskService.setAssignee(bpmTask.getTaskId(), assigneeId);
    }

    @Override
    @Transactional
    public void delByInstList(List<String> instList) {
        ((BpmTaskDao)this.baseMapper).delByInstList(instList);
    }

    @Override
    @Transactional
    public void delByParentId(String parentId) {
        List<String> ids = ((BpmTaskDao)this.baseMapper).getIdsByParentId(parentId);
        if (BeanUtils.isNotEmpty(ids) && ids.size() > 0) {
            this.removeByIds(ids.toArray(new String[ids.size()]));
        }
    }

    @Override
    public List<DefaultBpmTask> getChildsByTaskId(String taskId) {
        List<DefaultBpmTask> list = ((BpmTaskDao)this.baseMapper).getByParentId(taskId);
        ArrayList<DefaultBpmTask> rtnList = new ArrayList<DefaultBpmTask>();
        for (DefaultBpmTask task : list) {
            this.getByParentId(task, rtnList);
        }
        return rtnList;
    }

    private void getByParentId(DefaultBpmTask task, List<DefaultBpmTask> rtnList) {
        rtnList.add(task);
        List<DefaultBpmTask> list = ((BpmTaskDao)this.baseMapper).getByParentId(task.getId());
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        for (DefaultBpmTask tmp : list) {
            this.getByParentId(tmp, rtnList);
        }
    }

    @Override
    @Transactional
    public void createTask(BpmProcessInstance instance) {
        ActTask actTask = new ActTask();
        actTask.setId(UniqueIdUtil.getSuid());
        actTask.setRev(1);
        actTask.setExecutionId(instance.getBpmnInstId());
        actTask.setProcInstId(instance.getBpmnInstId());
        actTask.setAssignee(instance.getCreateBy());
    }

    public List<DefaultBpmTask> queryList(QueryFilter queryFilter) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            this.actRightMap = this.bpmDefAuthorizeManager.getActRightByUserId(userId, "task", true, true);
            String defKeys = (String)this.actRightMap.get("defKeys");
            if (StringUtil.isNotEmpty((String)defKeys)) {
                queryFilter.addParams("defKeys", (Object)defKeys);
            }
        }
        List list = (List)this.query((QueryFilter<DefaultBpmTask>)queryFilter);
        return this.convertInfo(list);
    }

    @Override
    public List<DefaultBpmTask> convertInfo(List<DefaultBpmTask> list) throws Exception {
        if (list == null) {
            return list;
        }
        for (DefaultBpmTask bpmTask : list) {
            List<BpmIdentity> identityList = this.bpmIdentityService.queryListByBpmTask(bpmTask);
            bpmTask.setIdentityList(identityList);
            if (bpmTask.getDueTaskTime() <= 0) continue;
            int dueUseTaskTime = -1;
            if ("caltime".equals(bpmTask.getDueDateType())) {
                dueUseTaskTime = TimeUtil.getSecondDiff((LocalDateTime)LocalDateTime.now(), (LocalDateTime)bpmTask.getCreateTime()) / 60;
            } else {
                List<IUser> extractUser = this.bpmIdentityExtractService.extractUser(identityList);
                if (BeanUtils.isNotEmpty(extractUser) && extractUser.size() == 1) {
                    IUser iUser = extractUser.get(0);
                    ObjectNode params = JsonUtil.getMapper().createObjectNode();
                    params.put("userId", iUser.getUserId());
                    params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTask.getCreateTime()));
                    params.put("endTime", DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()));
                    dueUseTaskTime = (int)(this.systemConfigFeignService.getWorkTimeByUser(params) / 60000L);
                }
            }
            bpmTask.setDueUseTaskTime(dueUseTaskTime);
        }
        return list;
    }

    @Override
    public List<DefaultBpmTask> getReminderTask() {
        return ((BpmTaskDao)this.baseMapper).getReminderTask();
    }

    @Override
    @Transactional
    public void endProcessByTaskId(String taskId, String informType, String cause, String files, ObjectNode busDataObjectNode) throws Exception {
        BpmTask bpmTask = (BpmTask)super.get((Serializable)((Object)taskId));
        String InstId = bpmTask.getProcInstId();
        String topInstId = this.bpmCheckOpinionManager.getTopInstId(InstId);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)InstId));
        instance.setStatus(ProcessInstanceStatus.STATUS_MANUAL_END.getKey());
        instance.setEndTime(LocalDateTime.now());
        instance.setDuration(TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)instance.getCreateTime()));
        this.bpmProcessInstanceManager.update((Model)instance);
        List<DefaultBpmCheckOpinion> litCheckOpinions = this.bpmCheckOpinionManager.getByInstId(InstId);
        if (litCheckOpinions != null) {
            for (DefaultBpmCheckOpinion defaultBpmCheckOpinion : litCheckOpinions) {
                if (!defaultBpmCheckOpinion.getStatus().equals("awaiting_check")) continue;
                defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
                defaultBpmCheckOpinion.setAuditor(BeanUtils.isNotEmpty((Object)ContextUtil.getCurrentUser()) ? ContextUtil.getCurrentUser().getUserId() : "-1");
                defaultBpmCheckOpinion.setAuditorName(BeanUtils.isNotEmpty((Object)ContextUtil.getCurrentUser()) ? ContextUtil.getCurrentUser().getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba");
                defaultBpmCheckOpinion.setStatus(OpinionStatus.MANUAL_END.getKey());
                defaultBpmCheckOpinion.setDurMs(TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)defaultBpmCheckOpinion.getCreateTime()));
                defaultBpmCheckOpinion.setOpinion(cause);
                defaultBpmCheckOpinion.setFiles(files);
                this.bpmCheckOpinionManager.update((Model)defaultBpmCheckOpinion);
                NodeStatus nanualEndStatus = NodeStatus.MANUAL_END;
                this.bpmProStatusManager.createOrUpd(instance.getId(), instance.getBpmnDefId(), defaultBpmCheckOpinion.getTaskKey(), defaultBpmCheckOpinion.getTaskName(), nanualEndStatus);
            }
        }
        BpmInterposeRecored bpmInterposeRecored = new BpmInterposeRecored(InstId, cause, InterPoseType.ARTIFICIAL_END, cause);
        BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
        manager.create((Model)bpmInterposeRecored);
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), bpmTask.getNodeId());
        List<Button> buttons = null;
        if (BeanUtils.isNotEmpty((Object)taskNodeDef)) {
            buttons = BpmUtil.getButtons(taskNodeDef);
        }
        for (Button button : buttons) {
            String completeEventGroovyScript;
            if (!"endProcess".equals(button.getAlias()) || !StringUtil.isNotEmpty((String)(completeEventGroovyScript = button.getCompleteEventGroovyScript()))) continue;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("busDataObjectNode", busDataObjectNode);
            List<ObjectNode> boDatas = this.boDataService.getDataByInst(instance);
            ObjectNode data = BoDataUtil.hanlerData(instance, null, boDatas);
            vars.put("data", data);
            vars.put("instance", instance);
            this.groovyScriptEngine.execute(completeEventGroovyScript, vars);
        }
        BpmProcessInstance processInstance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)topInstId));
        ArrayList<IUser> userList = new ArrayList<IUser>();
        if (topInstId != null) {
            IUser user = BpmUtil.getUser(processInstance.getCreateBy(), processInstance.getCreator());
            userList.add(user);
        }
        Map<String, Object> vars = this.getVars(bpmTask, cause);
        MessageUtil.sendMsg("bpmEndProcess", informType, userList, vars);
    }

    private Map<String, Object> getVars(BpmTask task, String cause) {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        IUser user = ContextUtil.getCurrentUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("delegate", BeanUtils.isNotEmpty((Object)user) ? user.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba");
        map.put("nodeName", task.getName());
        map.put("taskSubject", task.getSubject());
        map.put("instSubject", task.getSubject());
        map.put("baseUrl", baseUrl);
        map.put("cause", cause);
        map.put("instId", task.getProcInstId());
        return map;
    }

    @Override
    public List<DefaultBpmTask> getByInstList(List<String> instIds) {
        return ((BpmTaskDao)this.baseMapper).getByInstList(instIds);
    }

    public PageList<DefaultBpmTask> getMyTransTask(String userId, QueryFilter queryFilter) {
        if (BeanUtils.isEmpty((Object)queryFilter)) {
            queryFilter = QueryFilter.build().withDefaultPage();
        }
        queryFilter.withParam("userId", (Object)userId);
        return ((BpmTaskDao)this.baseMapper).getMyTransTask((IPage<DefaultBpmTask>)this.convert2IPage(queryFilter.getPageBean()), queryFilter.getParams());
    }

    @Override
    @Transactional
    public void delegate(String taskId, IUser toUser) {
        Assert.notNull((Object)toUser, (String)"\u8f6c\u529e\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a!");
        DefaultBpmTask bpmTask = (DefaultBpmTask)super.get((Serializable)((Object)taskId));
        bpmTask.setAssigneeId(toUser.getUserId());
        bpmTask.setAssigneeName(toUser.getFullname());
        bpmTask.setStatus(TaskType.DELIVERTO.name());
        super.update((Model)bpmTask);
        this.natTaskService.setAssignee(bpmTask.getTaskId(), toUser.getUserId());
    }

    @Override
    public int canLockTask(String taskId) {
        return this.canLockTask(taskId, "");
    }

    @Override
    public int canLockTask(String taskId, String curUserId) {
        BpmTask task;
        IUser currentUser = ContextUtil.getCurrentUser();
        if (StringUtil.isZeroEmpty((String)curUserId)) {
            curUserId = currentUser.getUserId();
        }
        if ((task = (BpmTask)super.get((Serializable)((Object)taskId))) == null) {
            return 0;
        }
        if (TaskType.DELIVERTO.getKey().equals(task.getStatus())) {
            return 2;
        }
        if (currentUser.isAdmin()) {
            return 5;
        }
        String assigneeId = task.getAssigneeId();
        List<DefaultBpmTaskCandidate> list = this.bpmTaskCandidateManager.queryByTaskId(taskId);
        if ("0".equals(assigneeId)) {
            if (BeanUtils.isEmpty(list) || currentUser.isAdmin()) {
                return 1;
            }
            boolean isExist = this.isInCandidate(list, curUserId);
            return isExist ? 1 : 5;
        }
        if (curUserId.equals(assigneeId)) {
            if (BeanUtils.isEmpty(list)) {
                return 2;
            }
            if (currentUser.isAdmin()) {
                return 3;
            }
            boolean isExist = this.isInCandidate(list, curUserId);
            return isExist ? 3 : 5;
        }
        return 4;
    }

    @Override
    public boolean canAccessTask(String taskId, String userId) {
        BpmTask task = (BpmTask)this.get((Serializable)((Object)taskId));
        if (task.getAssigneeId().equals(userId)) {
            return true;
        }
        List<DefaultBpmTaskCandidate> candidateList = this.bpmTaskCandidateManager.queryByTaskId(taskId);
        return this.isInCandidate(candidateList, userId);
    }

    private boolean isInCandidate(List<DefaultBpmTaskCandidate> candidateList, String userId) {
        List groups = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        Map<String, IGroup> groupMap = this.groupListToMap(groups);
        for (DefaultBpmTaskCandidate candidate : candidateList) {
            String executor = candidate.getExecutor();
            if (!("user".equals(candidate.getType()) ? userId.equals(executor) : groupMap.containsKey(executor))) continue;
            return true;
        }
        return false;
    }

    private Map<String, IGroup> groupListToMap(List<IGroup> groups) {
        HashMap<String, IGroup> map = new HashMap<String, IGroup>();
        if (BeanUtils.isNotEmpty(groups)) {
            for (IGroup group : groups) {
                map.put(group.getGroupId(), group);
            }
        }
        return map;
    }

    @Override
    public DefaultBpmTask getByTaskId(String taskId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)super.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            return null;
        }
        ArrayList<DefaultBpmTask> tasks = new ArrayList<DefaultBpmTask>();
        tasks.add(task);
        this.convertInfo(tasks);
        return (DefaultBpmTask)tasks.get(0);
    }

    @Override
    @Transactional
    public void setTaskExecutors(String taskId, String[] userIds, String notifyType, String opinion) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)super.get((Serializable)((Object)taskId));
        this.bpmTaskCandidateManager.removeByTaskId(taskId);
        DefaultBpmCheckOpinion bpmCheckOpinion = this.bpmCheckOpinionManager.getByTaskId(taskId);
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        BpmIdentityConverter bpmIdentityConverter = (BpmIdentityConverter)AppUtil.getBean(BpmIdentityConverter.class);
        String userRealName = "";
        int index = 0;
        for (String userId : userIds) {
            ++index;
            IUser user = this.userServiceImpl.getUserById(userId);
            BpmIdentity bpmIdentity = bpmIdentityConverter.convertUser(user);
            bpmIdentity.setType("user");
            identityList.add(bpmIdentity);
            userRealName = userRealName + user.getFullname();
            if (index == userIds.length) continue;
            userRealName = userRealName + ",";
        }
        bpmCheckOpinion.setQualfiedNames(userRealName);
        bpmCheckOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        this.bpmCheckOpinionManager.update((Model)bpmCheckOpinion);
        if (BeanUtils.isEmpty((Object)userIds)) {
            task.setAssigneeId("0");
        } else if (userIds.length == 1) {
            task.setAssigneeId(userIds[0]);
            task.setAssigneeName(userRealName);
        } else {
            task.setAssigneeId("0");
            task.setAssigneeName("");
            ArrayList<BpmIdentity> list = new ArrayList<BpmIdentity>();
            for (String userId : userIds) {
                DefaultBpmIdentity identity = new DefaultBpmIdentity();
                identity.setType("user");
                identity.setId(userId);
                list.add(identity);
            }
            this.bpmTaskCandidateManager.addCandidate(taskId, list);
        }
        super.update((Model)task);
        this.sendMsg(task, userIds, notifyType, opinion);
    }

    @Transactional
    private void sendMsg(BpmTask task, String[] userIds, String notifyType, String opinion) throws Exception {
        if (BeanUtils.isEmpty((Object)userIds)) {
            return;
        }
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        NotifyTaskModel model = new NotifyTaskModel();
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (String userId : userIds) {
            IUser user = this.userServiceImpl.getUserById(userId);
            userList.add(user);
        }
        model.setIdentitys(userList);
        model.setOpinion(opinion);
        model.addVars("baseUrl", baseUrl).addVars("taskSubject", task.getSubject()).addVars("taskId", task.getId()).addVars("cause", opinion);
        MessageUtil.send(model, notifyType, "bpmTaskSetExecutors");
    }

    @Override
    @Transactional
    public void updateTaskPriority(String taskId, Long priority) {
        ((BpmTaskDao)this.baseMapper).updateTaskPriority(taskId, priority);
    }

    @Override
    public List<DefaultBpmTask> getByExecuteAndNodeId(String executeId, String nodeId) {
        return ((BpmTaskDao)this.baseMapper).getByExecuteAndNodeId(executeId, nodeId);
    }

    @Override
    @Transactional
    public ResultMessage addCustomSignTask(String taskId, String[] aryUsers, boolean isCreateSignData) throws Exception {
        if (aryUsers == null || aryUsers.length == 0) {
            throw new BaseException("\u6ca1\u6709\u6307\u5b9a\u6267\u884c\u4eba!");
        }
        BpmTask bpmTask = (BpmTask)super.get((Serializable)((Object)taskId));
        String bpmnTaskId = bpmTask.getTaskId();
        ActTask actTask = (ActTask)this.actTaskManager.get((Serializable)((Object)bpmnTaskId));
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), actTask.getTaskDefKey());
        if (!(nodeDef instanceof CustomSignNodeDef)) {
            throw new BaseException("\u5f53\u524d\u8282\u70b9\u4e0d\u662f\u7b7e\u7f72\u8282\u70b9!");
        }
        CustomSignNodeDef signNodeDef = (CustomSignNodeDef)nodeDef;
        String executionId = actTask.getExecutionId();
        String nodeId = nodeDef.getNodeId();
        List<BpmIdentity> users = this.getCanAddUsers(Arrays.asList(new BpmSignData[0]), aryUsers);
        if (BeanUtils.isEmpty(users)) {
            throw new BaseException("\u6307\u5b9a\u7684\u4eba\u5458\u5df2\u5b58\u5728!");
        }
        int userAmount = users.size();
        Integer nrOfInstances = (Integer)this.natProInstanceService.getVariable(executionId, "nrOfInstances");
        if (nrOfInstances != null) {
            this.natProInstanceService.setVariable(executionId, "nrOfInstances", nrOfInstances + userAmount);
        }
        ArrayList taskIds = new ArrayList();
        String customStatus = "complete";
        if (signNodeDef.isParallel()) {
            Integer loopCounter = nrOfInstances - 1;
            Integer baseToken = nrOfInstances + 99;
            Integer nrOfActiveInstances = (Integer)this.natProInstanceService.getVariable(executionId, "nrOfActiveInstances");
            this.natProInstanceService.setVariable(executionId, "nrOfActiveInstances", nrOfActiveInstances + userAmount);
            DefaultTaskFinishCmd defaultTaskFinishCmd = new DefaultTaskFinishCmd();
            ContextThreadUtil.setActionCmd(defaultTaskFinishCmd);
            BpmExeStack stack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), nodeId, String.valueOf(baseToken));
            defaultTaskFinishCmd.addTransitVars("parentStack", (Object)stack);
            for (int i = 0; i < userAmount; ++i) {
                BpmIdentity bpmIdentity = users.get(i);
                ActTask newActTask = this.actTaskManager.createTask(taskId, bpmIdentity.getId());
                DefaultBpmTask signBpmTask = (DefaultBpmTask)super.get((Serializable)((Object)newActTask.getId()));
                signBpmTask.setOwnerName(bpmIdentity.getName());
                signBpmTask.setAssigneeName(bpmIdentity.getName());
                signBpmTask.setExecId(bpmTask.getExecId());
                super.update((Model)signBpmTask);
                this.addSignCheckOpinion(signBpmTask, OpinionStatus.AWAITING_CHECK, bpmIdentity.getId());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", bpmIdentity.getId());
                map.put("taskId", signBpmTask.getTaskId());
                taskIds.add(map);
                ContextThreadUtil.putCommonVars("create_bpm_task" + ContextUtil.getCurrentUserId(), signBpmTask);
                String newExecutionId = newActTask.getExecutionId();
                Integer index = loopCounter + i + 1;
                this.natProInstanceService.setVariableLocal(newExecutionId, "loopCounter", index);
                this.natProInstanceService.setVariableLocal(newExecutionId, "assignee", bpmIdentity);
                this.natProInstanceService.setVariableLocal(newExecutionId, "token_", baseToken + i + 1);
                if (isCreateSignData) {
                    this.bpmCustomSignDataManager.addCustomSignData(signBpmTask, bpmnTaskId);
                }
                PushStackEvent pushStackEvent = new PushStackEvent(new PushStackModel(newActTask, signBpmTask));
                AppUtil.publishEvent((ApplicationEvent)pushStackEvent);
            }
        } else {
            customStatus = "complete";
            String varName = "signUsers_" + nodeId;
            List list = (List)this.natProInstanceService.getVariable(executionId, varName);
            Integer loopCounter = (Integer)this.natProInstanceService.getVariable(executionId, "loopCounter");
            for (int i = 0; i < userAmount; ++i) {
                BpmIdentity bpmIdentity = users.get(i);
                list.add(loopCounter + 1 + i, bpmIdentity);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", bpmIdentity.getId());
                map.put("taskId", bpmTask.getTaskId());
                taskIds.add(map);
            }
            this.natProInstanceService.setVariable(executionId, varName, list);
        }
        ResultMessage rtnMessage = ResultMessage.getSuccess("\u7b7e\u7f72\u6210\u529f!");
        rtnMessage.addVariable("actTask", actTask);
        rtnMessage.addVariable("users", users);
        rtnMessage.addVariable("taskIds", taskIds);
        rtnMessage.addVariable("customStatus", customStatus);
        return rtnMessage;
    }

    @Override
    @Transactional
    public ResultMessage addCustomSignTask(String taskId, String[] aryUsers) throws Exception {
        return this.addCustomSignTask(taskId, aryUsers, true);
    }

    @Override
    @Transactional
    public void approvalTaskRevoke(String runningTaskId, String customSignTaskId) throws Exception {
        BpmCheckOpinionUtil.updateCheckRevoker(customSignTaskId);
        this.addCustomSignTask(runningTaskId, new String[]{ContextUtil.getCurrentUserId()}, false);
        String createTaskId = this.getNewCreateTaskId();
        this.bpmCustomSignDataManager.updateStatusByTaskId(customSignTaskId, "complete", "withdrawApproval", createTaskId);
    }

    @Override
    @Transactional
    public void sequentialTaskRevoke(String runingTaskId, String customSignTaskId) throws Exception {
        Integer loopcounter = (Integer)this.natTaskService.getVariable(runingTaskId, "loopCounter");
        if (loopcounter == 0) {
            throw new BaseException("\u6ca1\u6709\u53ef\u64a4\u56de\u7684\u4efb\u52a1");
        }
        this.natTaskService.setVariable(runingTaskId, "loopCounter", loopcounter - 2);
        DefaultTaskFinishCmd cmd = this.getCmd(runingTaskId, "agree", OpinionStatus.RETRACTED.getValue());
        this.bpmTaskActionService.finishTask(cmd);
        String newCreateTaskId = this.getNewCreateTaskId(cmd);
        this.bpmCustomSignDataManager.updateStatusByTaskId(customSignTaskId, "complete", "withdrawApproval", newCreateTaskId);
    }

    private String getNewCreateTaskId(DefaultTaskFinishCmd cmd) {
        Object transitVars = cmd.getTransitVars("create_bpm_task");
        String newCreateTaskId = null;
        if (BeanUtils.isNotEmpty((Object)transitVars)) {
            BpmTask bpmTask = (BpmTask)transitVars;
            newCreateTaskId = bpmTask.getId();
        }
        return newCreateTaskId;
    }

    private String getNewCreateTaskId() {
        String createTaskId = null;
        Object commuVar = ContextThreadUtil.getCommuVar("create_bpm_task" + ContextUtil.getCurrentUserId(), null);
        if (BeanUtils.isNotEmpty((Object)commuVar)) {
            createTaskId = ((BpmTask)commuVar).getId();
        }
        return createTaskId;
    }

    private DefaultTaskFinishCmd getCmd(String taskId, String actionName, String opinion) {
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        cmd.setTaskId(taskId);
        cmd.setActionName(actionName);
        cmd.addTransitVars("IsDoneUnused", true);
        cmd.setApprovalOpinion(opinion);
        cmd.setDataMode("bo");
        return cmd;
    }

    @Override
    @Transactional
    public void approvalTaskARevoke(String instId, String runningTaskId, String customSignTaskId, String destNodeId) throws Exception {
        BpmCheckOpinionUtil.updateCheckRevoker(customSignTaskId);
        this.bpmCustomSignDataManager.removeByInstId(instId);
        DefaultTaskFinishCmd taskCmd = this.getCmd(runningTaskId, "reject", "");
        this.setRejctCmd(taskCmd, "normal", destNodeId);
        taskCmd.addTransitVars("record_stack", true);
        taskCmd.addTransitVars("opinion_sign_type", "BeforeSign");
        this.bpmTaskActionService.finishTask(taskCmd);
    }

    private void setRejctCmd(DefaultTaskFinishCmd cmd, String backHandMode, String destNodeId) {
        cmd.setDestination(destNodeId);
        cmd.addTransitVars("backHandMode", backHandMode);
    }

    @Override
    @Transactional
    public void sequentialTaskARevoke(String instanceId, String taskId, String destNodeId) throws Exception {
        this.bpmCustomSignDataManager.removeByInstId(instanceId);
        DefaultTaskFinishCmd taskCmd = this.getCmd(taskId, "reject", "");
        this.setRejctCmd(taskCmd, "normal", destNodeId);
        taskCmd.addTransitVars("record_stack", true);
        taskCmd.addTransitVars("opinion_sign_type", "BeforeSign");
        this.bpmTaskActionService.finishTask(taskCmd);
    }

    @Override
    @Transactional
    public void taskAnRevoke(String instanceId, String runningTaskId, String targetNodeId, String targetTaskId) throws Exception {
        DefaultTaskFinishCmd taskCmd = this.getCmd(runningTaskId, "agree", "");
        this.setRejctCmd(taskCmd, "normal", targetNodeId);
        this.setCmdBpmIdentity(taskCmd, targetNodeId);
        taskCmd.addTransitVars("record_stack", true);
        taskCmd.addTransitVars("b_tasks_revoke", true);
        this.bpmTaskActionService.finishTask(taskCmd);
        String newCreateTaskId = this.getNewCreateTaskId(taskCmd);
        this.bpmCustomSignDataManager.updateStatusByTaskId(targetTaskId, "complete", "withdrawApproval", newCreateTaskId);
        BpmCheckOpinionUtil.updateCheckRevoker(targetTaskId);
    }

    @Transactional
    private void setCmdBpmIdentity(DefaultTaskFinishCmd taskCmd, String targetNodeId) {
        ArrayList<BpmIdentity> list = new ArrayList<BpmIdentity>();
        BpmIdentity bpmIdentity = this.defaultBpmIdentityConverter.convertUser(ContextUtil.getCurrentUser());
        list.add(bpmIdentity);
        HashMap<String, List<BpmIdentity>> nodeIdentityMap = new HashMap<String, List<BpmIdentity>>();
        nodeIdentityMap.put(targetNodeId, list);
        taskCmd.setBpmIdentities(nodeIdentityMap);
    }

    @Override
    @Transactional
    public void parallaelARevoke(String instanceId, String targetNodeId, String currentTaskIds) throws Exception {
        List<String> taskIds = Arrays.asList(currentTaskIds.split(","));
        String firstTaskId = taskIds.get(0);
        for (String revokeTaskId : taskIds) {
            if (revokeTaskId.equals(firstTaskId)) continue;
            DefaultTaskFinishCmd taskCmd = this.getCmd(revokeTaskId, "agree", "");
            this.bpmTaskActionService.finishTask(taskCmd);
        }
        List<BpmCustomSignData> signDatas = this.bpmCustomSignDataManager.getByInstIdAndStatus(instanceId, Arrays.asList("approval", "withdrawApproval"));
        String action = "agree";
        String destNodeId = "";
        DefaultTaskFinishCmd taskCmd = this.getCmd(firstTaskId, action, "");
        if (BeanUtils.isNotEmpty(signDatas) && signDatas.size() == 1 && signDatas.get(0).getTaskId().equals(firstTaskId)) {
            action = "reject";
            destNodeId = targetNodeId;
            taskCmd.addTransitVars("record_stack", true);
            taskCmd.addTransitVars("opinion_sign_type", "BeforeSign");
        }
        taskCmd.setActionName(action);
        this.setRejctCmd(taskCmd, "normal", destNodeId);
        this.bpmTaskActionService.finishTask(taskCmd);
        if ("reject".equals(action)) {
            this.bpmCustomSignDataManager.removeByInstId(instanceId);
        }
    }

    @Override
    @Transactional
    public void parallelRevoke(String currentTaskIds, String targetTaskId) throws Exception {
        List<String> taskIds = Arrays.asList(currentTaskIds.split(","));
        for (String revokeTaskId : taskIds) {
            this.bpmCustomSignDataManager.updateStatusByTaskId(revokeTaskId, Arrays.asList("approval", "withdrawApproval"), "retracted", null);
        }
        List<BpmCustomSignData> signDatas = this.bpmCustomSignDataManager.getParallelSonByTaskId(targetTaskId);
        if (BeanUtils.isEmpty(signDatas)) {
            this.addCustomSignTask(taskIds.get(0), new String[]{ContextUtil.getCurrentUserId()}, false);
            String newCreateTaskId = this.getNewCreateTaskId();
            this.bpmCustomSignDataManager.updateStatusByTaskId(targetTaskId, "complete", "withdrawApproval", newCreateTaskId);
        }
        for (String revokeTaskId : taskIds) {
            DefaultTaskFinishCmd taskCmd = this.getCmd(revokeTaskId, "agree", "");
            this.bpmTaskActionService.finishTask(taskCmd);
        }
    }

    @Override
    @Transactional
    public void updateOwner(Map<String, Object> ownerMap) {
        ((BpmTaskDao)this.baseMapper).updateOwner(ownerMap);
    }

    @Override
    @Transactional
    public void updateAssignee(Map<String, Object> assigneeMap) {
        ((BpmTaskDao)this.baseMapper).updateAssignee(assigneeMap);
    }

    public PageList<DefaultBpmTask> query(QueryFilter<DefaultBpmTask> queryFilter) {
        Map params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty((Object)params) && (Integer)params.get("isAdmin") == 0) {
            String defKeys = (String)params.get("defKeys");
            String instanceIds = (String)params.get("instanceIds");
            if (BeanUtils.isEmpty((Object)defKeys) && StringUtil.isEmpty((String)instanceIds)) {
                return new PageList();
            }
            if (BeanUtils.isNotEmpty((Object)defKeys)) {
                queryFilter.addFilter("proc_def_key_", (Object)defKeys, QueryOP.IN);
            }
            if (StringUtil.isNotEmpty((String)instanceIds)) {
                String[] ids = instanceIds.split(",");
                queryFilter.addFilter("PROC_INST_ID_", Arrays.asList(ids), QueryOP.IN);
            }
        }
        queryFilter.setParams(new HashMap());
        return new PageList(((BpmTaskDao)this.baseMapper).customQuery((IPage<DefaultBpmTask>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<DefaultBpmTask>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ObjectNode> getTaskListByTenantId(String tenantId) throws Exception {
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            List<DefaultBpmTask> taskList = ((BpmTaskDao)this.baseMapper).getTaskByTenantId(tenantId);
            if (BeanUtils.isNotEmpty(taskList)) {
                for (DefaultBpmTask list : taskList) {
                    ObjectNode tasNode = (ObjectNode)JsonUtil.toJsonNode((Object)list);
                    dataObjects.add(tasNode);
                }
            }
            ArrayList<ObjectNode> arrayList = dataObjects;
            return arrayList;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }
}

