/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FileUtil {
    public static void writeFile(String fileName, String content) {
        FileUtil.writeFile(fileName, content, "utf-8");
    }

    public static void writeFile(String fileName, String content, String charset) {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), charset));){
            FileUtil.createFolder(fileName, true);
            out.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeFile(String fileName, InputStream is) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            byte[] bs = new byte[512];
            int n = 0;
            while ((n = is.read(bs)) != -1) {
                fos.write(bs, 0, n);
            }
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(String fileName) {
        File file = new File(fileName);
        String charset = FileUtil.getCharset(file);
        StringBuffer sb = new StringBuffer();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), charset));){
            String str = "";
            while ((str = in.readLine()) != null) {
                sb.append(str + "\r\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    public static String readZip(MultipartFile fileLoad, String fileName) {
        String xmlStr = "";
        try {
            String realFilePath = FileUtil.getWebRootPath() + "/attachFiles/tempZip/";
            String name = fileLoad.getOriginalFilename();
            String fileDir = name.substring(0, name.lastIndexOf("."));
            ZipUtil.unZipFile(fileLoad, realFilePath);
            realFilePath = realFilePath + fileDir;
            xmlStr = FileUtil.readFile(realFilePath + "/" + fileName);
            FileUtil.deleteDir(new File(realFilePath));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlStr;
    }

    public static String readByClassPath(String filePath) {
        return FileUtil.readByClassPath(filePath, null);
    }

    /*
     * Exception decompiling
     */
    public static String readByClassPath(String filePath, ClassLoader classLoader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isExistFile(String dir) {
        File[] files;
        boolean isExist = false;
        File fileDir = new File(dir);
        if (fileDir.isDirectory() && (files = fileDir.listFiles()) != null && files.length != 0) {
            isExist = true;
        }
        if (fileDir.isFile()) {
            return fileDir != null;
        }
        return isExist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCharset(File file) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int read;
            block28: {
                boolean checked = false;
                bis.mark(0);
                read = bis.read(first3Bytes, 0, 3);
                if (read == -1) {
                    String string = charset;
                    return string;
                }
                if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                    charset = "UTF-16LE";
                    checked = true;
                } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                    charset = "UTF-16BE";
                    checked = true;
                } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                    charset = "UTF-8";
                    checked = true;
                }
                bis.reset();
                if (checked) return charset;
                while ((read = bis.read()) != -1) {
                    if (read >= 240) {
                        return charset;
                    }
                    if (128 <= read && read <= 191) {
                        return charset;
                    }
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read) return charset;
                        if (read > 191) return charset;
                        continue;
                    }
                    if (224 > read || read > 239) {
                        continue;
                    }
                    break block28;
                }
                return charset;
            }
            read = bis.read();
            if (128 > read) return charset;
            if (read > 191) return charset;
            read = bis.read();
            if (128 > read) return charset;
            if (read > 191) return charset;
            charset = "UTF-8";
            return charset;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static byte[] readByte(InputStream is) {
        try {
            byte[] r = new byte[is.available()];
            is.read(r);
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readByte(String fileName) {
        try (FileInputStream fis = new FileInputStream(fileName);){
            byte[] r = new byte[fis.available()];
            fis.read(r);
            byte[] byArray = r;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeByte(String fileName, byte[] b) {
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(fileName));){
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            fos.write(b);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void serializeToFile(Object obj, String fileName) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(fileName));){
            out.writeObject(obj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object deserializeFromFile(String fileName) {
        File file = new File(fileName);
        Object obj = null;
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));){
            obj = in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    public static String inputStream2String(InputStream input, String charset) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(input, charset));
        StringBuffer buffer = new StringBuffer();
        String line = "";
        while ((line = in.readLine()) != null) {
            buffer.append(line + "\n");
        }
        return buffer.toString();
    }

    public static String inputStream2String(InputStream input) throws IOException {
        return FileUtil.inputStream2String(input, "utf-8");
    }

    public static File[] getFiles(String path) {
        File file = new File(path);
        return file.listFiles();
    }

    public static void createFolderFile(String path) {
        FileUtil.createFolder(path, true);
    }

    public static void createFolder(String path, boolean isFile) {
        File file;
        if (isFile) {
            path = path.substring(0, path.lastIndexOf(File.separator));
        }
        if (!(file = new File(path)).exists()) {
            file.mkdirs();
        }
    }

    public static void renameFolder(String path, String newName) {
        File file = new File(path);
        if (file.exists()) {
            file.renameTo(new File(newName));
        }
    }

    public static ArrayList<File> getDiretoryOnly(File dir) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (dir != null && dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            for (int i = 0; i < files.length; ++i) {
                dirs.add(files[i]);
            }
        }
        return dirs;
    }

    public ArrayList<File> getFileOnly(File dir) {
        ArrayList<File> dirs = new ArrayList<File>();
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        for (int i = 0; i < files.length; ++i) {
            dirs.add(files[i]);
        }
        return dirs;
    }

    public static boolean deleteFile(String path) {
        File file = new File(path);
        return file.delete();
    }

    public static boolean copyFile(String from, String to) {
        File fromFile = new File(from);
        File toFile = new File(to);
        try (FileInputStream fis = new FileInputStream(fromFile);
             FileOutputStream fos = new FileOutputStream(toFile);){
            int bytesRead;
            byte[] buf = new byte[4096];
            while ((bytesRead = fis.read(buf)) != -1) {
                fos.write(buf, 0, bytesRead);
            }
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void backupFile(String filePath) {
        String backupName = filePath + ".bak";
        File file = new File(backupName);
        if (file.exists()) {
            file.delete();
        }
        FileUtil.copyFile(filePath, backupName);
    }

    public static String getFileExt(File file) {
        if (file.isFile()) {
            return FileUtil.getFileExt(file.getName());
        }
        return "";
    }

    public static String getFileExt(String fileName) {
        int pos = fileName.lastIndexOf(".");
        if (pos > -1) {
            return fileName.substring(pos + 1).toLowerCase();
        }
        return "";
    }

    public static void copyDir(String fromDir, String toDir) throws IOException {
        new File(toDir).mkdirs();
        File[] file = new File(fromDir).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                String fromFile = file[i].getAbsolutePath();
                String toFile = toDir + "/" + file[i].getName();
                FileUtil.copyFile(fromFile, toFile);
            }
            if (!file[i].isDirectory()) continue;
            FileUtil.copyDirectiory(fromDir + "/" + file[i].getName(), toDir + "/" + file[i].getName());
        }
    }

    private static void copyDirectiory(String fromDir, String toDir) throws IOException {
        new File(toDir).mkdirs();
        File[] file = new File(fromDir).listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isFile()) {
                String fromName = file[i].getAbsolutePath();
                String toFile = toDir + "/" + file[i].getName();
                FileUtil.copyFile(fromName, toFile);
            }
            if (!file[i].isDirectory()) continue;
            FileUtil.copyDirectiory(fromDir + "/" + file[i].getName(), toDir + "/" + file[i].getName());
        }
    }

    public static String getFileSize(File file) throws IOException {
        if (file.isFile()) {
            int size = 0;
            try (FileInputStream fis = new FileInputStream(file);){
                size = fis.available();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return FileUtil.getSize(size);
        }
        return "";
    }

    public static String getSize(double size) {
        DecimalFormat df = new DecimalFormat("0.00");
        if (size > 1048576.0) {
            double ss = size / 1048576.0;
            return df.format(ss) + " M";
        }
        if (size > 1024.0) {
            double ss = size / 1024.0;
            return df.format(ss) + " KB";
        }
        return size + " bytes";
    }

    public static String getParentDir(String baseDir, String currentFile) {
        File f = new File(currentFile);
        String parentPath = f.getParent();
        String path = parentPath.replace(baseDir, "");
        return path.replace(File.separator, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromProperties(String fileName, String key) {
        String value = "";
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(fileName));
            Properties prop = new Properties();
            prop.load(stream);
            value = prop.getProperty(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveProperties(String fileName, String key, String value) {
        StringBuffer sb = new StringBuffer();
        boolean isFound = false;
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8"));
            while ((str = in.readLine()) != null) {
                if (str.startsWith(key)) {
                    sb.append(key + "=" + value + "\r\n");
                    isFound = true;
                    continue;
                }
                sb.append(str + "\r\n");
            }
            if (!isFound) {
                sb.append(key + "=" + value + "\r\n");
            }
            FileUtil.writeFile(fileName, sb.toString(), "utf-8");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delProperties(String fileName, String key) {
        StringBuffer sb = new StringBuffer();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8"));
            while ((str = in.readLine()) != null) {
                if (str.startsWith(key)) continue;
                sb.append(str + "\r\n");
            }
            FileUtil.writeFile(fileName, sb.toString(), "utf-8");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static List<Class<?>> getAllClassesByInterface(Class<?> interfaceClass, boolean samePackage) throws IOException, ClassNotFoundException, IllegalStateException {
        if (!interfaceClass.isInterface()) {
            throw new IllegalStateException("Class not a interface.");
        }
        ClassLoader $loader = interfaceClass.getClassLoader();
        String packageName = samePackage ? interfaceClass.getPackage().getName() : "/";
        return FileUtil.findClasses(interfaceClass, $loader, packageName);
    }

    private static List<Class<?>> findClasses(Class<?> interfaceClass, ClassLoader loader, String packageName) throws IOException, ClassNotFoundException {
        ArrayList allClasses = new ArrayList();
        String packagePath = packageName.replace(".", "/");
        if (!packagePath.equals("/")) {
            Enumeration<URL> resources = loader.getResources(packagePath);
            while (resources.hasMoreElements()) {
                URL $url = resources.nextElement();
                allClasses.addAll(FileUtil.findResources(interfaceClass, new File($url.getFile()), packageName));
            }
        } else {
            String path = loader.getResource("").getPath();
            allClasses.addAll(FileUtil.findResources(interfaceClass, new File(path), packageName));
        }
        return allClasses;
    }

    private static List<Class<?>> findResources(Class<?> interfaceClass, File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList $results = new ArrayList();
        if (!directory.exists()) {
            return Collections.EMPTY_LIST;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                if (file.getName().contains(".")) continue;
                if (!packageName.equals("/")) {
                    $results.addAll(FileUtil.findResources(interfaceClass, file, packageName + "." + file.getName()));
                    continue;
                }
                $results.addAll(FileUtil.findResources(interfaceClass, file, file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            Class<?> clazz = null;
            clazz = !packageName.equals("/") ? Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)) : Class.forName(file.getName().substring(0, file.getName().length() - 6));
            if (!interfaceClass.isAssignableFrom(clazz) || interfaceClass.equals(clazz)) continue;
            $results.add(clazz);
        }
        return $results;
    }

    public static Object cloneObject(Object obj) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(obj);
        out.close();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteIn);
        Object rtn = in.readObject();
        in.close();
        return rtn;
    }

    public static String getClassesPath() {
        String path = FileUtil.class.getClassLoader().getResource("").getPath();
        if ("\\".equals(File.separator)) {
            path = StringUtil.trimPrefix(path, "/");
        }
        path = path.replace("\\", "/");
        path = StringUtil.trimSuffix(path, "/");
        return path;
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.getClassesPath());
    }

    public static String getWebRootPath() {
        String path = FileUtil.getClassesPath();
        path = path.substring(0, path.lastIndexOf("WEB-INF"));
        path = StringUtil.trimSuffix(path, "/");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInput(InputStream is, OutputStream out) throws IOException {
        try {
            byte[] bs = new byte[1024];
            int n = 0;
            while ((n = is.read(bs)) != -1) {
                out.write(bs, 0, n);
            }
            out.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static String getIoTmpdir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static MultipartFile fileToMultipartFile(File file) {
        FileItem fileItem = FileUtil.createFileItem(file);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
        return multipartFile;
    }

    private static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static void fileDownload(HttpServletResponse response, InputStream inputStream, String fileName) throws Exception {
        byte[] data = org.aspectj.util.FileUtil.readAsByteArray((InputStream)inputStream);
        FileUtil.fileDownload(response, data, fileName);
    }

    public static void fileDownload(HttpServletResponse response, byte[] data, String fileName) throws Exception {
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ((OutputStream)outputStream).write(data);
        ((OutputStream)outputStream).flush();
        ((OutputStream)outputStream).close();
        response.flushBuffer();
    }
}

