package com.artfess.yhxt.statistics.manager;



import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.statistics.model.CamerasRequest;
import com.artfess.yhxt.statistics.model.ParamEntity;
import com.artfess.yhxt.statistics.model.PreviewURLsRequest;
import com.artfess.yhxt.statistics.vo.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2021/9/1
 */
public interface BaseDataStatisticsManager {
    /**
     * 桥梁统计
     *
     * @return
     */
    Map<String, List> getBridgeStatistics(Map<String,Object> map);

    /**
     * 上部数据结构导出
     * @param response
     * @param map
     */
    void export(HttpServletResponse response, Map<String, Object> map) throws Exception;

    Map<String, List> getAllStructureCount(Map<String, Object> map);

    /**
     * 各个分公司高危边坡数量
     */
    Map<String, List> getSideSlopCompany();

    /**
     * 各个分公司沿线设施数量
     * @return
     */
    Map<String, List> getRoadsideFacilitiesCompany();

    /**
     * 各个分公司路段数量
     * @return
     */
    Map<String, List> getRoadSectionCompany();

    /**
     * 各个分公司桥梁数量
     * @return
     */
    Map<String, List> getBridgeCompany();

    /**
     * 各个分公司隧道数量
     * @return
     */
    Map<String, List> getTunnelCompany();
    /**
     * 各个分公司涵洞数量
     * @return
     */
    Map<String, List> getCulvertCompany();

    /**
     * 桥梁隧道排行接口
     * @return
     */
    Map<String, List> getBridgeTunnelCountRanking();

    /**
     * 隧道统计
     * @param map
     * @return
     */
    Map<String, List> getTunnelStatistics(Map<String, Object> map);

    /**
     * 里程排行统计，按照公司统计
     * @return
     */
    //List<MileageVo> getMileage(BaseDataParamVo baseDataParamVo);

    /**
     * 里程排行统计,按照路段统计
     * @return
     */
    List<MileageVo> getRoadMileageCount(BaseDataParamVo baseDataParamVo);


    /**
     * 养护站
     * @param baseDataParamVo
     * @return
     * @throws Exception
     */
    List<MaintenanceStationVo> getMaintenanceStation(BaseDataParamVo baseDataParamVo) throws Exception;

    /**
     * 公司人员
     * @param baseDataParamVo
     * @return
     */
    List<CompanyUserVo> getUserCount(BaseDataParamVo baseDataParamVo);

    /**
     *  拼装路段数据
     * @param queryFilter
     * @return
     */
    String getRoad(QueryFilter queryFilter);
//沿线设施
    String getRoadsideFacilities(QueryFilter queryFilter);
//边坡
    String getSideSlop(QueryFilter queryFilter);
//桥梁
    String getBridgeInformation(QueryFilter queryFilter);
//隧道
    String getTunnelInformation(QueryFilter queryFilter);

    String getCulvertInformation(QueryFilter queryFilter);

    /**
     * 获取监控点预览取流URL
     * @return
     */
    Map getPreviewURLs(PreviewURLsRequest previewURLsRequest);

    List<CountRoadsideFacilities>  countRoadsideFacilities(BaseDataParamVo baseDataParamVo);

    List<CountVehicleVo> countVehicle(QueryFilter queryFilter);

    List<CountMileageVo> countAvgMileage(QueryFilter queryFilter);

    List<VehicleQuantityVo> countVehicleQuantity();

    void getCameras(CamerasRequest camerasRequest);


}
